<?php

namespace common\models;

use Yii;
use DateTime;
use DateTimeZone;
use yii\helpers\ArrayHelper;
/**
 * This is the model class for table "{{%tehnical}}".
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $Type
 * @property string $AdresseBundesland
 * @property string $AdresseOrt
 * @property string $AdresseStreat
 * @property string $AdresseStiege
 * @property string $Baujahr
 * @property string $Hersteller
 * @property integer $Nennlast
 * @property integer $Personen
 * @property string $Antriebsart
 * @property string $Nenngeschwindigkeit
 * @property string $Haltestellen
 * @property string $Ladestellen
 * @property string $Hubhohe
 * @property string $Gesetzt
 * @property integer $Profintervall
 * @property string $Betriebskontrollen
 *
 * @property User $user
 */
class Tehnical extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */


    public $aufname;
    public $auffunction;
    public $auftel;
    public $aufemail;
    public $wrfname;
    public $wrffunction;
    public $aufzugswarter_id;
    public $file;
    public $AllgemeinerZustandImages;

    public static function tableName()
    {
        return '{{%tehnical}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['fabric_id','user_id', 'FabriksNr', 'Type'], 'required'],
            [['user_id', 'Nennlast', 'Personen', 'Profintervall'], 'integer'],
            [['Baujahr', 'ErstelltAm', 'UmbauName', 'UmbauDate', 'Umfang', 'Letzte', 'LetzteDate', 'Notizen', 'Fakturenadresse', 'PreisWP', 'evaluierungName', 'evaluierungFristen', 'Zusatz', 'Notruftel', 'Schachtart', 'Anlagentyp', 'Wartungsart', 'ObjektNr', 'UIDNUMMER', 'Hausverwalter', 'HausverwalterEmail', 
            'send_email_to_coworkers', 'KontaktVerwalter', 'status', 'file', 'lat', 'lng', 
            'new_prufungen_date', 'new_prufungen_date_time', 'DatumderAbnahmeprufung', 'GerateNummer', 
            'Norm', 'Inspetkionsobjekt', 'Prufgrundlage', 'Durchfahrtslichte_in_m', 'AnzahltStellplatze', 
            'Parkeranagen', 'type2', 'KundenNr', 'Kunden_Rechnungszusatz', 'Kunden_Straße', 'Kunden_PLZ', 
            'Kunden_Ort', 'Kunden_Referenzzeile', 'Kunden_Rechnungsemail', 'AnlagenNrKunde', 'workerID',
            'AllgemeinerZustandImages', 'active'], 'safe'],
            [['Type', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'Hersteller', 'Antriebsart', 'Nenngeschwindigkeit', 'Haltestellen', 'Ladestellen', 'Hubhohe', 'Gesetzt', 'Betriebskontrollen'], 'string', 'max' => 255],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
            [['fabric_id'], 'exist', 'skipOnError' => true, 'targetClass' => Wartungsfirma::className(), 'targetAttribute' => ['fabric_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'user_id' => Yii::t('app', 'User ID'),
            'Type' => Yii::t('app', 'Type'),
            'AdresseBundesland' => Yii::t('app', 'Bundesland'),
            'AdresseOrt' => Yii::t('app', 'Ort'),
            'AdresseStreat' => Yii::t('app', 'Strasse'),
            'AdressePLZ' => Yii::t('app', 'PLZ'),
            'AdresseOrt' => Yii::t('app', 'Ort'),
            'Baujahr' => Yii::t('app', 'Baujahr'),
            'Hersteller' => Yii::t('app', 'Hersteller'),
            'Nennlast' => Yii::t('app', 'Nennlast'),
            'Personen' => Yii::t('app', 'Personen'),
            'Antriebsart' => Yii::t('app', 'Antriebsart'),
            'Nenngeschwindigkeit' => Yii::t('app', 'Nenngeschwindigkeit'),
            'Haltestellen' => Yii::t('app', 'Haltestellen'),
            'Ladestellen' => Yii::t('app', 'Ladestellen'),
            'Hubhohe' => Yii::t('app', 'Hubhohe'),
            'Gesetzt' => Yii::t('app', 'Gesetzt'),
            'Profintervall' => Yii::t('app', 'Profintervall'),
            'Betriebskontrollen' => Yii::t('app', 'Betriebskontrollen'),
            'Name' => Yii::t('app', 'UmbauName'),
            'Datum' => Yii::t('app', 'UmbauDate'),
            'Umfang' => Yii::t('app', 'Umfang'),
            'Name' => Yii::t('app', 'Letzte'),
            'Datum' => Yii::t('app', 'LetzteDate'),
            'Notizen' => Yii::t('app', 'Notizen'),
            'Fakturenadresse' => Yii::t('app', 'Fakturenadresse'),
            'Preis WP' => Yii::t('app', 'PreisWP'),
            'Name' => Yii::t('app', 'evaluierungName'),
            'Fristen' => Yii::t('app', 'evaluierungFristen'),
            'Zusatz' => Yii::t('app', 'Zusatz'),
            'Notruftel' => Yii::t('app', 'Notruftel'),
            'Schachtart' => Yii::t('app', 'Schachtart'),
            'Anlagentyp' => Yii::t('app', 'Anlagentyp'),
            'Wartungsart' => Yii::t('app', 'Wartungsart'),
            'ObjektNr' => Yii::t('app', 'ObjektNr'),
            'UIDNUMMER' => Yii::t('app', 'UIDNUMMER'),
            'Hausverwalter' => Yii::t('app', 'Hausverwalter'),
            'HausverwalterEmail' => Yii::t('app', 'HausverwalterEmail'),
            'send_email_to_coworkers' => Yii::t('app', 'send_email_to_coworkers'),
            'Norm' => Yii::t('app', 'Norm'),
            'Inspetkionsobjekt' => Yii::t('app', 'Inspetkionsobjekt'),
            'Prufgrundlage' => Yii::t('app', 'Prufgrundlage'),
            'Durchfahrtslichte_in_m' => Yii::t('app', 'Durchfahrtslichte in m'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getWartungsfirma()
    {
        return $this->hasOne(Wartungsfirma::className(), ['id' => 'fabric_id']);
    }

    public function getAufzugswarters() {
        return $this->hasMany(Aufzugswarter::className(), ['id' => 'aufzugswarter_id'])
          ->viaTable('aufzugswarter_tehnic_join', ['tehnic_id' => 'id']);
    }

    public function getTehnicReviews()
    {
        return $this->hasMany(TehnicReview::className(), ['tehnic_id' => 'id']);
    }

    public function gettehnic_review()
    {
        return $this->hasMany(TehnicReview::className(), ['tehnic_id' => 'id']);
    }

    public function s3path()
    {
        $s3_path = S3_PATH;
        return $s3_path."pdf/";
    }

    public function ifExistObjectNr( $object )
    {
        if ( $object && $object->ObjektNr ) {

            return true;
        }else {

            return false;
        }
    }

    public function decorateDate()
    {
        $today = date("Y.m.d");
        if ( $this->LetzteDate ) {

            $newDate = date("d-m-Y", strtotime($this->LetzteDate));
            $newDate = str_replace("-",".", $newDate);
            return $newDate;
        } else{

            if($this->getTehnicReviews() && $this->getTehnicReviews()->one() && $this->getTehnicReviews()->orderBy('id DESC')->one()->Prufungsdatum != null && $this->getTehnicReviews()->orderBy('id DESC')->one()->Prufungsdatum != "" ) {

                return $this->getTehnicReviews()->orderBy('id DESC')->one()->Prufungsdatum;
            }else {

                return "";
            }
        }
    }

    public function showAufzugswartersForLift()
    {

        if ( $this->getAufzugswarters() && $this->getAufzugswarters()->all() && count( $this->getAufzugswarters()->all() ) > 0 ) {
        
            $name = [];
            foreach ($this->getAufzugswarters()->all() as $key => $data) {

                array_push($name, $data->name);
            }
            return implode(", ", $name);
        }else {

            return "";
        }
    }

    public function formatLetzteDateDate()
    {

        if ( $this->LetzteDate ) {

            return date("d-m-Y", strtotime($model->LetzteDate));
        }else {
            return "";
        }
    }

    public function formatErstelltAmDate()
    {

        if ( $this->ErstelltAm ) {

            $date = date("d-m-Y", strtotime($this->ErstelltAm));
            return str_replace("-",".", $date);
        }else {
            return "";
        }
    }

    public function WiederkehrendeUberprufungExist()
    {

        $tehnic_review = $this->getTehnicReviews()->where(['Art' => ['Wiederkehrende Überprüfung', 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen']])->orderBy('id DESC')->one();

        if ( $tehnic_review ) {

            return true;
        }else {

            return false;
        }
    }


    public function getLastActualPrufungen()
    {

       # $today = date("d.m.Y");

        $tehnical_reviews = $this->getTehnicReviews()->where(['Art' => ['Wiederkehrende Überprüfung', 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen']])->orderBy('id DESC')->all();

        $before_sort = [];
        
        foreach ($tehnical_reviews as $key => $tehnic_review) {
            
            if ( ($tehnic_review->Art == "Wiederkehrende Überprüfung" || $tehnic_review->Art == 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen') && $tehnic_review->Prufungsdatum ) {

                $date = str_replace(".","-", $tehnic_review->Prufungsdatum);
                $date = DateTime::createFromFormat('d-m-Y', $date)->format('Y-m-d');
                $tehnic_review->Prufungsdatum = $date;
                array_push($before_sort, $tehnic_review);
            }
        }

        #ArrayHelper::multisort($before_sort, ['Prufungsdatum', 'id'], [SORT_ASC, SORT_DESC]);
        ArrayHelper::multisort($before_sort, ['Prufungsdatum'], [SORT_DESC]);

        foreach ($before_sort as $key => $tehnic_review) {
            $date = date("d-m-Y", strtotime($tehnic_review->Prufungsdatum));
            $date = str_replace("-",".", $date);
            $tehnic_review->Prufungsdatum = $date;

            return $tehnic_review;
        }
    }


    public function AnlagenHasGoogleCordinate() {

        if ( $this->lat && $this->lng ) {

            return true;
        }else {

            return false;
        }
    }


    public function lastPDF() 
    {
        $tehnical_reviews = $this->getTehnicReviews()->orderBy('id DESC')->all();

        foreach ( $tehnical_reviews as $key => $tehnic_review ) {

            if ( $tehnic_review && $tehnic_review->url ) {

                return $tehnic_review->url;
            }
        }
    }

    public function tehnic_review_with_pdf()
    {

        if ( $this->getTehnicReviews() && $this->getTehnicReviews()->one() ) {

            $tehnical_reviews = $this->getTehnicReviews()->orderBy('id DESC')->all();
            $pdf_array = [];

            foreach ( $tehnical_reviews as $key => $tehnic_review ) {

                if ( $tehnic_review && $tehnic_review->url ) {

                    array_push($pdf_array, $tehnic_review);
                }
            }

            return $pdf_array;
        }
    }

    public function PDFExist()
    {

        $pdf = $this->tehnic_review_with_pdf();

        if ( count($pdf) > 0 ) {

            return true;
        }else {

            return false;
        }
    }

    public function last_generate_PDF()
    {
       $tehnic_review = $this->getTehnicReviews()->where(['Art' => 'Wiederkehrende Überprüfung'])->orderBy('id DESC')->andWhere(['not', ['url' => null]])->one();
       if ( $tehnic_review )
       {
            return $this->s3path().$tehnic_review->url;
       }else {
            return "null";
       }
    }

    public function last_prufungen_mang()
    {
       $tehnic_review = $this->getTehnicReviews()->where(['Art' => 'Wiederkehrende Überprüfung'])->orderBy('id DESC')->andWhere(['not', ['url' => null]])->one();
       if ( $tehnic_review && $tehnic_review->Mangel != "" || $tehnic_review && $tehnic_review->Mangel !== null )
       {
            if ( $tehnic_review->Mangel == 1 ) {

                return "JA";
            }else {

                return "NEIN";
            }
        }else {
            return "null";
        }
    }

    public function checkForbidenType()
    {
        if ( $this->Type == "Spielplatzgeräte" ) {

            return false;
        }else if( $this->Type == "KFZ Parkeranlage" ) {

            return false;
        }else if ( $this->Type == "Arbeitsmittel" ) {

            return false;
        }else {

            return true;
        }
    }

    public function getTehnicalDocuments()
    {
        return $this->hasMany(TehnicalDocument::className(), ['tehnical_id' => 'id']);
    }

    public function getRestApi()
    {
        return $this->hasOne(RestApiAuth::className(), ['company_id' => 'id']);
    }
}