<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tehnic_review".
 *
 * @property integer $id
 * @property integer $tehnic_id
 * @property string $url
 * @property string $Art
 * @property string $Prufungsdatum
 * @property integer $Mangel
 *
 * @property Tehnical $tehnic
 */
class TehnicReview extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public $files;
    public $send_message_from_mail;
    public $send_standard_content_with_email;
    public $subject;
    public $upload_pdf = 0;
    public $emails;
    public $show_images_property = 0;
    public $remove_images = 0;
    public $remove_AllgemeinerZustandImages = 0;
    public $remove_Wartungsbuch = 0;
    public $show_AllgemeinerZustandImages_property = 0;
    public $show_Wartungsbuch_property = 0;

    public $image_file;
    public $image_description;

    public $gerat;
    public $gerat_image;
    public $gerat_mangel;
    public $destroy_images;
    public $gerat_mangel_type;
	
    public $fristText;
	
    public $mangel_text;
    public $mangel_frist;
    public $mangel_image;
	
    public $mangelsInputArray;
    public $numberOfFrist;
    public $numberOFMangel;
    
    public $mangels;
    public $sendToAPI = 0;
    public $arrayOfFrists;
#    public $AllgemeinerZustand;
    public $AllgemeinerZustandImages;
    public $Wartungsbuch;
    public $destroyAllgemeinerZustandImages;
    public $destroyAllWartungsbuch;
    public $remove_magels;

    public static function tableName()
    {
        return 'tehnic_review';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tehnic_id'], 'required'],
            [['AWStatus', 'image', 'files', 'url', 'send_mail', 'Mangel', 'datum', 'VollwartungEnthalten', 'Kostenschatzung', 'send_message_from_mail', 'send_standard_content_with_email', 'subject', 'upload_pdf', 'failure_lift', 'Anmerkungen', 'Frist', 'DieInstandhaltungderAnlagewar', 'tehn_text', 'new_prufungen_date_time', 'emails', 'photo_description', 'short_photo_description', 
            'image_file', 'image_description', 'gerat', 'gerat_image', 'gerat_mangel',
             'destroy_images', 'gerat_mangel_type', 'author_full_name', 'author_email', 'fristText',
             'mangel_text', 'mangel_frist', 'mangel_image', 'mangelsInputArray', 'numberOfFrist', 'numberOFMangel', 
             'coworker_active', 'mangels', 'sendToAPI', 'arrayOfFrists', 'AllgemeinerZustand',
             'AllgemeinerZustandImages', 'Wartungsbuch', 'destroyAllgemeinerZustandImages', 'destroyAllWartungsbuch', 'remove_magels'], 'safe'],
            [['files'], 'file', 'extensions' => 'jpg, png, jpeg', 'maxFiles' => 10],
            [['tehnic_id', 'Mangel'], 'integer'],
            [['url', 'Art', 'Prufungsdatum'], 'string', 'max' => 255],
            [['short_photo_description'], 'string', 'max' => 30],
            [['tehnic_id'], 'exist', 'skipOnError' => true, 'targetClass' => Tehnical::className(), 'targetAttribute' => ['tehnic_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'tehnic_id' => 'Tehnic ID',
            'url' => 'PDF',
            'Art' => 'Art',
            'Prufungsdatum' => 'Prufungsdatum',
            'Mangel' => 'Mangel',
            'destroy_images' => '',
            'AWStatus' => 'AW Status'
        ];
    }

    public function showImage() {

        $s3_env = S3_PATH;
        return $this->image ? $s3_env. "image/".$this->image : "https://dummyimage.com/180/000000/fff.png&text=Profile+image";
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTehnic()
    {
        return $this->hasOne(Tehnical::className(), ['id' => 'tehnic_id']);
    }

    public function gettehnical()
    {
        return $this->hasOne(Tehnical::className(), ['id' => 'tehnic_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getImages()
    {
        return $this->hasMany(Images::className(), ['review_id' => 'id']);
    }

    public function getPrufungImages()
    {
        return $this->hasMany(PrufungenImage::className(), ['tehnic_review_id' => 'id']);
    }

    public function decorateDate()
    {   
        $pruff = $this->Prufungsdatum;

        if ( $pruff ) {

            $newDate = date("d-m-Y", strtotime($pruff));
            $newDate = str_replace("-",".", $newDate);
            return $newDate;
        }else {

            return "Not Set";
        }
    }

    public function formatPrufungsdatum()
    {

        if ( $this->Prufungsdatum ) {

            $newDate = date("d-m-Y", strtotime($this->Prufungsdatum));
            $newDate = str_replace("-",".", $newDate);

            return $newDate;
        }else {
            return "";
        }
    }


    public function formatDatum()
    {

        if ( $this->datum ) {

            $newDate = date("d-m-Y", strtotime($this->datum));
            $newDate = str_replace("-",".", $newDate);

            return $newDate;
        }else {
            return "";
        }
    }

    public function IsWiederkehrendeUberprufung()
    {

        if ( $this->Prufungsdatum != null && $this->Prufungsdatum != "" && ($this->Art == "Wiederkehrende Überprüfung" || $this->Art == "Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen") ) {

            return true;
        }else {
            
            return false;
        }
    }

    public function display_spielplatzgerat_object()
    {

        return $this->getImages()->where(['gerat_image' => null])->orderBy(['id' => SORT_ASC])->all();
    }

    public function display_spielplatzgerat_object_exists()
    {
        $images = $this->getImages()->where(['gerat_image' => null])->all();

        if ( $images && count( $images ) > 0 ) {

            return true;
        }

        return false;
    }

    public function display_gerat_object()
    {

        return $this->getImages()->where(['name' => null])->orderBy(['id' => SORT_ASC])->all();
    }

    public function display_gerat_object_exists()
    {

        $images = $this->getImages()->where(['name' => null])->all();

        if ( $images && count( $images ) > 0 ) {

            return true;
        }

        return false;        
    }

    public function getMangels()
    {
        return $this->hasMany(Magel::className(), ['tehnic_review_id_integer' => 'id']);
    }

    public function getMangelsPhotos() {
        $mangels = $this->getMangels()->all();
        $images = array();

        foreach ($mangels as $key => $mangel) {
            if($mangel->photo) {
                array_push($images, $mangel->photo);
            }
        }

        if(count( $images ) > 0) {
            return true;
        }else {
            return false;
        }
     }

    public function display_allgemeiner_zustand_images()
    {

        return $this->getPrufungImages()->where(['type' => 'AllgemeinerZustandImages'])->orderBy(['id' => SORT_ASC])->all();
    }

    public function display_allgemeiner_zustand_images_exists()
    {
        $images = $this->getPrufungImages()->where(['type' => 'AllgemeinerZustandImages'])->all();

        if ( $images && count( $images ) > 0 ) {

            return true;
        }

        return false;
    }

    public function display_wartungsbuch_images()
    {

        return $this->getPrufungImages()->where(['type' => 'Wartungsbuch'])->orderBy(['id' => SORT_ASC])->all();
    }

    public function display_wartungsbuch_images_exists()
    {
        $images = $this->getPrufungImages()->where(['type' => 'Wartungsbuch'])->all();

        if ( $images && count( $images ) > 0 ) {

            return true;
        }

        return false;
    }

    public function ensure_exist_api_for_anlagen($model) {

        $user_id = $model->getTehnic()->one()->user_id;
        $api = RestApiAuth::find()->where(['company_id' => $user_id])->one();

        if( $api && isset($api->id) ) {
            return true;
        }else {
            return false;
        }

    }

    public function ensure_exist_api_for_anlagen_from_tehnical($tehnical) {

        $user_id = $tehnical->user_id;
        $api = RestApiAuth::find()->where(['company_id' => $user_id])->one();

        if( $api && isset($api->id) ) {
            return true;
        }else {
            return false;
        }

    }
}
