<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "prufungen_image".
 *
 * @property integer $id
 * @property string $url
 * @property string $descritpion
 * @property integer $tehnic_review_id
 * @property string $Type
 *
 * @property TehnicReview $tehnicReview
 */
class PrufungenImage extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'prufungen_image';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['descritpion'], 'string'],
            [['tehnic_review_id'], 'required'],
            [['tehnic_review_id'], 'integer'],
            [['url', 'Type'], 'string', 'max' => 255],
            [['tehnic_review_id'], 'exist', 'skipOnError' => true, 'targetClass' => TehnicReview::className(), 'targetAttribute' => ['tehnic_review_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'url' => 'Url',
            'descritpion' => 'Descritpion',
            'tehnic_review_id' => 'Tehnic Review ID',
            'Type' => 'Type',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTehnicReview()
    {
        return $this->hasOne(TehnicReview::className(), ['id' => 'tehnic_review_id']);
    }

    public function showPrufungenImage() {

        $s3_env = S3_PATH;
        return $this->url ? $s3_env. "image/".$this->url : "https://dummyimage.com/180/000000/fff.png&text=Profile+image";
    }

    public function showImage() {

        $s3_env = S3_PATH;
        return $this->url ? $s3_env. "image/".$this->url : "https://dummyimage.com/180/000000/fff.png&text=Upload+image";
    }

    public function showImageInNewTab() {

        $s3_env = S3_PATH;
        return $this->url ? $s3_env. "image/".$this->url : false;
    }

}
