<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "magel".
 *
 * @property integer $id
 * @property integer $tehnic_review_id_integer
 * @property string $mangel
 * @property string $frist
 * @property string $photo
 *
 * @property TehnicReview $tehnicReviewIdInteger
 */
class Magel extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'magel';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tehnic_review_id_integer'], 'required'],
            [['tehnic_review_id_integer'], 'integer'],
            [['photo'], 'string'],
            [['mangel', 'frist', 'al'], 'string', 'max' => 255],
            [['type'], 'integer'],
            [['tehnic_review_id_integer'], 'exist', 'skipOnError' => true, 'targetClass' => TehnicReview::className(), 'targetAttribute' => ['tehnic_review_id_integer' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'tehnic_review_id_integer' => 'Tehnic Review Id Integer',
            'mangel' => 'Mangel',
            'frist' => 'Frist',
            'al' => 'AI',
            'photo' => 'Photo',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTehnicReviewIdInteger()
    {
        return $this->hasOne(TehnicReview::className(), ['id' => 'tehnic_review_id_integer']);
    }

    public function showImageInNewTab() {

        $s3_env = S3_PATH;
        return $this->photo ? $s3_env. "image/".$this->photo : false;
    }

    public function showImage() {

        $s3_env = S3_PATH;
        return $this->photo ? $s3_env. "image/".$this->photo : "https://dummyimage.com/180/000000/fff.png&text=Upload+image";
    }
}
