<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "invoice_data".
 *
 * @property integer $id
 * @property string $KundenNr
 * @property string $Kunden_Rechnungszusatz
 * @property string $Kunden_Strase
 * @property string $Kunden_PLZ
 * @property string $Kunden_Ort
 * @property string $Kunden_Referenzzeilec
 * @property string $Kunden_Rechnungsemail
 */

class InvoiceData extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'invoice_data';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['KundenNr'], 'required'],
            [['KundenNr', 'Kunden_Rechnungszusatz', 'Kunden_Strase', 'Kunden_PLZ', 'Kunden_Ort', 'Kunden_Referenzzeilec', 'Kunden_Rechnungsemail', 'Kunden_Rechnungszusatz'], 'string', 'max' => 255],
        ];
    }

    /***
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'KundenNr' => 'Kunden Nr',
            'Kunden_Rechnungszusatz' => 'Kunden  Rechnungszusatz',
            'Kunden_Strase' => 'Kunden  Straße',
            'Kunden_PLZ' => 'Kunden  Plz',
            'Kunden_Ort' => 'Kunden  Ort',
            'Kunden_Referenzzeilec' => 'Kunden  Referenzzeilec',
            'Kunden_Rechnungsemail' => 'Kunden Rechnungsemail',
        ];
    }
}
