<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "images".
 *
 * @property integer $id
 * @property integer $review_id
 * @property string $name
 * @property string $description
 *
 * @property TehnicReview $review
 */
class Images extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'images';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['review_id'], 'required'],
            [['review_id'], 'integer'],
            [['gerat', 'gerat_image', 'gerat_mangel', 'gerat_mangel_type'], 'safe'],
            [['description'], 'string'],
            [['name'], 'string', 'max' => 255],
            [['review_id'], 'exist', 'skipOnError' => true, 'targetClass' => TehnicReview::className(), 'targetAttribute' => ['review_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'review_id' => 'Review ID',
            'name' => 'Name',
            'description' => 'Description',
        ];
    }

    public function showImage() {

        $s3_env = S3_PATH;
        return $this->name ? $s3_env. "image/".$this->name : "https://dummyimage.com/180/000000/fff.png&text=Upload+image";
    }

    public function showGeratImage() {

        $s3_env = S3_PATH;
        return $this->gerat_image ? $s3_env. "image/".$this->gerat_image : "https://dummyimage.com/180/000000/fff.png&text=Upload+image";
    }

    public function showImageInNewTab() {

        $s3_env = S3_PATH;
        return $this->name ? $s3_env. "image/".$this->name : false;
    }

    public function showGeratImageInNewTab() {

        $s3_env = S3_PATH;
        return $this->gerat_image ? $s3_env. "image/".$this->gerat_image : false;
    }
    /**
     * @return \yii\db\ActiveQuery
     */
    public function getReview()
    {
        return $this->hasOne(TehnicReview::className(), ['id' => 'review_id']);
    }

}