<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "google_cordinates".
 *
 * @property integer $id
 * @property string $lat
 * @property string $lng
 */
class GoogleCordinate extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'google_cordinates';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tehnical_id'], 'required'],
            [['tehnical_id'], 'unique'],
            [['lng', 'lat'], 'string', 'max' => 255],
            [['lat', 'lng'], 'safe'],
            [['anlagen_cordinates',], 'integer'],
        ];
    }

    public function getTehnic()
    {
        return $this->hasOne(Tehnical::className(), ['id' => 'tehnic_id']);
    }
    
    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'lat' => 'Lat',
            'lng' => 'Lng',
        ];
    }
}
