<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "betreiber".
 *
 * @property integer $id
 * @property string $name
 * @property string $title
 * @property string $short_name
 *
 * @property RestApiAuth[] $restApiAuths
 */
class Betreiber extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'betreiber';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'title', 'short_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'title' => 'Title',
            'short_name' => 'Short Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRestApiAuths()
    {
        return $this->hasMany(RestApiAuth::className(), ['company_id' => 'id']);
    }
}
