<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "aufzugswarter_tehnic_join".
 *
 * @property integer $tehnic_id
 * @property integer $aufzugswarter_id
 *
 * @property Aufzugswarter $aufzugswarter
 * @property Tehnical $tehnic
 */
class AufzugswarterTehnicJoin extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'aufzugswarter_tehnic_join';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['tehnic_id', 'aufzugswarter_id'], 'required'],
            [['tehnic_id', 'aufzugswarter_id'], 'integer'],
            [['aufzugswarter_id'], 'exist', 'skipOnError' => true, 'targetClass' => Aufzugswarter::className(), 'targetAttribute' => ['aufzugswarter_id' => 'id']],
            [['tehnic_id'], 'exist', 'skipOnError' => true, 'targetClass' => Tehnical::className(), 'targetAttribute' => ['tehnic_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'tehnic_id' => 'Tehnic ID',
            'aufzugswarter_id' => 'Aufzugswarter ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAufzugswarter()
    {
        return $this->hasOne(Aufzugswarter::className(), ['id' => 'aufzugswarter_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTehnic()
    {
        return $this->hasOne(Tehnical::className(), ['id' => 'tehnic_id']);
    }
}
