<?php

namespace common\models;

use Yii;


/**
 * This is the model class for table "aufzugswarter".
 *
 * @property integer $id
 * @property string $name
 * @property string $function
 * @property string $tel
 * @property string $email
 *
 * @property AufzugswarterTehnicJoin[] $aufzugswarterTehnicJoins
 */
class Aufzugswarter extends \yii\db\ActiveRecord
{
    public $tehnic_id;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'aufzugswarter';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['function'], 'string', 'max' => 255],
            [['email', "tel", "GepruftAm"], 'safe'],
           // [['email'], 'unique'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'function' => 'Function',
            'tel' => 'Tel',
            'email' => 'Email',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAufzugswarterTehnicJoins()
    {
        return $this->hasMany(AufzugswarterTehnicJoin::className(), ['aufzugswarter_id' => 'id']);
    }


    public function getTehnicals() {
        return $this->hasMany(Tehnical::className(), ['id' => 'tehnical_id'])
          ->viaTable('aufzugswarter_tehnic_join', ['aufzugswarter_id' => 'id']);
    }
}
