<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\LinkPager;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Wartungsfirma');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="wartungsfirma-index">
    <div class="header-content">
        <h1 class="admin-title">Wartungsfirma</h1>
        <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success', 'data-toggle' =>"tooltip", 'title'=> "Neuer Wartungsfirma !"]) ?>
    </div>
    <?php if( $desktop ): ?>
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
               'rowOptions' => function ($model) {
            },
            'filterModel' => $searchModel,
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                'name',
                'function',
                ['class' => 'yii\grid\ActionColumn'],
            ],
            'tableOptions' => [
                'id' => 'theDatatable',
                'class'=>'table table-striped table-bordered table-grid-small'
            ],
        ]); ?>
    <?php else: ?>
        <?php $form = ActiveForm::begin([
                'action' => ['index'],
                'method' => 'get',
            ]); ?>
            <label>Seach User:</label>
            <?= $form->field($searchModelGlobal, 'globalSearch')->textInput(['maxlength' => true, 'placeholder' => 'Search'])->label(false); ?>
            <div class="form-group">
                <?= Html::submitButton('Search', ['class' => 'btn btn-primary hide']) ?>
            </div>
        <?php ActiveForm::end(); ?>
        <?php foreach ($wartungsfirmas->getModels() as $key => $model ): ?>
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>Name</td>
                        <td><?= $model->name ?></td>
                    </tr>
                    <tr>
                        <td>Function</td>
                        <td><?= $model->function ?></td>
                    </tr>
                    <tr>
                        <td>Update</td>
                        <td><?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                    </tr>
                    <tr>
                        <td>Details</td>
                        <td><?= Html::a('Details', ['view', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                    </tr>
                </tbody>
            </table>
        <?php endforeach ?>
            <div class="pagination">
                <?php
                echo LinkPager::widget([
                'pagination' => $wartungsfirmas->pagination,
            ]); ?>
            </div>
    <?php endif ?>
</div>
