<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\Url;
use kartik\spinner\Spinner;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use kartik\select2\Select2;
use common\models\Tehnical;
use yii\widgets\LinkPager;
/* @var $this yii\web\View */
/* @var $searchModel common\models\search\TehinicalSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Anlagen');
$this->params['breadcrumbs'][] = $this->title;
$data = ArrayHelper::map(Tehnical::find()->all(),'id','FabriksNr', 'LetzteDate', 'AdressePLZ');

?>
<div class="tehnical-index">
    <div class="header-content header-content-mobile">
        <h1>Anlagen</h1>
        <div class="button-wrapper">
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Neuer Anlagen !"]) ?>
            <button href="#" class="btn btn-primary export-file btn-mobile-position" data-toggle = "tooltip" title= "Import data from Excel !"><span class="glyphicon glyphicon-upload"></span></button>
            <?= Html::a('<span class="glyphicon glyphicon-download"></span>', ['export/download', 'user_id' => "null"], ['class' => 'btn btn-info btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Export data to Excel !"]) ?>
            <button href="#" class="btn btn-primary google-file btn-mobile-position" data-toggle = "tooltip" title= "Add lat and lng !"><span class="glyphicon glyphicon-map-marker"></span></button>
            <div class="excel-import-group hide">
                <?php $form = ActiveForm::begin(['action' => ['tehnical/import'],'options' => ['method' => 'post', 'class' => 'admin-form']]) ?>
                    <?= $form->field($excel_object, 'file')->widget(FileInput::classname(), ['options' => ['accept' => 'xlsx/*', 'class' => 'select-excel position-excel-anlagen'],
                        'pluginOptions'=>[
                            'allowedFileExtensions'=>['xlsx', 'xml'],
                            'showUpload' => false,
                            'showRemove' => false,
                            'overwriteInitial' => true,
                        ],
                    ]) ?>
                    <?= Html::submitButton('Import Excel', ['class' => 'btn btn-primary btn-large btn-spinner']) ?>
                <?php ActiveForm::end(); ?>
            </div>
            <div class="form-google hide">
                <?php $form = ActiveForm::begin(['action' => ['karte/create'],'options' => ['method' => 'post', 'class' => 'admin-form']]) ?>
                    <?= $form->field($google, 'anlagen_cordinates')->widget(Select2::classname(), [
                        'data' => $data,
                        'language' => 'de',
                        'options' => ['multiple' => true, 'placeholder' => 'Select ...'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ])->label(false); ?>
                    <?= Html::submitButton('Save', ['class' => 'btn btn-primary btn-large btn-spinner']) ?>
                <?php ActiveForm::end(); ?>
            </div>
            <?= Html::a('<span class="glyphicon glyphicon-list-alt"></span>', ['coworkers'], 
            ['class' => 'btn btn-block btn-primary btn-coworkers']) ?>
            <?= Html::a(Yii::t('app', $title), [$link], ['class' => 'btn btn-danger btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "inactivate !"]) ?>
        </div>
    </div>
    <div class="position-excel-anlagen-wrapper">
    </div>
    <?php if( $desktop ): ?>
        <?php Pjax::begin(); ?>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                   'rowOptions' => function ($model) {
                    if ($model->status != 'Aktiv') {
                        return ['class' => 'alert-for-nicht-aktiv'];
                    }
                },
                'filterModel' => $searchModel,
                'columns' => [
                    ['label' => 'Anlagen Nr',
                       'attribute' => "id",
                       'value' => function ($data){ return "AT".$data->id; },
                    ],                
                ],
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],
                    ['label' => 'Anlagen Nr',
                       'attribute' => "id",
                       'value' => function ($data){ return "AT".$data->id; },
                    ],
                    //'user_id',
                    'FabriksNr',
                    ['label' => 'Prüfungsdatum',
                       'attribute' => "LetzteDate",
                       'value' => function ($data){ return $data->LetzteDate; },
                    ],
                    'AdressePLZ',
                    'AdresseOrt',
                    'AdresseStreat',
                    'Zusatz',
                    'Type',
                    [
                        'label' => 'Betreiber',
                        'attribute' => "Betreiber",
                        'value' => function ($data){ return $data->getUser()->one()->Betreiber; },
                    ],
                    //'ErstelltAm',
                    // 'Baujahr',
                    // 'Hersteller',
                    // 'Nennlast',
                    // 'Personen',
                    // 'Antriebsart',
                    // 'Nenngeschwindigkeit',
                    // 'Haltestellen',
                    // 'Ladestellen',
                    // 'Hubhohe',
                    // 'Gesetzt',
                    // 'Profintervall',
                    // 'Betriebskontrollen',
                    [
                        'format' => 'raw',
                        'label' => 'Prüfungen',
                        'value' => function($model, $key, $index, $column) {
                                return Html::a(
                                    '+',
                                    Url::to(['tehnical/review', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['tehnical/review', "id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-glyphicon-plus',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "NEU",
                                    ]
                                );
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => 'PDF',
                        'value' => function($model, $key, $index, $column) {
                                return Html::a(
                                    '',
                                    Url::to(['pdf/pdf-view', "id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['pdf/pdf-view', "id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-list-alt',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "PDF",
                                        'target'=>'_blank', 
                                    ]
                                );
                        }
                    ],
                    ['class' => 'yii\grid\ActionColumn'],
                ],
                'tableOptions' => [
                    'id' => 'theDatatable',
                    'class'=>'table table-striped table-bordered table-grid-view'
                ],
            ]); ?>
        <?php Pjax::end(); ?>
    <?php else: ?>
        <?php Pjax::begin(); ?>
            <?php $form = ActiveForm::begin([
                    'action' => ['index'],
                    'method' => 'get',
                ]); ?>
                <label>Seach Anlagen:</label>
                <?= $form->field($searchModelGlobal, 'globalSearch')->textInput(['maxlength' => true, 'placeholder' => 'Search'])->label(false); ?>
                <div class="form-group">
                    <?= Html::submitButton('Search', ['class' => 'btn btn-primary hide']) ?>
                </div>
            <?php ActiveForm::end(); ?>
            <?php foreach ($tehnicals_mobile->getModels() as $key => $model ): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Fabriks Nr</td>
                            <td><?= $model->FabriksNr ?></td>
                        </tr>
                        <tr>
                            <td>PLZ</td>
                            <td><?= $model->AdressePLZ ?></td>
                        </tr>
                        <tr>
                            <td>Ort</td>
                            <td><?= $model->AdresseOrt ?></td>
                        </tr>
                        <tr>
                            <td>Strasse</td>
                            <td><?= $model->AdresseStreat ?></td>
                        </tr>
                        <tr>
                            <td>Zusatz</td>
                            <td><?= $model->Zusatz ?></td>
                        </tr>
                        <tr>
                            <td>Prüfungsdatum</td>
                            <td><?= $model->LetzteDate ?></td>
                        </tr>
                        <tr>
                            <td>Prüfungen</td>
                            <td><?= Html::a('<span class="glyphicon">+</span>', ['tehnical/review', "id" => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                        <tr>
                            <td>PDF</td>
                            <td><?= Html::a('<span class="glyphicon glyphicon-list-alt"></span>', ['pdf/pdf-view', "id" => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                        <tr>
                            <td>Details</td>
                            <td><?= Html::a('Details', ['view', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach ?>
                <div class="pagination">
                    <?php
                    echo LinkPager::widget([
                    'pagination' => $tehnicals_mobile->pagination,
                ]); ?>
                </div>
        <?php Pjax::end(); ?>
    <?php endif ?>
</div>
<div class="spinner-well hide">
    <?= Spinner::widget([
        'preset' => Spinner::LARGE,
        'color' => 'blue',
        'align' => 'center'
    ])?>
</div>
