<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\User;
use common\models\Type;
use common\models\Type2;
use common\models\Antriebsart;
use common\models\Nenngeschwindigkeit;
use common\models\Gesetzt;
use common\models\LastRegularCheckBy;
use common\models\Betriebskontrollen;
use common\models\Profintervall;
use common\models\Aufzugswarter;
use common\models\Anlagentyp;
use common\models\Wartungsart;
use common\models\AnlagenStatus;
use common\models\Schachtart;
use yii\helpers\ArrayHelper;
use dosamigos\datepicker\DatePicker;
use common\models\Wartungsfirma;
use common\models\Evaluierung;
use kartik\select2\Select2;
use dosamigos\tinymce\TinyMce;
use common\models\Norm;
use common\models\Prufgrundlage;



/* @var $this yii\web\View */
/* @var $model common\models\Tehnical */
/* @var $form yii\widgets\ActiveForm */
$data = ArrayHelper::map(Aufzugswarter::find()->all(),'id','name');
?>

<div class="tehnical-form">
    <?php $form = ActiveForm::begin(); ?>
        <?= $form->field($model, 'active')->checkbox(['class' => "role_chackbox-child"]) ?>
        <?= $form->field($model, 'user_id')->dropDownList(ArrayHelper::map($clients,'id','Betreiber'), ['prompt' => 'Select Kundennumer']) ?>
        <?= $form->field($model, 'FabriksNr')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'AnlagenNrKunde')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Type')->dropDownList(ArrayHelper::map(Type::find()->all(),'name','name'), ['prompt' => 'Select Type']) ?>
        <?= $form->field($model, 'type2', ['options' => ['class' => 'does-belong-to-arbeitsmittel hide']])->dropDownList(ArrayHelper::map(Type2::find()->all(),'name','name'), ['prompt' => 'Select Type 2'])->label("Type 2") ?>

        <?php if( $desktop ): ?>
            <div class="address">
                <label class="control-label" for="tehnical-adresseort">Adresse</label>
                <div class="adresse-tehnic">
                    <?= $form->field($model, 'AdresseOrt')->textInput(['maxlength' => true])->label("Ort") ?>
                    <?= $form->field($model, 'AdresseStreat')->textInput(['maxlength' => true])->label("Strasse") ?>
                    <?= $form->field($model, 'AdressePLZ')->textInput(['maxlength' => true])->label("PLZ") ?>
                    <?= $form->field($model, 'Zusatz')->textInput(['maxlength' => true])->label("Zusatz") ?>
                </div>
            </div>
        <?php else: ?>
            <?= $form->field($model, 'AdresseOrt')->textInput(['maxlength' => true])->label("Ort") ?>
            <?= $form->field($model, 'AdresseStreat')->textInput(['maxlength' => true])->label("Strasse") ?>
            <?= $form->field($model, 'AdressePLZ')->textInput(['maxlength' => true])->label("PLZ") ?>
            <?= $form->field($model, 'Zusatz')->textInput(['maxlength' => true])->label("Zusatz") ?>
        <?php endif ?>

        <?= $form->field($model, 'Baujahr')->dropDownList(array_combine(range(1900, 2100), range(1900, 2100)), ['prompt' => 'Select Baujahr']) ?>
        <?= $form->field($model, 'Hersteller')->textInput(['maxlength' => true]) ?>
        <div class="does-belong-to-spielgrate hide">
            <?= $form->field($model, 'Norm')->dropDownList(ArrayHelper::map(Norm::find()->all(),'name','name'), ['prompt' => 'Select Norm']) ?>
        </div>
        <?= $form->field($model, 'Inspetkionsobjekt', ['options' => ['class' => 'does-belong-to-spielgrate hide']])->textInput() ?>
        <div class="does-belong-to-spielgrate does-belong-to-arbeitsmittel does-belong-to-parkeranlage hide">
            <?= $form->field($model, 'Prufgrundlage')->dropDownList(ArrayHelper::map(Prufgrundlage::find()->all(),'name','name'), ['prompt' => 'Select Prufgrundlage']) ?>
        </div>
        <?= $form->field($model, 'Nennlast', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-arbeitsmittel']])->textInput() ?>
        <?= $form->field($model, 'Durchfahrtslichte_in_m', ['options' => ['class' => 'does-belong-to-arbeitsmittel hide']])->textInput() ?>
        <?= $form->field($model, 'Personen', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel']])->textInput() ?>
        <?= $form->field($model, 'AnzahltStellplatze', ['options' => ['class' => 'does-belong-to-parkeranlage hide']])->textInput() ?>
        <?= $form->field($model, 'Antriebsart', ['options' => ['class' => 'does-not-belong-to-spielgrate']])->dropDownList(ArrayHelper::map(Antriebsart::find()->all(),'name','name'), ['prompt' => 'Select Antriebsart']) ?>
        <?= $form->field($model, 'Nenngeschwindigkeit')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Haltestellen', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel']])->textInput() ?>
        <?= $form->field($model, 'Parkeranagen', ['options' => ['class' => 'does-belong-to-parkeranlage hide']])->textInput() ?>

        <?= $form->field($model, 'Ladestellen', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel']])->textInput() ?>
        <?= $form->field($model, 'Hubhohe', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel']])->textInput() ?>
        <?= $form->field($model, 'Gesetzt', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel']])->dropDownList(ArrayHelper::map(Gesetzt::find()->all(),'name','name'), ['prompt' => 'Select Gesetzt']) ?>

        <?php if( $model && $model->Profintervall ): ?>
            <?= $form->field($model, 'Profintervall')->dropDownList(ArrayHelper::map(Profintervall::find()->all(),'name','name'), ['prompt' => 'Select Profintervall' ])->label("Prüfintervall") ?>
        <?php else: ?>
            <?= $form->field($model, 'Profintervall')->dropDownList(ArrayHelper::map(Profintervall::find()->all(),'name','name'), ['prompt' => 'Select Profintervall', 'value' => '12' ])->label("Prüfintervall") ?>
        <?php endif ?>

        <?= $form->field($model, 'Betriebskontrollen', ['options' => ['class' => 'does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel']])->dropDownList(ArrayHelper::map(Betriebskontrollen::find()->all(),'name','name'), ['prompt' => 'Select Betriebskontrollen']) ?>
        <?= $form->field($model, 'Notizen', ['options' => ['class' => '']])->widget(TinyMce::className(), [
            'options' => ['rows' => 5],
            'language' => 'de',
            'clientOptions' => [
                'branding' => false,
                'plugins' => [
                    "advlist autolink lists link charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste"
                ],
                'toolbar' => "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
            ]
        ]);?>

        <?= $form->field($model, 'Fakturenadresse')->textInput(['maxlength' => true]) ?>

        <?= $form->field($model, 'PreisWP')->textInput(['maxlength' => true]) ?>
        
        <div class="aufzugswarter-from-tehnical does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel">
            <h3>Aufzugswarter</h3>
            <?= $form->field($model, 'aufzugswarter_id')->widget(Select2::classname(), [
                'data' => $data,
                'language' => 'de',
                'options' => ['multiple' => true, 'placeholder' => 'Select a state ...'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]) ?>
        </div>
        <div class="wartungsfirma-from-tehnical">
            <h3>Wartungsfirma</h3>
            <?= $form->field($model, 'fabric_id')->dropDownList(ArrayHelper::map(Wartungsfirma::find()->all(),'id','name'), ['prompt' => 'Select Wartungsfirma']) ?>
        </div>
        <div class="aufzugswarter-from-tehnical">

            <h3>Umbau</h3>

            <?= $form->field($model, 'UmbauName')->textInput(['maxlength' => true])->label("Umbau") ?>

            <?= $form->field($model, 'UmbauDate')->dropDownList(range(1900, 2100, 1), array('class' =>'form-control',
          'prompt' =>'Select Umbau Datum')); ?>

            <?= $form->field($model, 'Umfang')->widget(TinyMce::className(), [
                'options' => ['rows' => 5],
                'language' => 'de',
                'clientOptions' => [
                    'branding' => false,
                    'plugins' => [
                        "advlist autolink lists link charmap print preview anchor",
                        "searchreplace visualblocks code fullscreen",
                        "insertdatetime media table contextmenu paste"
                    ],
                    'toolbar' => "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
                ]
            ])->label("Umbau Datum");?>

        </div>
        <div class="aufzugswarter-from-tehnical">
            <h3>Letzte Regelmäßige Prüfung durc</h3>
            <?= $form->field($model, 'workerID')->dropDownList(ArrayHelper::map($workers,'id','email'), ['prompt' => 'Select Worker'])->label('Worker') ?>
            <?= $form->field($model, 'Letzte')->dropDownList(ArrayHelper::map(LastRegularCheckBy::find()->all(),'name','name'), ['prompt' => 'Select LastRegularCheckBy']) ?>
            <div class="form-group">
                <label class="control-label" for="tehnical-letztedate">Datum</label>
                <?= DatePicker::widget([
                    'model' => $model,
                    'attribute' => 'LetzteDate',
                    'template' => '{addon}{input}',
                        'clientOptions' => [
                            'autoclose' => true,
                            'format' => 'dd.mm.yyyy'
                        ]
                ]);?>
            </div>        
        </div>
        <div class="does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel">
            <div class="aufzugswarter-from-tehnical">
                <h3>Evaluierung</h3>
                <?= $form->field($model, 'evaluierungName')->dropDownList(ArrayHelper::map(Evaluierung::find()->all(),'name','name'), ['prompt' => 'Select Evaluierung']) ?>
                <div class="form-group">
                    <label class="control-label" for="tehnical-evaluierungfristen">Fristen</label>
                    <?= DatePicker::widget([
                        'model' => $model,
                        'attribute' => 'evaluierungFristen',
                        'template' => '{addon}{input}',
                            'clientOptions' => [
                                'autoclose' => true,
                                'format' => 'yyyy-m-dd'
                            ]
                    ]);?>
                </div>
            </div>
            <?= $form->field($model, 'Schachtart')->dropDownList(ArrayHelper::map(Schachtart::find()->all(),'name','name'), ['prompt' => 'Select Schachtart']) ?>
            <?= $form->field($model, 'Anlagentyp')->dropDownList(ArrayHelper::map(Anlagentyp::find()->all(),'name','name'), ['prompt' => 'Select Wartungsart']) ?>
            <?= $form->field($model, 'Wartungsart')->dropDownList(ArrayHelper::map(Wartungsart::find()->all(),'name','name'), ['prompt' => 'Select Wartungsart']) ?>
        </div>
        <?= $form->field($model, 'ObjektNr')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'UIDNUMMER')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Hausverwalter')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'HausverwalterEmail')->textInput(['maxlength' => true])->label("Hausverwalter Email") ?>
        <?= $form->field($model, 'KontaktVerwalter')->textInput(['maxlength' => true])->label("Verwalter Tel.") ?>
        <?php if( $model && $model->status ): ?>
            <?= $form->field($model, 'status')->dropDownList(ArrayHelper::map(AnlagenStatus::find()->all(),'name','name'), ['prompt' => 'Select Status']) ?>
        <?php else: ?>
            <?= $form->field($model, 'status')->dropDownList(ArrayHelper::map(AnlagenStatus::find()->all(),'name','name'), ['prompt' => 'Select Status', 'value' => 'Aktiv']) ?>
        <?php endif ?>
        <div>
            <h3>Google Maps - GPS coordinates, latitude and longitude</h3>
            <?= $form->field($model, 'lat')->textInput(['maxlength' => true])->label("latitude"); ?>
            <?= $form->field($model, 'lng')->textInput(['maxlength' => true])->label("longitude"); ?>
        </div>
        <div class="does-not-belong-to-spielgrate does-not-belong-to-parkeranlage does-not-belong-to-arbeitsmittel">
            <div class="form-group">
                <label class="control-label" for="tehnical-datumderabnahmeprufung">Datum der Abnahmeprüfung</label>
                <?= DatePicker::widget([
                    'model' => $model,
                    'attribute' => 'DatumderAbnahmeprufung',
                    'template' => '{addon}{input}',
                        'clientOptions' => [
                            'autoclose' => true,
                            'format' => 'dd.mm.yyyy'
                        ]
                ]);?>
            </div>
        </div>
        <?= $form->field($model, 'KundenNr')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Kunden_Rechnungszusatz')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Kunden_Straße')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Kunden_PLZ')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Kunden_Ort')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Kunden_Referenzzeile')->textInput(['maxlength' => true]) ?>
        <?= $form->field($model, 'Kunden_Rechnungsemail')->textInput(['maxlength' => true]) ?>
        <div class="form-group <?= $desktop ? '' : 'text-center' ?>">
            <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        </div>

    <?php ActiveForm::end(); ?>
</div>