<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Tehnical */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Anlagen'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$s3_path = S3_PATH;
?>
<div class="tehnical-view">
    <div class="header-content header-content-mobile">
        <h1 class="admin-title"><?= Html::encode($model->FabriksNr) ?> Details</h1>
        <div>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['review', "id" => $model->id], ['class' => 'btn btn-info btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Neuer Prüfungen !"]) ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-copy"></span>'), ['copy', "id" => $model->id], ['class' => 'btn btn-success btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Copy Anlagen !"]) ?>
            <?php if( $model->WiederkehrendeUberprufungExist() ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-edit"></span>'), ['wiederkehrende', 'id' => $model->id], ['class' => 'btn btn-warning btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Update Prüfungen !"]) ?>
            <?php endif ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-pencil"></span>'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Update Anlagen !"]) ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-trash"></span>'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Remove Anlagen !",
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ]) ?>
            <?php if( $google_map_exist ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-erase"></span>'), ['unmark', 'id' => $model->id], ['class' => 'btn btn-default btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Remove Anlagen from Google Map ( Karte Marked ) !"]) ?>
            <?php else: ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-map-marker"></span>'), ['karte', 'id' => $model->id], ['class' => 'btn btn-default btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Add Anlagen to the Google Map ( Karte Marked ) !"]) ?>
            <?php endif ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-list-alt"></span>'), ['pdf/pdf-view', "id" => $model->id], ['class' => 'btn btn-primary btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "PDF", 'target'=>'_blank']) ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-print"></span>'), ['pdf/beschreibung-pdf', "id" => $model->id], ['class' => 'btn btn-orange btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Beschreibung PDF", 'target'=>'_blank']) ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-paperclip"></span>'), ['documents', "id" => $model->id], ['class' => 'btn btn-info btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Neuer Document !"]) ?>
        </div>
    </div>
    <?php if( $desktop ): ?>
        <div class="detail-view-widget">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'ObjektNr',
                    'active',
                    [
                        'label' => 'Anlagen Nr',
                        'value' => function ($data){ return "AT".$data->id; },
                    ],
                    [
                        'label' => 'User',
                        'value' => function ($data){ return $data->getUser()->one()->email; },
                    ],
                    [
                        'label' => 'Firma',
                        'value' => function ($data){ return $data->getUser()->one()->Betreiber; },
                    ],
                    'Type',
                    'FabriksNr',
                    'AnlagenNrKunde',
                    'AdresseOrt',
                    'AdresseStreat',
                    'AdressePLZ',
                    'Zusatz',
                    'Baujahr',
                    'Hersteller',
                    'Nennlast',
                    'Personen',
                    'Antriebsart',
                    'Anlagentyp',
                    'Schachtart',
                    'Nenngeschwindigkeit',
                    'Haltestellen',
                    'Ladestellen',
                    [
                        'label' => 'Hubhöhe',
                        'value' => function ($data){ return $data->Hubhohe; },
                    ],
                    [
                        'label' => 'Gesetz',
                        'value' => function ($data){ return $data->Gesetzt; },
                    ],
                    [
                        'label' => 'Prüfintervall',
                        'value' => function ($data){ return $data->Profintervall; },
                    ],
                    'Betriebskontrollen',
                    [
                        'label' => 'Erstellt am',
                        'value' => function ($data){ return $data->formatErstelltAmDate(); },
                    ],
                    [
                        'label' => 'Umbau',
                        'value' => function ($data){ return $data->UmbauName; },
                    ],
                    [
                        'label' => 'Umbau Datum',
                        'value' => function ($data){ return $data->UmbauDate; },
                    ],
                    [
                        'label' => 'Umfang',
                        'value' => function ($data){ return strip_tags($data->Umfang); },
                    ],
                    [
                        'label' => 'Letzter Prüfer',
                        'value' => function ($data){ return strip_tags($data->Letzte); },
                    ],
                    [
                        'label' => 'Prüfungsdatum',
                        'value' => function ($data){ return $data->LetzteDate; },
                    ],
                    'Fakturenadresse',
                    'PreisWP',
                    'evaluierungName',
                    'evaluierungFristen',
                    'Notruftel',
                    'Wartungsart',
                    'UIDNUMMER',
                    'Hausverwalter',
                    [
                        'label' => 'Hausverwalter Email',
                        'value' => function ($data){ return $data->HausverwalterEmail; },
                    ],
                    [
                        'label' => 'Verwalter Tel.',
                        'value' => function ($data){ return $data->KontaktVerwalter; },
                    ],
                    'status',
                    'lat',
                    'lng',
                    [
                        'label' => 'Datum der Abnahmeprüfung',
                        'value' => function ($data){ return $data->DatumderAbnahmeprufung; },
                    ],
                    'KundenNr',
                    'Kunden_Rechnungszusatz',
                    'Kunden_Straße',
                    'Kunden_PLZ',
                    'Kunden_Ort',
                    'Kunden_Referenzzeile',
                    'Kunden_Rechnungsemail'
                ],
            ]) ?>
        </div>
        <?php if ( $model->Notizen != "" || $model->Notizen != null ): ?>
            <h1>Notizen</h1>
            <div>
                <?= $model->Notizen ?>
            </div>
        <?php endif ?>

        <h1>Aufzugswärter</h1>
        <table class="table table-striped table-bordered table-grid-small">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Funktion</th>
                    <th>Telefonnummer</th>
                    <th>Email</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($model->getAufzugswarters()->all() as $key => $data): ?>
                    <tr>
                        <td><?= $data->name ?></td>
                        <td><?= $data->function ?></td>
                        <td><?= $data->tel ?></td>
                        <td><?= $data->email ?></td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
        </div>
        <h1>Wartungsfirma</h1>
        <table class="table table-striped table-bordered table-grid-small">
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Funktion</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><?= $model->getWartungsfirma()->one()->name ?></td>
                    <td><?= $model->getWartungsfirma()->one()->function ?></td>
                </tr>
            </tbody>
        </table>
        <table class="table table-striped table-bordered table-grid-small">
            <thead>
                <tr>
                    <th>Datum</th>
                    <th>Prüfungsdatum</th>
                    <th>Art</th>
                    <th>Mängel</th>
                    <th>in Vollwart. enth.</th>
                    <th>Kostenschätzung</th>
                    <th>PDF</th>
                    <th>Fotos</th>
                    <th>Mängel Fotos</th>
                    <?php if ( $rest_api && isset($rest_api->id) ): ?>
                        <th>Allgemeiner Zustand Fotos</th>
                        <th>Wartungsbuch Fotos</th>
                    <?php endif ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($model->getTehnicReviews()->orderBy(['id' => SORT_DESC])->all() as $key => $application): ?>
                    <tr>
                        <td><?= $application->formatDatum(); ?></td>
                        <?php if ( $application->Prufungsdatum != null || $application->Prufungsdatum != ""  ): ?>
                            <td><?= $application->formatPrufungsdatum(); ?></td>  
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>   
                        <td><?= $application->Art; ?></td>
                        <?php if ( $application->Mangel != "" || $application->Mangel !== null ): ?>
                            <td><?= $application->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                        <td class="VollwartungEnthalten-desktop-width"><?= $application->VollwartungEnthalten; ?></td>
                        <td><?= $application->Kostenschatzung; ?></td>
                        <?php if ( $application->url != null || $application->url != ""  ): ?>
                            <td>
                                <?php $link= $s3_path."pdf/". $application->url ?>
                                <a target="_blank" href="<?php echo $link; ?>" class="btn btn-success">Download PDF</a>
                            </td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                        <td>
                            <?php if ( count( $application->getImages()->all() ) > 0 ): ?>
                                <?= Html::a('Fotos', ['fotos/view', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                <div>
                                    <?= $application->short_photo_description ?>
                                </div>
                            <?php endif ?>
                        </td>
                        <td>
                            <?php if ( $application->getMangelsPhotos() ): ?>
                                <?= Html::a('Fotos', ['fotos/mangel-photo', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                            <?php endif ?>
                        </td>
                        <td>
                            <?php if ( isset($rest_api->id) && $application->display_allgemeiner_zustand_images_exists() ): ?>
                                <?= Html::a('Fotos', ['fotos/allgemeiner-zustand', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                            <?php endif ?>
                        </td>
                        <td>
                            <?php if ( isset($rest_api->id) && $application->display_wartungsbuch_images_exists() ): ?>
                                <?= Html::a('Fotos', ['fotos/wartungsbuch', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                            <?php endif ?>
                        </td>
                    </tr>
                <?php endforeach ?>  
            </tbody>
        </table>
    <?php else: ?>
        <div class="mobile-table-wrapper">
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>Objekt Nr</td>
                        <td><?= $model->ObjektNr ?></td>
                    </tr>
                    <tr>
                        <td>Anlagen Nr</td>
                        <td><?= $model->id ?></td>
                    </tr>
                    <tr>
                        <td>Betreiber</td>
                        <td><?= $model->getUser()->one()->Betreiber ?></td>
                    </tr>
                    <tr>
                        <td>Fabriks Nr</td>
                        <td><?= $model->FabriksNr ?></td>
                    </tr>
                    <tr>
                        <td>Prüfungsdatum</td>
                        <td><?= $model->LetzteDate ?></td>
                    </tr>
                    <tr>
                        <td>PLZ</td>
                        <td><?= $model->AdressePLZ ?></td>
                    </tr>
                    <tr>
                        <td>Ort</td>
                        <td><?= $model->AdresseOrt ?></td>
                    </tr>
                    <tr>
                        <td>Strasse</td>
                        <td><?= $model->AdresseStreat ?></td>
                    </tr>
                    <tr>
                        <td>Zusatz</td>
                        <td><?= $model->Zusatz ?></td>
                    </tr>
                    <tr>
                        <td>Type</td>
                        <td><?= $model->Type ?></td>
                    </tr>
                    <tr>
                        <td>Baujahr</td>
                        <td><?= $model->Baujahr ?></td>
                    </tr>
                    <tr>
                        <td>Hersteller</td>
                        <td><?= $model->Hersteller ?></td>
                    </tr>
                    <tr>
                        <td>Nennlast</td>
                        <td><?= $model->Nennlast ?></td>
                    </tr>
                    <tr>
                        <td>Personen</td>
                        <td><?= $model->Personen ?></td>
                    </tr>
                    <tr>
                        <td>Antriebsart</td>
                        <td><?= $model->Antriebsart ?></td>
                    </tr>
                    <tr>
                        <td>Anlagentyp</td>
                        <td><?= $model->Anlagentyp ?></td>
                    </tr>
                    <tr>
                        <td>Schachtart</td>
                        <td><?= $model->Schachtart ?></td>
                    </tr>
                    <tr>
                        <td>Nenngeschwindigkeit</td>
                        <td><?= $model->Nenngeschwindigkeit ?></td>
                    </tr>
                    <tr>
                        <td>Haltestellen</td>
                        <td><?= $model->Haltestellen ?></td>
                    </tr>
                    <tr>
                        <td>Ladestellen</td>
                        <td><?= $model->Ladestellen ?></td>
                    </tr>
                    <tr>
                        <td>Hubhöhe</td>
                        <td><?= $model->Hubhohe ?></td>
                    </tr>
                    <tr>
                        <td>Gesetz</td>
                        <td><?= $model->Gesetzt ?></td>
                    </tr>
                    <tr>
                        <td>Prüfintervall</td>
                        <td><?= $model->Profintervall ?></td>
                    </tr>
                    <tr>
                        <td>Erstellt am</td>
                        <td><?= $model->formatErstelltAmDate() ?></td>
                    </tr>
                    <tr>
                        <td>Umbau</td>
                        <td><?= $model->UmbauName ?></td>
                    </tr>
                    <tr>
                        <td>Umbau Datum</td>
                        <td><?= $model->UmbauDate ?></td>
                    </tr>
                    <tr>
                        <td>Umfang</td>
                        <td><?= $model->Umfang ?></td>
                    </tr>
                    <tr>
                        <td>Letzter Prüfer</td>
                        <td><?= $model->Letzte ?></td>
                    </tr>
                    <tr>
                        <td>Prüfungsdatum</td>
                        <td><?= $model->LetzteDate ?></td>
                    </tr>
                    <tr>
                        <td>Fakturenadresse</td>
                        <td><?= $model->Fakturenadresse ?></td>
                    </tr>
                    <tr>
                        <td>Preis WP</td>
                        <td><?= $model->PreisWP ?></td>
                    </tr>
                    <tr>
                        <td>Evaluierung Name</td>
                        <td><?= $model->evaluierungName ?></td>
                    </tr>
                    <tr>
                        <td>Evaluierung Fristen</td>
                        <td><?= $model->evaluierungFristen ?></td>
                    </tr>
                    <tr>
                        <td>Notruftel</td>
                        <td><?= $model->Notruftel ?></td>
                    </tr>
                    <tr>
                        <td>Wartungsart</td>
                        <td><?= $model->Wartungsart ?></td>
                    </tr>
                    <tr>
                        <td>UIDNUMMER</td>
                        <td><?= $model->UIDNUMMER ?></td>
                    </tr>
                    <tr>
                        <td>Hausverwalter</td>
                        <td><?= $model->Hausverwalter ?></td>
                    </tr>
                    <tr>
                        <td>Hausverwalter Email</td>
                        <td><?= $model->HausverwalterEmail ?></td>
                    </tr>
                    <tr>
                        <td>Verwalter Tel.</td>
                        <td><?= $model->KontaktVerwalter ?></td>
                    </tr>
                    <tr>
                        <td>Status</td>
                        <td><?= $model->status ?></td>
                    </tr>
                    <tr>
                        <td>Lat</td>
                        <td><?= $model->lat ?></td>
                    </tr>
                    <tr>
                        <td>Lng</td>
                        <td><?= $model->lng ?></td>
                    </tr>
                    <tr>
                        <td>Datum der Abnahmeprüfung</td>
                        <td><?= $model->DatumderAbnahmeprufung ?></td>
                    </tr>
                </tbody>
            </table>
            <?php if ( $model->Notizen != "" || $model->Notizen != null ): ?>
                <h1>Notizen</h1>
                <div>
                    <?= $model->Notizen ?>
                </div>
            <?php endif ?>

            <h1>Aufzugswärter</h1>
            <?php foreach ($model->getAufzugswarters()->all() as $key => $data): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Name</td>
                            <td><?= $data->name ?></td>
                        </tr>
                        <tr>
                            <td>Funktion</td>
                            <td><?= $data->function ?></td>
                        </tr>
                        <tr>
                            <td>Telefonnummer</td>
                            <td><?= $data->tel ?></td>
                        </tr>
                        <tr>
                            <td>Email</td>
                            <td><?= $data->email ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach ?>
            <h1>Wartungsfirma</h1>
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>Name</td>
                        <td><?= $model->getWartungsfirma()->one()->name ?></td>
                    </tr>
                    <tr>
                        <td>Funktion</td>
                        <td><?= $model->getWartungsfirma()->one()->function ?></td>
                    </tr>
                </tbody>
            </table>
            <h1>Prüfungen</h1>
            <?php foreach ($model->getTehnicReviews()->orderBy(['id' => SORT_DESC])->all() as $key => $application): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Datum</td>
                            <td><?= $application->formatDatum(); ?></td>
                        </tr>
                        <tr>
                            <td>Prüfungsdatum</td>
                            <?php if ( $application->Prufungsdatum != null || $application->Prufungsdatum != ""  ): ?>
                                <td><?= $application->formatPrufungsdatum(); ?></td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>
                        </tr>
                        <tr>
                            <td>Art</td>
                            <td><?= $application->Art; ?></td>
                        </tr>
                        <tr>
                            <td>Mängel</td>
                            <?php if ( $application->Mangel != "" || $application->Mangel !== null ): ?>
                                <td><?= $application->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>
                        </tr>
                        <tr>
                            <td>in Vollwart. enth.</td>
                            <td><?= $application->VollwartungEnthalten; ?></td>
                        </tr>
                        <tr>
                            <td>Kostenschätzung</td>
                            <td><?= $application->Kostenschatzung; ?></td>
                        </tr>
                        <tr>
                            <td>PDF</td>
                            <?php if ( $application->url != null || $application->url != ""  ): ?>
                                <td>
                                    <?php $link= $s3_path."pdf/". $application->url ?>
                                    <a target="_blank" href="<?php echo $link; ?>">Download PDF</a>
                                </td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>                            
                        </tr>
                        <tr>
                            <td>Fotos</td>
                            <td>
                                <?php if ( count( $application->getImages()->all() ) > 0 ): ?>
                                    <div>
                                        <?= $application->short_photo_description ?>
                                    </div>
                                    <?= Html::a('Fotos', ['fotos/view', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                <?php endif ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Mängel Fotos</td>
                            <td>
                                <?php if ( $application->getMangelsPhotos() ): ?>
                                    <?= Html::a('Fotos', ['fotos/mangel-photo', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                <?php endif ?>
                            </td>
                        </tr>
                        <?php if ( isset($rest_api->id) && $application->display_allgemeiner_zustand_images_exists() ): ?>
                            <tr>
                                <td>                    
                                    Allgemeiner Zustand Fotos
                                </td>
                                <td>
                                    <?= Html::a('Fotos', ['fotos/allgemeiner-zustand', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                </td>
                            </tr>
                        <?php endif ?>
                    </tbody>
                </table>
            <?php endforeach ?>
        </div>
    <?php endif ?>
    <?php if ( isset($documents[0]) ): ?>
        <h1>Documents</h1>
        <table class="table table-striped table-bordered table-grid-small">
            <thead>
                <tr>
                    <th>Documents</th>
                    <th>Delete</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($documents as $key => $document): ?>
                    <tr>                       
                        <?php if ( $document->url != null || $document->url != ""  ): ?>
                            <td>
                                <?php $link= $s3_path."documents/". $document->url ?>
                                <a target="_blank" href="<?php echo $link; ?>" class="btn btn-success"><?= $document->name; ?></a>
                            </td>
                            <td>
                                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-trash"></span>'), ['remove-document', 'document_id' => $document->id, 'id' => $model->id], [
                                    'class' => 'btn btn-danger btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Remove Document !",
                                    'data' => [
                                        'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                                        'method' => 'post',
                                    ],
                                ]) ?>
                            </td>
                        <?php else: ?>
                            <td></td>
                            <td></td>
                        <?php endif ?>
                    </tr>
                <?php endforeach ?>  
            </tbody>
        </table>
    <?php endif ?>
    <?= $show_google_map; ?>
</div>