<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model common\models\TehnicReview */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Prüfungen'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
$s3_path = S3_PATH;
$link= $s3_path."pdf/". $model->url;
?>
<div class="tehnic-review-view">
    <div class="header-content header-content-mobile">
        <h1 class="admin-title"><?= Html::encode($this->title) ?> Details</h1>
        <div>
            
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-pencil"></span>'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary', 'data-toggle' =>"tooltip", 'title'=> "Update Prüfungen !"]) ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-trash"></span>'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger', 'data-toggle' =>"tooltip", 'title'=> "Remove Prüfungen !",
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ]) ?>
        </div>
    </div>
    <?php if( $desktop ): ?>
        <div class="detal-view-widget">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'id',
                    'tehnic_id',
                    'Art',
                    [
                        'label' => 'Prufungsdatum',
                        'attribute' => 'Prufungsdatum',
                        'value' => function ($data){ 
                            if ( $data->Prufungsdatum != null || $data->Prufungsdatum != ""  ) {

                                return $data->formatPrufungsdatum();
                            }else {

                                return "";
                            }
                        }
                    ],
                    [
                        'label' => 'datum',
                        'attribute' => 'datum',
                        'value' => function ($data){ 
                            if ( $data->datum != null || $data->datum != ""  ) {

                                return $data->formatDatum();
                            }else {

                                return "";
                            }
                        }
                    ],
                    [
                        'label' => 'Mangel',
                        'value' => function ($data){ 
                            if( $data->Mangel != "" || $data->Mangel !== null ) {

                                return $data->Mangel == 1 ? 'JA' : 'NEIN';
                            }else {

                                return "";
                            }

                            return $data->Mangel == 1 ? 'JA' : 'NEIN'; },
                    ],
                    [
                        'label' => 'Kostenschatzung',
                        'value' => function ($data){ return $data->Kostenschatzung. " €"; },
                    ],
                    'VollwartungEnthalten',
                    [
                        'attribute'=>'Show PDF',
                        'format'=>'raw',
                        'value'=>  Html::a( 'PDF', Url::to($link), ['target'=>'_blank'] ),
                    ],
                    [
                        'attribute'=>'Failure Prufungen',
                        'value' => function ($data){ return $data->tehn_text; },
                    ],
                    'Anmerkungen',
                    'Frist',
                    'DieInstandhaltungderAnlagewar',
                ],
            ]) ?>
        </div>
    <?php else: ?>
        <div class="mobile-table-wrapper">
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>Prufungen ID</td>
                        <td><?= $model->id ?></td>
                    </tr>
                    <tr>
                        <td>Anlagen Fabriks Nr</td>
                        <td><?= $model->getTehnic()->one()->FabriksNr; ?></td>
                    </tr>
                    <tr>
                        <td>Art</td>
                        <td><?= $model->Art; ?></td>
                    </tr>
                    <tr>
                        <td>Mangel</td>
                        <?php if( $model->Mangel != "" || $model->Mangel !== null ): ?>
                            <td><?= $model->Mangel == 1 ? 'JA' : 'NEIN' ?></td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                    </tr>
                    <tr>
                        <td>Kostenschatzung</td>
                        <td><?= $model->Kostenschatzung; ?></td>
                    </tr>
                    <tr>
                        <td>VollwartungEnthalten</td>
                        <td><?= $model->VollwartungEnthalten; ?></td>
                    </tr>
                    <tr>
                        <td>PDF</td>
                        <td><a href="<?= $link ?>" target="_blank">PDF</a></td>
                    </tr>
                    <tr>
                        <td>Failure Prufungen</td>
                        <td><?= $model->tehn_text; ?></td>
                    </tr>
                    <tr>
                        <td>Anmerkungen</td>
                        <td><?= $model->Anmerkungen; ?></td>
                    </tr>
                    <tr>
                        <td>Frist</td>
                        <td><?= $model->Frist; ?></td>
                    </tr>
                    <tr>
                        <td>DieInstandhaltungderAnlagewar</td>
                        <td><?= $model->DieInstandhaltungderAnlagewar; ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    <?php endif ?>
    <div>
        <p>Author: <?= $model->author_full_name ?></p>
        <p>Email: <?= $model->author_email ?></p>
    </div>
</div>