<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
?>

<div class="panel-group" id="accordion">
  <div class="panel panel-default">
    <div class="panel-heading">
      <h4 class="panel-title">
        <a class="accordion-toggle spielplatzgerat-caret" data-toggle="collapse" data-parent="#accordion" href="#panel2">Inspektionsobjekt Fotos  <span class="caret caret-start-position"></span></a>
      </h4>
    </div>
    <div id="panel2" class="panel-collapse collapse">
      <div class="panel-body">
        <div class="card card-body">
          <?php if( $model->display_spielplatzgerat_object_exists() ): ?>
            <div class="image-card-group">
              <?php foreach ($model->display_spielplatzgerat_object() as $key => $image): ?>
                <label for="<?= $image->id ?>">
                  <div class="card-wrapper">
                    <div class="card card-image">
                      <?= Html::img( $image->showImage(), ['class' => 'card-img-top', 'height' => 150, 'width' => 200]);?>
                      <div class="card-body">
                        <?= $form->field($model, 'destroy_images[]')->checkbox(['label' => '', 'value' => $image->id, 'id' => $image->id, 'class' => "image_chackbox hide" ]); ?>
                        <p class="card-text"><?= $image->description ?></p>
                      </div>
                    </div>
                  </div>
                </label>
              <?php endforeach ?>
            </div>
          <?php else: ?>
            <h2>Empty</h2>
          <?php endif ?>
        </div>
      </div>
    </div>
  </div>
  <div class="panel panel-default">
    <div class="panel-heading">
      <h4 class="panel-title">
        <a class="accordion-toggle spielplatzgerat-caret" data-toggle="collapse" data-parent="#accordion" href="#panel1">Gerät Fotos  <span class="caret caret-start-position"></span></a>
      </h4>
    </div>
    <div id="panel1" class="panel-collapse collapse">
      <div class="panel-body">
        <div class="card card-body">
          <div class="image-card-group">
            <?php if( $model->display_gerat_object_exists() ): ?>
              <?php foreach ($model->display_gerat_object() as $key => $image): ?>
                <label for="<?= $image->id ?>">
                  <div class="card-wrapper">
                    <div class="card card-image">
                      <?= Html::img( $image->showGeratImage(), ['class' => 'card-img-top', 'height' => 150, 'width' => 200]);?>
                      <div class="card-body">
                        <?= $form->field($model, 'destroy_images[]')->checkbox([ 'label' => '', 'value' => $image->id, 'id' => $image->id, 'class' => "image_chackbox hide" ]); ?>
                        <p class="card-text"><?= $image->gerat ?></p>
                      </div>
                    </div>
                  </div>
                </label>
              <?php endforeach ?>
            <?php else: ?>
              <h2>Empty</h2>
            <?php endif ?>
          </div>     
        </div>
      </div>
    </div>
  </div>
</div>
