<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
$s3_path = S3_PATH;
/* @var $this yii\web\View */
/* @var $model common\models\Magel */
/* @var $form yii\widgets\ActiveForm */

?>

<div class="magel-form">
    <?php $form = ActiveForm::begin(); ?>
    <?php if( $model->type == 1 ): ?>
        <?= $form->field($model, 'al')->textInput(['maxlength' => true]) ?>
    <?php endif ?>    
    <?= $form->field($model, 'mangel')->textInput(['maxlength' => true]) ?>
    <?= $form->field($model, 'frist')->textInput(['maxlength' => true]) ?>
    
    <?= $form->field($model, 'photo')->widget(FileInput::classname(), ['options' => ['accept' => 'image/*'],
        'pluginOptions'=>[
            'allowedFileExtensions'=>['jpg', 'png','jpeg'],
            'showUpload' => true,
            'initialPreview' => [
                $model->photo ? Html::img($s3_path. 'image/'.$model->photo) : null, // checks the models to display the preview
            ],
            'overwriteInitial' => true,
        ],
    ])->label("Images") ?>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
