<?php

/* @var $this \yii\web\View */
/* @var $content string */

use backend\assets\AppAsset;
use common\models\Responsive;
use common\models\User;
use common\widgets\Alert;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\helpers\Html;
use yii\widgets\Breadcrumbs;

$id = Yii::$app->user->getId();
if ($id) {

	$user = User::find()->where(['id' => $id])->one();
	$desktop = $user->getResponsive()->desktop;
} else {

	$user = null;
	$desktop = Responsive::findOne(1)->desktop;
}

if ($user && $user->role_id == "4") {

	$logo_url = Yii::$app->homeUrl . "coworkers/admin/index";
} else {

	$logo_url = Yii::$app->homeUrl;
}

AppAsset::register($this);
?>
<?php $this->beginPage()?>
<!DOCTYPE html>
<html lang="<?=Yii::$app->language?>">
<head>
    <meta charset="<?=Yii::$app->charset?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="SHORTCUT ICON" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" />
    <link rel="icon" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" />
    <link rel="shortcut icon" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" type="image/x-icon" />
    <link rel="shortcut icon" href="<?php echo Yii::$app->request->baseUrl; ?>/favicon.ico" type="image/x-icon" />
    <link href="https://fonts.googleapis.com/css?family=Encode+Sans+Expanded|Lato|Montserrat|Open+Sans|Raleway|Roboto" rel="stylesheet">
    <?=Html::csrfMetaTags()?>
    <title><?=Html::encode($this->title)?></title>
    <?php $this->head()?>
</head>
<body>
<?php $this->beginBody()?>

<div class="wrap">
    <?php
NavBar::begin([
	'brandLabel' => Html::img(Yii::$app->request->baseUrl . '/images/FI_logo.jpg', ['alt' => Yii::$app->name, 'class' => 'img-responsive img-freie']),
	'brandUrl' => $logo_url,
	'options' => [
		'class' => 'navbar-inverse navbar-fixed-top',
	],
]);
if (Yii::$app->user->getId() && $user->role_id == '1') {
	$menuItems = [
		['label' => $desktop ? '<span class="glyphicon glyphicon-phone navbar-responsive-logo"></span>' : '<span class="glyphicon glyphicon-modal-window navbar-responsive-logo"></span>', 'url' => ['/responsive/index']],
		['label' => 'Kunden', 'url' => ['/admin/index']],
		['label' => 'Anlagen', 'url' => ['/tehnical/index']],
		['label' => 'Prüfungen', 'url' => ['/tehnic-review']],
		['label' => 'Marked', 'url' => ['/karte/index']],
		[
			'label' => 'Settings',
			'options' => ['class' => 'scroll-dropdown-menu'],
			'items' => [
				['label' => 'Aufzugswärter', 'url' => ['/aufzugswarter/index']],
				['label' => 'Wartungsfirma', 'url' => ['/wartungsfirma/index']],
				['label' => 'Karte Marked', 'url' => ['/karte/marked']],
				['label' => 'Karte Week', 'url' => ['/karte/week']],
				['label' => 'Type', 'url' => ['/type/index']],
				['label' => 'Type 2', 'url' => ['/type2/index']],
				['label' => 'Antriebsart', 'url' => ['/antriebsart/index']],
				['label' => 'Betriebskontrollen', 'url' => ['/betriebskontrollen/index']],
				['label' => 'Prüfintervall', 'url' => ['/profintervall/index']],
				['label' => 'Art', 'url' => ['/art/index']],
				['label' => 'Wartungsfirma Function', 'url' => ['/wartungsfirmafunction/index']],
				['label' => 'Anlagentyp', 'url' => ['/anlagentyp/index']],
				['label' => 'Wartungsart', 'url' => ['/wartungsart/index']],
				['label' => 'Anlagen Status', 'url' => ['/anlagen-status/index']],
				['label' => 'Send Email', 'url' => ['/send-emails/index']],
				['label' => 'Excel Api', 'url' => ['/excel-api/index']],
				['label' => 'Gerät Mangel', 'url' => ['/gerat-mangels/index']],
				['label' => 'Admin Coworker', 'url' => ['/admin-coworker/index']],
				['label' => 'My Profile', 'url' => ['/profile/index']],
				['label' => 'Invoice Excel', 'url' => ['/invoice/download']],
				['label' => 'Norm', 'url' => ['/norm/index']],
				['label' => 'Prufgrundlage', 'url' => ['/prufgrundlage/index']],
				['label' => 'Nenngeschwindigkeit', 'url' => ['/nenngeschwindigkeits/index']],
				['label' => 'Gesetzt', 'url' => ['/gesetzt/index']],
				['label' => 'Letzte Regelmäßige Prüfung durc', 'url' => ['/last-regular-check-by/index']],
				['label' => 'Schachtart', 'url' => ['/schachtart/index']],
				['label' => 'Frist', 'url' => ['/frist/index']],
				['label' => 'Mängel', 'url' => ['/mangel-properties/index']],
				['label' => 'Al', 'url' => ['/al-properties/index']],
				['label' => 'Rest Api', 'url' => ['/rest-api-auth/index']],
				['label' => 'Invoice data', 'url' => ['/invoice-data/index']],

			]
		],
	];
} elseif (Yii::$app->user->getId() && $user->role_id == '2') {
	$menuItems = [
	];
}
if (Yii::$app->user->isGuest) {
	$menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
} else {
	$menuItems[] = '<li>'
	. Html::beginForm(['/site/logout'], 'post')
	. Html::submitButton(
		'Logout (' . Yii::$app->user->identity->username . ')',
		['class' => 'btn btn-link logout']
	)
	. Html::endForm()
		. '</li>';
}
echo Nav::widget([
	'options' => ['class' => 'navbar-nav navbar-right'],
	'items' => $menuItems,
	'encodeLabels' => false,
]);
NavBar::end();
?>

    <div class="container container-mobile">
        <?=Breadcrumbs::widget([
	'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
])?>
        <?=Alert::widget()?>
        <?=$content?>
    </div>
</div>
<?php $this->endBody()?>
</body>
</html>
<?php $this->endPage()?>
