<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Gerat Mangels';
$this->params['breadcrumbs'][] = $this->title;
?>


<div class="type-index">
    <div class="header-content">
        <h1 class="admin-title">Gerät Mangel</h1>
        <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success', 'data-toggle' =>"tooltip", 'title'=> "Neuer Gerät Mangel!"]) ?>
    </div>
    <?php if( $desktop ): ?>
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                'name',
                
                ['class' => 'yii\grid\ActionColumn'],
            ],
            'tableOptions' => [
                'id' => 'theDatatable',
                'class'=>'table table-striped table-bordered table-grid-small'
            ],
        ]); ?>
    <?php else: ?>
        <?php foreach ($dataProvider->getModels() as $key => $model ): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Name</td>
                            <td><?= $model->name ?></td>
                        </tr>
                        <tr>
                            <td>Update</td>
                            <td><?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                        <tr>
                            <td>Details</td>
                            <td><?= Html::a('Details', ['view', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach ?>
    <?php endif ?>
</div>
