<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\AnlagenStatus */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Anlagen Status'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="anlagen-status-view">
    <div class="header-content">
        <h1 class="admin-title"><?= Html::encode($this->title) ?> Details</h1>
        <div>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-pencil"></span>'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary', 'data-toggle' =>"tooltip", 'title'=> "Update AnlagenStatus !"]) ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-trash"></span>'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger', 'data-toggle' =>"tooltip", 'title'=> "Remove AnlagenStatus !",
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ]) ?>
        </div>
    </div>
    <?php if( $desktop ): ?>
        <div class="detal-view-widget">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'id',
                    'name',
                ],
            ]) ?>
        </div>
    <?php else: ?>
        <div class="mobile-table-wrapper">
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>ID</td>
                        <td><?= $model->id ?></td>
                    </tr>
                    <tr>
                        <td>Name</td>
                        <td><?= $model->name ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    <?php endif ?>
</div>
