<?php

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Type;

use kartik\select2\Select2;

/* @var $this yii\web\View */
/* @var $model common\models\User */

$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Admin Coworker'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $user->email;
$this->params['breadcrumbs'][] = 'Set Coworker role';

$data = ArrayHelper::map(Type::find()->all(),'id','name');
$clients = ArrayHelper::map($role->getUsers()->all(),'id','Betreiber');

?>
<div class="application-wrapper">
    <div class="row header-wrapper">
        <div class="col-xs-10">
            <h2 class="admin-title"><strong>Coworker Role</strong></h2>
        </div>
        <div class="col-xs-2 btn-header">
        	<div>
            	<?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['role', 'id' => $user->id], ['class' => 'btn btn-success btn-add-postion', 'data-toggle' =>"tooltip", 'title'=> "Neuer Admin Coworker Role !"]) ?>
            	<?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-pencil"></span>'), ['update-permission', 'user_id' => $user->id, 'permission_id' => $model->id], ['class' => 'btn btn-success btn-add-postion', 'data-toggle' =>"tooltip", 'title'=> "Edit Admin Coworker Role !"]) ?>
            </div>  
        </div>
    </div>
    <div class="row">
        <?php $form = ActiveForm::begin(['id' => 'form-signup', 'options' => ['class' => 'admin-form']]); ?>
            <div class="coworker-administrator-wrapper">
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->kunden ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Kunden	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->kunden_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->kunden_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->kunden_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
							<div class="<?= $model->kuden_send_email ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Send Email
							</div>
							<div class="<?= $model->kunden_export ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Excel Export
							</div>
							<div>
								<h4>Betreiber:</h4>
								<?php foreach ($betraibers as $key => $betraiber ): ?>
									<p><?= $betraiber ?></p>
								<?php endforeach ?>
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->tehnical ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Anlagen	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->tehnical_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->tehnical_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->tehnical_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
							<div class="<?= $model->tehnical_import_data ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Excel Import
							</div>
							<div class="<?= $model->tehnical_export_data ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Excel Export
							</div>
							<div class="<?= $model->tehnical_add_lat_lang ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Google Map add cordinates
							</div>
							<div class="<?= $model->tehnical_prufungen ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Create Prüfungen
							</div>
							<div class="<?= $model->tehnical_pdf_preview ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								PDF preview
							</div>
							<div>
								<h4>Anlagen Type:</h4>
								<?php foreach ($types as $key => $type ): ?>
									<p><?= $type ?></p>
								<?php endforeach ?>
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->tehnic_review ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Prüfungen	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->tehnic_review_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->tehnic_review_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->tehnic_review_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
							<div class="<?= $model->tehnic_review_send_email ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Send Email
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->karte ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Karte	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->karteMarked ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Marked
							</div>
							<div class="<?= $model->karteWeek ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Week
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->aufzugswarter ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Aufzugswärter	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->aufzugswarter_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->aufzugswarter_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->aufzugswarter_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->wartungsfirma ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Wartungsfirma	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->wartungsfirma_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->wartungsfirma_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->wartungsfirma_destry ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->type ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Type	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->type_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->type_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->type_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->type2 ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Type 2	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->type2_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->type2_eduit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->type2_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->antriebsart ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Antriebsart	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->antriebsart_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->antriebsart_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->antriebsart_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->betriebskontrollen ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Betriebskontrollen	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->betriebskontrollen_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->betriebskontrollen_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->betriebskontrollen_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->profintervall ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Prüfintervall	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->profintervall_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->profintervall_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->profintervall_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->art ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Art	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->art_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->art_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->art_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->wartungsfirmafunction ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Wartungsfirma Funktion	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->wartungsfirmafunction_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->wartungsfirmafunction_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->wartungsfirmafunction_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->anlagentyp ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Anlagentyp	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->anlagentyp_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->anlagentyp_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->anlagentyp_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->wartungsart ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Wartungsart	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->wartungsart_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->wartungsart_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->wartungsart_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->anlagen_status ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Anlagen Status	
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->anlagen_status_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->anlagen_status_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->anlagen_status_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->send_emails ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Send Emails	
							</h4>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->excel_api ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Excel Api CSV
							</h4>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->gerat_mangels ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Gerät Mangel
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->gerat_mangels_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->gerat_mangels_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->gerat_mangels_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->profile ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Profile
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->profile_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->excel_inovice ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Excel Invoice
							</h4>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->norm ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Norm
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->norm_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->norm_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->norm_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
                <div class="coworker-kunden coworker-administrator-card">
					<div class="thumbnail role-wrapper">
						<div class="coworker-administrator-card-title">
							<h4 class="<?= $model->prufgrundlage ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Prufgrundlage
							</h4>
						</div>
						<div class="coworker-administrator-card-content">
							<div class="<?= $model->prufgrundlage_new ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								New
							</div>
							<div class="<?= $model->prufgrundlage_edit ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Edit
							</div>
							<div class="<?= $model->prufgrundlage_destroy ?  'glyphicon glyphicon-ok' : 'glyphicon glyphicon-remove'?>">
								Delete
							</div>
						</div>
					</div>
                </div>
            </div>
        <?php ActiveForm::end(); ?>
    </div>
</div>