<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\LinkPager;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use dosamigos\tinymce\TinyMce;
/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Admin Coworkers');
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="application-wrapper">
    <div class="header-content">
        <h2 class="admin-title"><strong>Kunden</strong></h2>
        <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success btn-add-postion', 'data-toggle' =>"tooltip", 'title'=> "Neuer Kunde !"]) ?>
    </div>
    <div class="form-invitation rotate3d">
        <div class="form-invitation-header">
            <h3>Send Email to Company</h3>
            <?= Html::a(Yii::t('app', ''), ['index'], ['class' => 'btn-close-postion glyphicon glyphicon-remove-circle']) ?>
        </div>
        <?php $form = ActiveForm::begin(); ?>
            <p class="hide"><?php $user_invitation->send_standard_content_with_email = 1 ?></p>
            <?= $form->field($user_invitation, 'send_standard_content_with_email')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-check')); ?>
            <div class="form-group form-group-subject-visible hide">
                <label>Emails</label> 
                <?= $form->field($user_invitation, 'emails')->textInput(['maxlength' => 255, 'class' => 'form-control'])->label(false); ?>
            </div>
            <div class="form-group form-group-subject-visible hide">
                <label>Subject</label> 
                <?= $form->field($user_invitation, 'subject')->textInput(['maxlength' => 255, 'class' => 'form-control'])->label(false); ?>
            </div>
            <?= $form->field($user_invitation, 'send_message_from_mail')->widget(TinyMce::className(), [
                'options' => ['rows' => 5],
                'language' => 'de',
                'clientOptions' => [
                    'branding' => false,
                    'plugins' => [
                        "advlist autolink lists link charmap print preview anchor",
                        "searchreplace visualblocks code fullscreen",
                        "insertdatetime media table contextmenu paste"
                    ],
                    'toolbar' => "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
                ]
            ]);?>
            <div class="form-group text-center">
                <?= Html::submitButton('', ['class' => 'btn btn-success glyphicon glyphicon-envelope', 'value' => 'send_email']) ?>
            </div>            
        <?php ActiveForm::end(); ?>
    </div>
    <div class="row">
        <div class="col-xs-6 col-xs-offset-3 paginate-content">
            <?php
            echo LinkPager::widget([
            'pagination' => $pagination,
        ]); ?>
        </div>
    </div>
</div>
