<?php

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Type;
use kartik\select2\Select2;

$data = ArrayHelper::map(Type::find()->all(),'id','name');
$clients = ArrayHelper::map($role->getUsers()->all(),'id','Betreiber');

?>
<?php $form = ActiveForm::begin(['id' => 'form-signup', 'options' => ['class' => 'admin-form']]); ?>
	<div class="check-all-wrapper">
		<h3><?= $form->field($model, 'all')->checkbox(['class' => "role_chackbox_all"]) ?></h3>
	</div>
    <div class="coworker-administrator-wrapper">
        <div class="coworker-kunden coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'kunden')->checkbox(['class' => "role_chackbox role_chackbox-kunden"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'kunden_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'kunden_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'kunden_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'kuden_send_email')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'kunden_export')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'kunden_betraiber_array')->widget(Select2::classname(), [
                        'data' => $clients,
                        'language' => 'de',
                        'options' => ['multiple' => true, 'placeholder' => 'Select Betreiber ...'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ])->label(false); ?>
				</div>
			</div>
        </div>
        <div class="coworker-tehnical coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'tehnical')->checkbox(['class' => "role_chackbox role_chackbox-anlagen"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'tehnical_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_import_data')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_export_data')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_add_lat_lang')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_prufungen')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_pdf_preview')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnical_type_array')->widget(Select2::classname(), [
                        'data' => $data,
                        'language' => 'de',
                        'options' => ['multiple' => true, 'placeholder' => 'Select Anlagen Type...'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ])->label(false); ?>
				</div>
			</div>
        </div>
        <div class="coworker-tehnic_review coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'tehnic_review')->checkbox(['class' => "role_chackbox role_chackbox-tehnic_review"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'tehnic_review_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnic_review_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnic_review_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'tehnic_review_send_email')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-karte coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'karte')->checkbox(['class' => "role_chackbox role_chackbox-karte"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'karteMarked')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'karteWeek')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-aufzugswarter coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'aufzugswarter')->checkbox(['class' => "role_chackbox role_chackbox-aufzugswarter"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'aufzugswarter_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'aufzugswarter_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'aufzugswarter_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-wartungsfirma coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'wartungsfirma')->checkbox(['class' => "role_chackbox role_chackbox-wartungsfirma"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'wartungsfirma_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'wartungsfirma_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'wartungsfirma_destry')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-type coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'type')->checkbox(['class' => "role_chackbox role_chackbox-type"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'type_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'type_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'type_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-type2 coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'type2')->checkbox(['class' => "role_chackbox role_chackbox-type"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'type2_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'type2_eduit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'type2_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-antriebsart coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'antriebsart')->checkbox(['class' => "role_chackbox role_chackbox-antriebsart"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'antriebsart_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'antriebsart_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'antriebsart_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-betriebskontrollen coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'betriebskontrollen')->checkbox(['class' => "role_chackbox role_chackbox-betriebskontrollen"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'betriebskontrollen_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'betriebskontrollen_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'betriebskontrollen_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-profintervall coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'profintervall')->checkbox(['class' => "role_chackbox role_chackbox-profintervall"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'profintervall_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'profintervall_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'profintervall_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-art coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'art')->checkbox(['class' => "role_chackbox role_chackbox-art"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'art_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'art_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'art_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-wartungsfirmafunction coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'wartungsfirmafunction')->checkbox(['class' => "role_chackbox role_chackbox-wartungsfirmafunction"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'wartungsfirmafunction_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'wartungsfirmafunction_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'wartungsfirmafunction_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-anlagentyp coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'anlagentyp')->checkbox(['class' => "role_chackbox role_chackbox-anlagentyp"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'anlagentyp_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'anlagentyp_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'anlagentyp_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-wartungsart coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'wartungsart')->checkbox(['class' => "role_chackbox role_chackbox-wartungsart"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'wartungsart_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'wartungsart_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'wartungsart_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-anlagen_status coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'anlagen_status')->checkbox(['class' => "role_chackbox role_chackbox-anlagen_status"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'anlagen_status_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'anlagen_status_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'anlagen_status_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-send_emails coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'send_emails')->checkbox(['class' => "role_chackbox role_chackbox-send_emails"]) ?></h4>
				</div>
			</div>
        </div>
        <div class="coworker-send_emails coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'excel_api')->checkbox(['class' => "role_chackbox role_chackbox-excel_api"]) ?></h4>
				</div>
			</div>
        </div>
        <div class="coworker-gerat_mangels coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'gerat_mangels')->checkbox(['class' => "role_chackbox role_chackbox-gerat_mangels"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'gerat_mangels_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'gerat_mangels_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'gerat_mangels_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-profile coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'profile')->checkbox(['class' => "role_chackbox role_chackbox-profile"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'profile_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-send_emails coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'excel_inovice')->checkbox(['class' => "role_chackbox role_chackbox-excel_invoice"]) ?></h4>
				</div>
			</div>
        </div>
        <div class="coworker-wartungsfirma coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'norm')->checkbox(['class' => "role_chackbox role_chackbox-norm"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'norm_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'norm_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'norm_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
        <div class="coworker-wartungsfirma coworker-administrator-card">
			<div class="thumbnail role-wrapper">
				<div class="coworker-administrator-card-title">
					<h4><?= $form->field($model, 'prufgrundlage')->checkbox(['class' => "role_chackbox role_chackbox-prufgrundlage"]) ?></h4>
				</div>
				<div>
                    <?= $form->field($model, 'prufgrundlage_new')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'prufgrundlage_edit')->checkbox(['class' => "role_chackbox-child"]) ?>
                    <?= $form->field($model, 'prufgrundlage_destroy')->checkbox(['class' => "role_chackbox-child"]) ?>
				</div>
			</div>
        </div>
    </div>
    <div class="form-group btn-postion">
        <?= Html::submitButton('Save', ['class' => 'btn btn-block btn-success', 'name' => 'signup-button']) ?>
    </div>
<?php ActiveForm::end(); ?>