<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\Tehnical;
use common\models\Art;
use common\models\Frist;
use common\models\AlProperties;
use yii\widgets\DetailView;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use dosamigos\datepicker\DatePicker;
use common\models\GeratMangel;
$s3_path = S3_PATH;
use dosamigos\tinymce\TinyMce;
use kartik\select2\Select2;
use common\models\MangelProperties;

/* @var $this yii\web\View */
/* @var $model common\models\TehnicReview */
/* @var $form yii\widgets\ActiveForm */
$data = ArrayHelper::map(MangelProperties::find()->all(),'id','name');
$dataFrist = ArrayHelper::map(Frist::find()->all(),'id','name');
$dataAl = ArrayHelper::map(AlProperties::find()->all(),'id','name');
?>
<div class="tehnical-create">
        <h1 class="admin-title">
            Neues Dokument <?php echo $tehnical->Type == "Spielplatzgeräte" ? "Spielplatzgerät" : "" ?>
        </h1>
</div>
<div class="tehnic-review-form" onclick="resetSelect()">

    <?php $form = ActiveForm::begin(['options' => ['class' => 'tehnic-form', 'enctype' => 'multipart/form-data']]); ?>
        <?= $form->field($model, 'sendToAPI')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-active'))->label("Send API"); ?>
        <?= $form->field($model, 'upload_pdf')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-check')); ?>
        <div class="upload-pdf-triger hide">
            <?= $form->field($model, 'url')->fileInput() ?>
        </div>
        <?= $form->field($model, 'show_images_property')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-check'))->label("Upload Images"); ?>
        <div class="images-property hide">
            <?php if( $tehnical->Type == "Spielplatzgeräte" ): ?>

                <div class="field_wrapper">
                    <div class="field_wrapper-style field_wrapper-style-spielplatzgerate">
                        <div class="filed-append-wrapper">
                            <h3>Inspektionsobjekt</h3>
                            <?= $form->field($model, 'image_file[]')->fileInput() ?>
                            <?= $form->field($model, 'image_description[]')->textArea()->label("Geräte Spielplatzbeschreibung") ?>
                        <div class="append-wrapper"></div>
                        </div>
                        <a href="javascript:void(0);" class="add_button glyphicon glyphicon-plus" title="Add field"></a>
                    </div>
                </div>
                <div class="field_wrapper">
                    <div class="field_wrapper-style field_wrapper-style-spielplatzgerate">
                        <div class="filed-append-wrapper">
                            <h3>Gerät</h3>
                            <?= $form->field($model, 'gerat_image[]')->fileInput() ?>
                            <?= $form->field($model, 'gerat[]')->textArea()->label("Gerät") ?>
                            <?= $form->field($model, 'gerat_mangel[]')->textArea()->label("Gerät Mangel") ?>
                            <?= $form->field($model, 'gerat_mangel_type[]')->dropDownList(ArrayHelper::map(GeratMangel::find()->all(),'name','name'), ['prompt' => 'Select Gerat Mangel']) ?>

                        <div class="append-wrapper-2"></div>
                        </div>
                        <a href="javascript:void(0);" class="add_button2 glyphicon glyphicon-plus" title="Add field"></a>
                    </div>
                </div>
            <?php else: ?>
                <?= $form->field($model, 'files[]')->fileInput(['multiple' => true])->label("Images"); ?>

                <?= $form->field($model, 'short_photo_description')->textarea(['rows' => '3', 'maxlength'=>30])->label("Short Image Description") ?>

                <?= $form->field($model, 'photo_description')->widget(TinyMce::className("hide"), [
                    'options' => ['rows' => 5],
                    'language' => 'de',
                    'clientOptions' => [
                        'branding' => false,
                        'plugins' => [
                            "advlist autolink lists link charmap print preview anchor",
                            "searchreplace visualblocks code fullscreen",
                            "insertdatetime media table contextmenu paste"
                        ],
                        'toolbar' => "undo redo | fontselect | fontsizeselect | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
                    ]
                ])->label("Long Image Description");?>                
            <?php endif ?>
        </div>
        <?= $form->field($model, 'Art')->dropDownList(ArrayHelper::map(Art::find()->all(),'name','name'), ['prompt' => 'Select Art']) ?>


        <div class="form-group">
            <label class="control-label" for="tehnical-baujahr">Prufungsdatum</label>
            <?= DatePicker::widget([
                'model' => $model,
                'attribute' => 'Prufungsdatum',
                'template' => '{addon}{input}',
                    'clientOptions' => [
                        'autoclose' => true,
                        'format' => 'dd.mm.yyyy'
                    ]
            ]);?>
        </div>

        <?= $form->field($model, 'Mangel')->label("Mängel")->dropdownList(['1' => 'JA', '0' => 'NEIN '], ['prompt' => 'Select Mangel']) ?>

        <?= $form->field($model, 'VollwartungEnthalten')->label("Vollwartung Enthalten")->dropdownList(['Ja' => 'Ja', 'Nein' => 'Nein ', 'Teilweise' => 'Teilweise '], ['prompt' => 'Select Vollwartung Enthalten']) ?>

        <?= $form->field($model, 'Kostenschatzung')->textInput(['maxlength' => true, 'placeholder' => '€'])->label("Kostenschätzung") ?>

      <!--  <?= $form->field($model, 'tehn_text')->widget(TinyMce::className(), [
            'options' => ['rows' => 5],
            'language' => 'de',
            'clientOptions' => [
                'branding' => false,
                'plugins' => [
                    "advlist autolink lists link charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste"
                ],
                'toolbar' => "undo redo | fontselect | fontsizeselect | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
            ]
        ])->label("Mängel");?> !-->
        
        <div class="field_wrapper mangale-wraper-2 hide" >
            <div class="field_wrapper-style field_wrapper-style-spielplatzgerate">
                <div class="filed-append-wrapper" id="mangel-wrapp">
                    <h3>Abnahmeprüfung nach Insatzsetzung</h3>
                    <div class="mangel-frist-wrapper">

                        <div class="search-mangel-wrapper" onclick="setTypeOfSelect('al-2')">
                            <div class="form-group ">
                                <label>Al</label>
                                <input name="al" class="alInput-2 form-control" type="text" placeholder="Set Al" autocomplete="off">
                            </div>
                            <div class="search-content search-al-2 hide" id="livesearch">
                                <ul id="al-list-2">
                                    <?php foreach ($dataAl as $key => $value): ?>
                                        <li class="list-item">
                                            <span><?= $value ?></span>
                                        </li>
                                    <?php endforeach ?>  
                                </ul>
                            </div>
                        </div>

                        <div class="search-mangel-wrapper" onclick="setTypeOfSelect('mangels-2')">
                            <div class="form-group ">
                                <label>Mangel</label>
                                <input name="mangels" class="mangelsInput-2 form-control" type="text" placeholder="Set Mangel" autocomplete="off">
                            </div>
                            <div class="search-content search-mangels-2 hide" id="livesearch">
                                <ul id="mangels-list-2">
                                    <?php foreach ($data as $key => $value): ?>
                                        <li class="list-item">
                                            <span><?= $value ?></span>
                                        </li>
                                    <?php endforeach ?>  
                                </ul>
                            </div>
                        </div>
                        <div class="search-mangel-wrapper" onclick="setTypeOfSelect('frists-2')">
                            <div class="form-group ">
                                <label>Frist</label>
                                <input name="frists" class="firstInputs-2 form-control" type="text" placeholder="Set Frist" autocomplete="off">
                            </div>
                            <div class="search-content-frist search-frist-2 hide" id="livesearch">
                                <ul id="frist-list-2">
                                    <?php foreach ($dataFrist as $key => $value): ?>
                                        <li class="list-item">
                                            <span><?= $value ?></span>
                                        </li>
                                    <?php endforeach ?>  
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="preview-wrapper preview-wrapper-mangel">
                        <a href="javascript:void(0);" class="mangel-btn save_button glyphicon glyphicon-plus btn btn-success" title="save" index="2"></a>
                    </div>
                    <div>
                        <div class="selected-wrapper">
                            <table class="table" id="selected-list-2">
                              <thead>
                                <tr>
                                  <th scope="col">Al</th>
                                  <th scope="col">Mängel</th>
                                  <th scope="col">Frist</th>
                                  <th scope="col">Image</th>
                                  <th scope="col">Delete</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?= $form->field($model, 'mangelsInputArray')->textInput(['class' => 'mangelsInputArray hide'])->label(false) ?>
            </div>
        </div>

        <div class="field_wrapper">
            <div class="field_wrapper-style field_wrapper-style-spielplatzgerate">
                <div class="filed-append-wrapper" id="mangel-wrapp">
                    <h3 id="mangel-title">Mängel</h3>
                    <div class="mangel-frist-wrapper">
                        <div class="search-mangel-wrapper" onclick="setTypeOfSelect('mangels-1')">
                            <div class="form-group ">
                                <label>Mangel</label>
                                <input name="mangels" class="mangelsInput-1 form-control" type="text" placeholder="Set Mangel"  autocomplete="off">
                            </div>
                            <div class="search-content search-mangels-1 hide" id="livesearch">
                                <ul id="mangels-list-1">
                                    <?php foreach ($data as $key => $value): ?>
                                        <li class="list-item">
                                            <span><?= $value ?></span>
                                        </li>
                                    <?php endforeach ?>  
                                </ul>
                            </div>
                        </div>
                        <div class="search-mangel-wrapper" onclick="setTypeOfSelect('frists-1')">
                            <div class="form-group ">
                                <label>Frist</label>
                                <input name="frists" class="firstInputs-1 form-control" type="text" placeholder="Set Frist"  autocomplete="off">
                            </div>
                            <div class="search-content-frist search-frist-1 hide" id="livesearch">
                                <ul id="frist-list-1">
                                    <?php foreach ($dataFrist as $key => $value): ?>
                                        <li class="list-item">
                                            <span><?= $value ?></span>
                                        </li>
                                    <?php endforeach ?>  
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="preview-wrapper preview-wrapper-mangel">
                        <a href="javascript:void(0);" class="mangel-btn save_button glyphicon glyphicon-plus btn btn-success mangel-1" title="save" index="1"></a>
                    </div>
                    <div>
                        <div class="selected-wrapper">
                            <table class="table" id="selected-list-1">
                              <thead>
                                <tr>
                                  <th scope="col">Mängel</th>
                                  <th scope="col">Frist</th>
                                  <th scope="col">Image</th>
                                  <th scope="col">Delete</th>
                                </tr>
                              </thead>
                              <tbody>
                              </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <?= $form->field($model, 'mangelsInputArray')->textInput(['class' => 'mangelsInputArray hide'])->label(false) ?>
            </div>
        </div>

        
        <?= $form->field($model, 'Anmerkungen')->textarea(['rows' => '3', 'maxlength'=>300]) ?>
        <?= $form->field($model, 'AWStatus')->label("AWStatus")
        ->dropdownList(['telefonisch bestätigt' => 'telefonisch bestätigt', 
        'trotz Terminvereinbarung nicht anwesend' => 'trotz Terminvereinbarung nicht anwesend ',
        'persönlich bestätigt' => 'persönlich bestätigt'], ['prompt' => 'Select AWStatus']) ?>

      <!--  <?= $form->field($model, 'Frist')->dropDownList(ArrayHelper::map(Frist::find()->all(),'name','name'), ['prompt' => 'Select Frist']) ?>
        <?= $form->field($model, 'fristText')->textInput(['maxlength' => true, 'placeholder' => 'Input Frist'])->label(false) ?>
!-->
        <?= $form->field($model, 'DieInstandhaltungderAnlagewar')->label("Die Instandhaltung der Anlage war:")->dropdownList(['gut' => 'gut', 'sehr gut' => 'sehr gut', 'ausreichend' => 'ausreichend', 'nicht ausreichend' => 'nicht ausreichend'], ['prompt' => 'Die Instandhaltung der Anlage war']) ?>
        <?php if ( $model->ensure_exist_api_for_anlagen_from_tehnical($tehnical) ): ?>
            <?= $form->field($model, 'show_AllgemeinerZustandImages_property')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-check'))->label("Allgemeiner Zustand"); ?>
            <div class="upload_AllgemeinerZustandImages hide">
                <?= $form->field($model, 'AllgemeinerZustand')->textInput(['maxlength' => true, 'placeholder' => 'Allgemeiner Zustand'])->label("Allgemeiner Zustand") ?>

                <?= $form->field($model, 'AllgemeinerZustandImages[]')->widget(FileInput::classname(), ['options' => ['multiple' => true, 'accept' => 'image/*'],
                    'pluginOptions'=>[
                        'allowedFileExtensions'=>['jpg', 'png','jpeg'],
                        'showUpload' => true,
                        'initialPreview' => [
                            $model->url ? Html::img($s3_path. 'images/'.$model->files) : null, // checks the models to display the preview
                        ],
                        'overwriteInitial' => true,
                    ],
                ])->label("Allgemeiner Zustand Images") ?>

                <?= $form->field($model, 'Wartungsbuch[]')->widget(FileInput::classname(), ['options' => ['multiple' => true, 'accept' => 'image/*'],
                    'pluginOptions'=>[
                        'allowedFileExtensions'=>['jpg', 'png','jpeg'],
                        'showUpload' => true,
                        'initialPreview' => [
                            $model->url ? Html::img($s3_path. 'images/'.$model->files) : null, // checks the models to display the preview
                        ],
                        'overwriteInitial' => true,
                    ],
                ])->label("Wartungsbuch") ?>
            </div>
        <?php endif; ?>
        <div class="form-group <?= $desktop ? '' : 'text-center' ?>">
            <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        </div>

    <?php ActiveForm::end(); ?>

</div>
<script src="https://code.jquery.com/jquery-1.10.2.js"></script>
<script src="https://code.jquery.com/ui/1.10.4/jquery-ui.js"></script>
<script>
    
    var type = null;

    function setTypeOfSelect(arg) {
        type = arg;
    }

    function mangelsInput(self, index, e) {
        setTimeout(function () {
            $(".search-mangels-" + index).removeClass("hide"); 
        }, 500);

        var value = $(self).val();
        $(".mangelsInput-" + index).val(value);
        
        if( value.length > 0 ) {
            $(".search-mangels-" + index).removeClass("hide");
        }

        $(`#mangels-list-${index} li`).filter(function() {
            $(this).toggle($(this).children("span").text().indexOf(value) > -1)
        });
    }

    function firstInputs(self, index, e) {
        setTimeout(function () {
            $(".search-frist-" + index).removeClass("hide"); 
        }, 500);

        var value = $(self).val();
        $(".firstInputs-" + index).val(value);

        if( value.length > 0 ) {
            $(".search-frist-" + index).removeClass("hide");
        }       

        $(`#frist-list-${index} li`).filter(function() {
          $(this).toggle($(this).children("span").text().indexOf(value) > -1)
        });
    }

    function alInput(self, index, e) {
        setTimeout(function () {
            $(".search-al-" + index).removeClass("hide"); 
        }, 500);

        var value = $(self).val();
        $(".alInput-" + index).val(value);
        
        if( value.length > 0 ) {
            $(".search-al-" + index).removeClass("hide");
        }

        $(`#al-list-${index} li`).filter(function() {
            $(this).toggle($(this).children("span").text().indexOf(value) > -1)
        });
    }

    function resetSelect() {
        $(".search-content").addClass("hide");
        $(".search-content-frist").addClass("hide");
    }

    $(document).ready(function() {

        $('#tehnicreview-art').on('change', function(e) {
            const value = $(this).val();

            if(value == 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen') {
                $('.mangale-wraper-2').removeClass("hide");
                $('#mangel-title').text('Unabhängige Mängel');
                return;
            }

            $('.mangale-wraper-2').addClass("hide");
            $('#mangel-title').text('Mängel');
        });

        $(".mangelsInput-1").on("keyup focus", function(e) {
            mangelsInput(this, 1, e);
        });

        $(".mangelsInput-2").on("keyup focus", function(e) {
            mangelsInput(this, 2, e);
        });
        
        $(".firstInputs-1").on("keyup focus", function(e) {
            firstInputs(this, 1, e);
        });
        
        $(".firstInputs-2").on("keyup focus", function(e) {
            firstInputs(this, 2, e);
        });

        $(".alInput-2").on("keyup focus", function(e) {
            alInput(this, 2, e);
        });

        $(".list-item").on("click", function(e) {
            const value = $(this).children("span").text();

            const _type = type.split('-');

            if(_type[0] == 'mangels' && value.length > 0) {
                $(".mangelsInput-" + _type[1]).val(value);
                $(".search-mangels-" + _type[1]).addClass("hide");
            }
            else if (_type[0] == 'frists' && value.length > 0) {
                $(".firstInputs-" + _type[1]).val(value);
                $(".search-frist").addClass("hide");
            }
            else if (_type[0] == 'al' && value.length > 0) {
                $(".alInput-" + _type[1]).val(value);
                $(".search-al").addClass("hide");
            }
        });
    });
</script>