<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Tehnical */
$s3_path = S3_PATH;
?>
<div class="tehnical-view">
    <div class="header-content header-content-mobile">
        <h1 class="admin-title"><?= Html::encode($model->FabriksNr) ?> Details</h1>
        <div>
            <?php if( $permission->tehnical_prufungen ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['review', "id" => $model->id], ['class' => 'btn btn-info btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Neuer Prüfungen !"]) ?>
            <?php endif ?>
            <?php if( $permission->tehnical_new ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-copy"></span>'), ['copy', "id" => $model->id], ['class' => 'btn btn-success btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Copy Anlagen !"]) ?>
            <?php endif ?>
            <?php if( $permission->tehnic_review_edit ): ?>
                <?php if( $model->WiederkehrendeUberprufungExist() ): ?>
                    <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-edit"></span>'), ['wiederkehrende', 'id' => $model->id], ['class' => 'btn btn-warning btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Update Prüfungen !"]) ?>
                <?php endif ?>
            <?php endif ?>
            <?php if( $permission->tehnical_edit ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-pencil"></span>'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Update Anlagen !"]) ?>
            <?php endif ?>
            <?php if( $permission->tehnical_destroy ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-trash"></span>'), ['delete', 'id' => $model->id], [
                    'class' => 'btn btn-danger btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Remove Anlagen !",
                    'data' => [
                        'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                        'method' => 'post',
                    ],
                ]) ?>
            <?php endif ?>
            <?php if( $permission->tehnical_add_lat_lang ): ?>
                <?php if( $google_map_exist ): ?>
                    <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-erase"></span>'), ['unmark', 'id' => $model->id], ['class' => 'btn btn-default btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Remove Anlagen from Google Map ( Karte Marked ) !"]) ?>
                <?php else: ?>
                    <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-map-marker"></span>'), ['karte', 'id' => $model->id], ['class' => 'btn btn-default btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Add Anlagen to the Google Map ( Karte Marked ) !"]) ?>
                <?php endif ?>
            <?php endif ?>
            <?php if( $permission->tehnical_pdf_preview ): ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-list-alt"></span>'), ['pdf/pdf-view', "id" => $model->id], ['class' => 'btn btn-primary btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "PDF", 'target'=>'_blank']) ?>
                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-print"></span>'), ['pdf/beschreibung-pdf', "id" => $model->id], ['class' => 'btn btn-orange btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Beschreibung PDF", 'target'=>'_blank']) ?>
            <?php endif ?>
        </div>
    </div>
    <?php if( $desktop ): ?>
        <div class="detail-view-widget">
            <?= DetailView::widget([
                'model' => $model,
                'attributes' => [
                    'ObjektNr',
                    [
                        'label' => 'Anlagen Nr',
                        'value' => function ($data){ return "AT".$data->id; },
                    ],
                    [
                        'label' => 'User',
                        'value' => function ($data){ return $data->getUser()->one()->email; },
                    ],
                    [
                        'label' => 'Firma',
                        'value' => function ($data){ return $data->getUser()->one()->Betreiber; },
                    ],
                    [
                        'label' => 'Type',
                        'value' => function ($data){ return $data->Type; },
                    ],
                    [
                        'label' => 'Type 2',
                        'attribute' => 'Type 2',
                        'value' => function ($data){ 
                            return $data->type2;
                        },
                        'visible' => (!empty($model->type2)),
                    ],
                    [
                        'label' => 'FabriksNr',
                        'value' => function ($data){ return $data->FabriksNr; },
                    ],
                    [
                        'label' => 'AdresseOrt',
                        'value' => function ($data){ return $data->AdresseOrt; },
                    ],
                    [
                        'label' => 'AdresseStreat',
                        'value' => function ($data){ return $data->AdresseStreat; },
                    ],
                    [
                        'label' => 'AdressePLZ',
                        'value' => function ($data){ return $data->AdressePLZ; },
                    ],
                    [
                        'label' => 'Zusatz',
                        'value' => function ($data){ return $data->Zusatz; },
                    ],
                    [
                        'label' => 'Baujahr',
                        'value' => function ($data){ return $data->Baujahr; },
                    ],
                    [
                        'label' => 'Hersteller',
                        'value' => function ($data){ return $data->Hersteller; },
                    ],
                    [
                        'label' => 'Prufgrundlage',
                        'attribute' => 'Prufgrundlage',
                        'value' => function ($data){ 
                            return $data->Prufgrundlage;
                        },
                        'visible' => (!empty($model->Prufgrundlage)),
                    ],
                    [
                        'label' => 'Nennlast',
                        'value' => function ($data){ return $data->Nennlast; },
                        'visible' => (!empty($model->Nennlast)),
                    ],
                    [
                        'label' => 'AnzahltStellplatze',
                        'value' => function ($data){ return $data->AnzahltStellplatze; },
                        'visible' => (!empty($model->AnzahltStellplatze)),
                    ],
                    [
                        'label' => 'Parkeranagen',
                        'value' => function ($data){ return $data->Parkeranagen; },
                        'visible' => (!empty($model->Parkeranagen)),
                    ],
                    [
                        'label' => 'Antriebsart',
                        'value' => function ($data){ return $data->Antriebsart; },
                        'visible' => (!empty($model->Antriebsart)),
                    ],
                    [
                        'label' => 'Prüfintervall',
                        'value' => function ($data){ return $data->Profintervall; },
                        'visible' => (!empty($model->Profintervall)),
                    ],
                    [
                        'label' => 'Erstellt am',
                        'value' => function ($data){ return $data->formatErstelltAmDate(); },
                        'visible' => (!empty($model->formatErstelltAmDate())),
                    ],
                    [
                        'label' => 'Letzter Prüfer',
                        'value' => function ($data){ return strip_tags($data->Letzte); },
                        'visible' => (!empty($model->Letzte)),
                    ],
                    [
                        'label' => 'Prüfungsdatum',
                        'value' => function ($data){ return $data->LetzteDate; },
                        'visible' => (!empty($model->LetzteDate)),
                    ],
                    [
                        'label' => 'UIDNUMMER',
                        'value' => function ($data){ return $data->UIDNUMMER; },
                        'visible' => (!empty($model->UIDNUMMER)),
                    ],
                    [
                        'label' => 'Hausverwalter',
                        'value' => function ($data){ return $data->Hausverwalter; },
                        'visible' => (!empty($model->Hausverwalter)),
                    ],
                    [
                        'label' => 'Hausverwalter Email',
                        'value' => function ($data){ return $data->HausverwalterEmail; },
                        'visible' => (!empty($model->HausverwalterEmail)),
                    ],
                    [
                        'label' => 'Verwalter Tel.',
                        'value' => function ($data){ return $data->KontaktVerwalter; },
                        'visible' => (!empty($model->KontaktVerwalter)),
                    ],
                    [
                        'label' => 'status',
                        'value' => function ($data){ return $data->status; },
                    ],
                    [
                        'label' => 'lat',
                        'value' => function ($data){ return $data->lat; },
                    ],
                    [
                        'label' => 'lng',
                        'value' => function ($data){ return $data->lng; },
                    ],
                ],
            ]) ?>
        </div>
        <?php if ( $model->Notizen != "" || $model->Notizen != null ): ?>
            <h1>Notizen</h1>
            <div>
                <?= $model->Notizen ?>
            </div>
        <?php endif ?>
        <?php if ( $model->checkForbidenType() ): ?>
            <h1>Wartungsfirma</h1>
            <table class="table table-striped table-bordered table-grid-small">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Funktion</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $model->getWartungsfirma()->one()->name ?></td>
                        <td><?= $model->getWartungsfirma()->one()->function ?></td>
                    </tr>
                </tbody>
            </table>
        <?php endif ?>
        <table class="table table-striped table-bordered table-grid-small">
            <thead>
                <tr>
                    <th>Datum</th>
                    <th>Prüfungsdatum</th>
                    <th>Art</th>
                    <th>Mängel</th>
                    <th>in Vollwart. enth.</th>
                    <th>Kostenschätzung</th>
                    <th>PDF</th>
                    <th>Fotos</th>
                    <th>Mängel Fotos</th>
                    <?php if ( $rest_api && isset($rest_api->id) ): ?>
                        <th>Allgemeiner Zustand Fotos</th>
                        <th>Wartungsbuch Fotos</th>
                    <?php endif ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($model->getTehnicReviews()->orderBy(['id' => SORT_DESC])->all() as $key => $application): ?>
                    <tr>
                        <td><?= $application->formatDatum(); ?></td>
                        <?php if ( $application->Prufungsdatum != null || $application->Prufungsdatum != ""  ): ?>
                            <td><?= $application->formatPrufungsdatum(); ?></td>  
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>   
                        <td><?= $application->Art; ?></td>
                        <?php if ( $application->Mangel != "" || $application->Mangel !== null ): ?>
                            <td><?= $application->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                        <td class="VollwartungEnthalten-desktop-width"><?= $application->VollwartungEnthalten; ?></td>
                        <td><?= $application->Kostenschatzung; ?></td>
                        <?php if ( $application->url != null || $application->url != ""  ): ?>
                            <td>
                                <?php $link= $s3_path."pdf/". $application->url ?>
                                <a target="_blank" href="<?php echo $link; ?>" class="btn btn-success">Download PDF</a>
                            </td>
                        <?php else: ?>
                            <td></td>
                        <?php endif ?>
                        <td>
                            <?php if ( count( $application->getImages()->all() ) > 0 ): ?>
                                <?= Html::a('Fotos', ['fotos/view', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                <div>
                                    <?= $application->short_photo_description ?>
                                </div>
                            <?php endif ?>
                        </td>
                        <td>
                            <?php if ( $application->getMangelsPhotos() ): ?>
                                <?= Html::a('Fotos', ['fotos/mangel-photo', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                            <?php endif ?>
                        </td>
                        <?php if ( isset($rest_api->id) && $application->display_allgemeiner_zustand_images_exists() ): ?>
                            <td>
                                <?= Html::a('Fotos', ['fotos/allgemeiner-zustand', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                            </td>
                        <?php endif ?>
                        <?php if ( isset($rest_api->id) && $application->display_wartungsbuch_images_exists() ): ?>
                            <td>
                                <?= Html::a('Fotos', ['fotos/wartungsbuch', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                            </td>
                        <?php endif ?>
                        </td>
                    </tr>
                <?php endforeach ?>  
            </tbody>
        </table>
    <?php else: ?>
        <div class="mobile-table-wrapper">
            <table class="table table-striped table-hover table-bordered table-mobile">
                <tbody>
                    <tr>
                        <td>Objekt Nr</td>
                        <td><?= $model->ObjektNr ?></td>
                    </tr>
                    <tr>
                        <td>Anlagen Nr</td>
                        <td><?= $model->id ?></td>
                    </tr>
                    <tr>
                        <td>Betreiber</td>
                        <td><?= $model->getUser()->one()->Betreiber ?></td>
                    </tr>
                    <tr>
                        <td>Fabriks Nr</td>
                        <td><?= $model->FabriksNr ?></td>
                    </tr>
                    <tr>
                        <td>Prüfungsdatum</td>
                        <td><?= $model->LetzteDate ?></td>
                    </tr>
                    <tr>
                        <td>PLZ</td>
                        <td><?= $model->AdressePLZ ?></td>
                    </tr>
                    <tr>
                        <td>Ort</td>
                        <td><?= $model->AdresseOrt ?></td>
                    </tr>
                    <tr>
                        <td>Strasse</td>
                        <td><?= $model->AdresseStreat ?></td>
                    </tr>
                    <tr>
                        <td>Zusatz</td>
                        <td><?= $model->Zusatz ?></td>
                    </tr>
                    <tr>
                        <td>Type</td>
                        <td><?= $model->Type ?></td>
                    </tr>
                    <?php if ( $model->type2 ): ?>
                        <tr>
                            <td>Type 2</td>
                            <td><?= $model->type2 ?></td>
                        </tr>
                    <?php endif ?>
                    <tr>
                        <td>Baujahr</td>
                        <td><?= $model->Baujahr ?></td>
                    </tr>
                    <tr>
                        <td>Hersteller</td>
                        <td><?= $model->Hersteller ?></td>
                    </tr>
                    <?php if ( $model->Nennlast ): ?>
                        <tr>
                            <td>Nennlast</td>
                            <td><?= $model->Nennlast ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->AnzahltStellplatze ): ?>
                        <tr>
                            <td>AnzahltStellplatze</td>
                            <td><?= $model->AnzahltStellplatze ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->Parkeranagen ): ?>
                        <tr>
                            <td>Parkeranagen</td>
                            <td><?= $model->Parkeranagen ?></td>
                        </tr>
                    <?php endif ?>                    
                    <?php if ( $model->Antriebsart ): ?>
                        <tr>
                            <td>Antriebsart</td>
                            <td><?= $model->Antriebsart ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->Profintervall ): ?>
                        <tr>
                            <td>Prüfintervall</td>
                            <td><?= $model->Profintervall ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->ErstelltAm ): ?>
                        <tr>
                            <td>Erstellt am</td>
                            <td><?= $model->formatErstelltAmDate() ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->Letzte ): ?>
                        <tr>
                            <td>Letzter Prüfer</td>
                            <td><?= $model->Letzte ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->LetzteDate ): ?>
                        <tr>
                            <td>Prüfungsdatum</td>
                            <td><?= $model->LetzteDate ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->UIDNUMMER ): ?>
                        <tr>
                            <td>UIDNUMMER</td>
                            <td><?= $model->UIDNUMMER ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->Hausverwalter ): ?>
                        <tr>
                            <td>Hausverwalter</td>
                            <td><?= $model->Hausverwalter ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->HausverwalterEmail ): ?>
                        <tr>
                            <td>Hausverwalter Email</td>
                            <td><?= $model->HausverwalterEmail ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->KontaktVerwalter ): ?>
                        <tr>
                            <td>Verwalter Tel.</td>
                            <td><?= $model->KontaktVerwalter ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->status ): ?>
                        <tr>
                            <td>Status</td>
                            <td><?= $model->status ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->lat ): ?>
                        <tr>
                            <td>Lat</td>
                            <td><?= $model->lat ?></td>
                        </tr>
                    <?php endif ?>
                    <?php if ( $model->lng ): ?>
                        <tr>
                            <td>Lng</td>
                            <td><?= $model->lng ?></td>
                        </tr>
                    <?php endif ?>
                </tbody>
            </table>
            <?php if ( $model->Notizen != "" || $model->Notizen != null ): ?>
                <h1>Notizen</h1>
                <div>
                    <?= $model->Notizen ?>
                </div>
            <?php endif ?>
            <?php if ( $model->checkForbidenType() ): ?>
                <h1>Wartungsfirma</h1>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Name</td>
                            <td><?= $model->getWartungsfirma()->one()->name ?></td>
                        </tr>
                        <tr>
                            <td>Funktion</td>
                            <td><?= $model->getWartungsfirma()->one()->function ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endif ?>
            <h1>Prüfungen</h1>
            <?php foreach ($model->getTehnicReviews()->orderBy(['id' => SORT_DESC])->all() as $key => $application): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Datum</td>
                            <td><?= $application->formatDatum(); ?></td>
                        </tr>
                        <tr>
                            <td>Prüfungsdatum</td>
                            <?php if ( $application->Prufungsdatum != null || $application->Prufungsdatum != ""  ): ?>
                                <td><?= $application->formatPrufungsdatum(); ?></td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>
                        </tr>
                        <tr>
                            <td>Art</td>
                            <td><?= $application->Art; ?></td>
                        </tr>
                        <tr>
                            <td>Mängel</td>
                            <?php if ( $application->Mangel != "" || $application->Mangel !== null ): ?>
                                <td><?= $application->Mangel == 1 ? 'JA' : 'NEIN'; ?></td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>
                        </tr>
                        <tr>
                            <td>in Vollwart. enth.</td>
                            <td><?= $application->VollwartungEnthalten; ?></td>
                        </tr>
                        <tr>
                            <td>Kostenschätzung</td>
                            <td><?= $application->Kostenschatzung; ?></td>
                        </tr>
                        <tr>
                            <td>PDF</td>
                            <?php if ( $application->url != null || $application->url != ""  ): ?>
                                <td>
                                    <?php $link= $s3_path."pdf/". $application->url ?>
                                    <a target="_blank" href="<?php echo $link; ?>">Download PDF</a>
                                </td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>                            
                        </tr>
                        <tr>
                            <td>Fotos</td>
                            <td>
                                <?php if ( count( $application->getImages()->all() ) > 0 ): ?>
                                    <div>
                                        <?= $application->short_photo_description ?>
                                    </div>
                                    <?= Html::a('Fotos', ['fotos/view', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                <?php endif ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Mängel Fotos</td>
                            <td>
                                <?php if ( $application->getMangelsPhotos() ): ?>
                                    <?= Html::a('Fotos', ['fotos/mangel-photo', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                <?php endif ?>
                            </td>
                        </tr>
                        <?php if ( isset($rest_api->id) && $application->display_allgemeiner_zustand_images_exists() ): ?>
                            <tr>
                                <td>Allgemeiner Zustand Fotos</td>
                                <td>
                                    <?= Html::a('Fotos', ['fotos/allgemeiner-zustand', 'id' => $application->id], ['class' => 'btn btn-success']) ?>
                                </td>
                            </tr>
                        <?php endif ?>
                    </tbody>
                </table>
            <?php endforeach ?>
        </div>
    <?php endif ?>
    <?php if ( isset($documents[0]) ): ?>
        <h1>Documents</h1>
        <table class="table table-striped table-bordered table-grid-small">
            <thead>
                <tr>
                    <th>Documents</th>
                    <th>Delete</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($documents as $key => $document): ?>
                    <tr>                       
                        <?php if ( $document->url != null || $document->url != ""  ): ?>
                            <td>
                                <?php $link= $s3_path."documents/". $document->url ?>
                                <a target="_blank" href="<?php echo $link; ?>" class="btn btn-success"><?= $document->name; ?></a>
                            </td>
                            <td>
                                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-trash"></span>'), ['remove-document', 'document_id' => $document->id, 'id' => $model->id], [
                                    'class' => 'btn btn-danger btn-mobile-position', 'data-toggle' =>"tooltip", 'title'=> "Remove Document !",
                                    'data' => [
                                        'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                                        'method' => 'post',
                                    ],
                                ]) ?>
                            </td>
                        <?php else: ?>
                            <td></td>
                            <td></td>
                        <?php endif ?>
                    </tr>
                <?php endforeach ?>  
            </tbody>
        </table>
    <?php endif ?>
    <?= $show_google_map; ?>
</div>