<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\widgets\DetailView;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use dosamigos\tinymce\TinyMce;
/* @var $this yii\web\View */
/* @var $searchModel common\models\search\TehinicReviewSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Prüfungen');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tehnic-review-index">
    <div class="header-content">
        <h1 class="admin-title">Prüfungen</h1>
        <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success', 'data-toggle' =>"tooltip", 'title'=> "Neuer Prüfungen !"]) ?>
    </div>
    <div>
        <?php if( $desktop ): ?>
            <table id="theDatatable" class="table table-striped table-bordered table-grid-view">
                <thead>
                    <tr>
                        <th>Adresse</th>
                        <th>Anlagen Nr</th>
                        <th>Fabriks Nr</th>
                        <th>Betreiber</th>
                        <th colspan="2">Anlagen</th>
                        <th>PDF</th>
                        <th>Hausverwalter Email</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= $anlagen->AdressePLZ; ?> <?= $anlagen->AdresseOrt; ?>, <?= $anlagen->AdresseStreat; ?></td>
                        <td><?= $anlagen->id; ?></td>
                        <td><?= $anlagen->FabriksNr; ?></td>
                        <td><?= $anlagen->getUser()->one()->Betreiber; ?></td>
                        <td>
                            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-eye-open"></span>'), ['/tehnical/view', 'id' => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Show Anlagen", 'target' => "_blank"]) ?>
                        </td>
                        <td>
                            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-pencil"></span>'), ['/tehnical/update', 'id' => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Update Anlagen", 'target' => "_blank"]) ?>
                        </td>
                        <td><?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-list-alt"></span>'), ['pdf/pdf-view', "id" => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Download last PDF !", 'target' => '_blank']) ?>
                        </td>
                        <td><?= $anlagen->HausverwalterEmail; ?></td>
                    </tr>
                </tbody>
            </table>
        <?php else: ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Anlagen Nr</td>
                            <td><?= $anlagen->id ?></td>
                        </tr>
                        <tr>
                            <td>PLZ</td>
                            <td><?= $anlagen->AdressePLZ ?></td>
                        </tr>
                        <tr>
                            <td>Ort</td>
                            <td><?= $anlagen->AdresseOrt ?></td>
                        </tr>
                        <tr>
                            <td>Strasse</td>
                            <td><?= $anlagen->AdresseStreat ?></td>
                        </tr>
                        <tr>
                            <td>Zusatz</td>
                            <td><?= $anlagen->Zusatz ?></td>
                        </tr>
                        <tr>
                            <td>Betreiber</td>
                            <td><?= $anlagen->getUser()->one()->Betreiber; ?></td>
                        </tr>
                        <tr>
                            <td>Anlagen</td>
                            <td><?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-eye-open"></span>'), ['/tehnical/view', 'id' => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Show Anlagen", 'target' => "_blank"]) ?></td>
                        </tr>
                        <tr>
                            <td>PDF</td>
                            <td><?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-list-alt"></span>'), ['pdf/pdf-view', "id" => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Download last PDF !", 'target' => '_blank']) ?></td>
                        </tr>
                        <tr>
                            <td>Hausverwalter Email</td>
                            <td><?= $anlagen->HausverwalterEmail; ?></td>
                        </tr>
                    </tbody>
                </table>
        <?php endif ?>
    </div>
    <div class="form-invitation rotate3d">
        <div class="form-invitation-header">
            <h3>Send Email to Hausverwalter</h3>
            <?= Html::a(Yii::t('app', ''), ['index'], ['class' => 'btn-close-postion glyphicon glyphicon-remove-circle']) ?>
        </div>
        <?php $form = ActiveForm::begin(); ?>
            <p class="hide"><?php $user_information->send_standard_content_with_email = 1 ?></p>
            <?= $form->field($user_information, 'send_standard_content_with_email')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-check'))->label("Default Content"); ?>
            <?= $form->field($user_information, 'send_attachement')->radioList(array(1 => 'Yes', 0 =>'No'), array('class' => 'is-check-attachement'))->label("Send attachement"); ?>            
            <div class="form-group form-group-subject-visible">
                <label>Emails</label> 
                <?= $form->field($user_information, 'emails')->textInput(['maxlength' => 255, 'class' => 'form-control'])->label(false); ?>
            </div>
            <div class="form-group form-group-subject-visible hide">
                <label>Subject</label> 
                <?= $form->field($user_information, 'subject')->textInput(['maxlength' => 255, 'class' => 'form-control'])->label(false); ?>
            </div>
            <?= $form->field($user_information, 'send_message_from_mail')->widget(TinyMce::className(), [
                'options' => ['rows' => 5],
                'language' => 'de',
                'clientOptions' => [
                    'branding' => false,
                    'plugins' => [
                        "advlist autolink lists link charmap print preview anchor",
                        "searchreplace visualblocks code fullscreen",
                        "insertdatetime media table contextmenu paste"
                    ],
                    'toolbar' => "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"
                ]
            ])->label("Message");?>
            <div class="form-group text-center">
                <?= Html::submitButton('', ['class' => 'btn btn-success glyphicon glyphicon-envelope', 'value' => 'send_email']) ?>
            </div>            
        <?php ActiveForm::end(); ?>
    </div>
</div>