<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\widgets\DetailView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\LinkPager;
use yii\widgets\ActiveForm;
use common\models\Type;

/* @var $this yii\web\View */
/* @var $searchModel common\models\search\TehinicReviewSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
    $s3_path = S3_PATH;
    $link = $s3_path."pdf/";
    $this->title = Yii::t('app', 'Prüfungen');
    $this->params['breadcrumbs'][] = $this->title;
?>
<div class="tehnic-review-index">
    <div class="header-content">
        <h1 class="admin-title">Prüfungen</h1>
    </div>
    <?php if( $desktop ): ?>
        <?php Pjax::begin(); ?>    <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],

                [
                    'label' => 'Anlagen Nr',
                    'value' => function ($data){ return "AT".$data->getTehnic()->one()->id; },
                ],
                [
                    'label' => 'url',
                    'format' => 'raw',
                    'attribute' => 'url',
                    'value' => function ($data) {
                        $s3_path = S3_PATH;
                        $link = $s3_path."pdf/";
                        return Html::a($data->url, $link.$data['url'], ['target'=>'_blank', 'class' => "glyphicon"]);
                    },
                ],
                'Art',
                [
                    'label' => 'Anlagen Type',
                    'attribute' => "Type",
                    'value' => function ($data){ return $data->getTehnic()->one()->Type; },
                    'filter' => Html::activeDropDownList($searchModel, 'Type', ArrayHelper::map(Type::find()->asArray()->all(), 'name', 'name'),['class'=>'form-control','prompt' => 'Select Type']),
                ],
                [
                    'label' => 'Prufungsdatum',
                    'attribute' => 'Prufungsdatum',
                    'value' => function ($data){ 
                        if ( $data->Prufungsdatum != null || $data->Prufungsdatum != ""  ) {

                            return $data->formatPrufungsdatum();
                        }else {

                            return "";
                        }
                    }
                ],
                [
                    'label' => 'datum',
                    'attribute' => 'datum',
                    'value' => function ($data){ 
                        if ( $data->datum != null || $data->datum != ""  ) {

                            return $data->formatDatum();
                        }else {

                            return "";
                        }
                    }
                ],
                [
                    'label' => 'Mangel',
                    'value' => function ($data){ 
                        if( $data->Mangel != "" || $data->Mangel !== null ) {

                            return $data->Mangel == 1 ? 'JA' : 'NEIN';
                        }else {

                            return "";
                        }

                        return $data->Mangel == 1 ? 'JA' : 'NEIN'; },
                ],
                [
                    'label' => 'Created by',
                    'value' => function ($data){ 
                        if( $data->author_full_name != "Not Set" ) {

                            return $data->author_full_name;
                        }else {

                            return $data->author_email;
                        }
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => 'Send Email',
                    'value' => function($model, $key, $index, $column) use ($permission) {
                        if( $permission->tehnic_review_send_email ) {
                            if( $model->send_email ) {
                                return Html::a(
                                    '',
                                    Url::to(['send-email', "prufungen_id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['send-email', "prufungen_id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-envelope btn-green',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "You have already sent email to Customer !",
                                    ]
                                );
                            }else {
                                return Html::a(
                                    '',
                                    Url::to(['send-email', "prufungen_id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['send-email', "prufungen_id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-envelope',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Send Email to Customer !",
                                    ]
                                );
                            }
                        }else {

                            return "";
                        }
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => 'Api',
                    'value' => function($model, $key, $index, $column) {

                        if( $model->ensure_exist_api_for_anlagen($model) ) {
                            if( $model->coworker_active == 1 ) {
                                return Html::a(
                                    '',
                                    Url::to(['update-api', "prufungen_id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['send-email', "prufungen_id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-star btn-green',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "You have already sent data to Customer !",
                                    ]
                                );
                            }else {
                                return Html::a(
                                    '',
                                    Url::to(['update-api', "prufungen_id" => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['send-email', "prufungen_id" => $model->id]),
                                        'class'=>'glyphicon glyphicon-star-empty',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Send data to Customer !",
                                    ]
                                );
                            }
                        }else {
                            return "";
                        }
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => '',
                    'value' => function($model, $key, $index, $column) use ($permission) {

                        return Html::a(
                            '',
                            Url::to(['view', 'id' => $model->id]), 
                            [
                                'id'=>'grid-custom-button',
                                'data-pjax'=>true,
                                'action'=>Url::to(['update', 'id' => $model->id]),
                                'class'=>'glyphicon glyphicon-eye-open',
                            ]
                        );
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => '',
                    'value' => function($model, $key, $index, $column) use ($permission) {
                        if( $permission->tehnic_review_edit ) {

                            return Html::a(
                                '',
                                Url::to(['update', 'id' => $model->id]), 
                                [
                                    'id'=>'grid-custom-button',
                                    'data-pjax'=>true,
                                    'action'=>Url::to(['update', 'id' => $model->id]),
                                    'class'=>'btn-edit glyphicon glyphicon-pencil',
                                ]
                            );
                        }else {

                            return "";
                        }
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => '',
                    'value' => function($model, $key, $index, $column) use ($permission) {
                        if( $permission->tehnic_review_destroy ) {

                            return Html::a(
                                '',
                                Url::to(['delete', 'id' => $model->id]), 
                                [
                                    'id'=>'grid-custom-button',
                                    'data-pjax'=>true,
                                    'action'=>Url::to(['delete', 'id' => $model->id]),
                                    'class'=>'btn-delete glyphicon glyphicon-trash',
                                    'data' => [
                                        'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                                        'method' => 'post',
                                    ],
                                ]
                            );
                        }else {
                            
                            return "";
                        }
                    }
                ],
            ],
            'tableOptions' => [
                'id' => 'theDatatable',
                'class'=>'table table-striped table-bordered table-grid-view pdf-style-columns'
            ],]); ?>
        <?php Pjax::end(); ?>
    <?php else: ?>
        <?php Pjax::begin(); ?>
            <?php $form = ActiveForm::begin([
                    'action' => ['index'],
                    'method' => 'get',
                ]); ?>
                <label>Seach Prüfungen:</label>
                <?= $form->field($searchModelGlobal, 'globalSearch')->textInput(['maxlength' => true, 'placeholder' => 'Search'])->label(false); ?>
                <div class="form-group">
                    <?= Html::submitButton('Search', ['class' => 'btn btn-primary hide']) ?>
                </div>
            <?php ActiveForm::end(); ?>
            <?php foreach ($tehnical_reviews_mobile->getModels() as $key => $model ): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>url</td>
                            <td>
                                <a href="<?= $link.$model->url ?>" target="_blank"><?= $model->url ?></a>*
                            </td>
                        </tr>
                        <tr>
                            <td>Prufungsdatum</td>
                            <td><?= $model->Prufungsdatum ?></td>
                        </tr>
                        <tr>
                            <td>Datum</td>
                            <td>
                                <?php if( $model->datum != "" || $model->datum !== null ): ?>
                                    <?= $model->formatDatum(); ?>
                                <?php endif ?>
                            </td>
                        </tr>
                        <tr>
                            <td>Mangel</td>
                            <?php if( $model->Mangel != "" || $model->Mangel !== null ): ?>
                                <td><?= $model->Mangel == 1 ? 'JA' : 'NEIN' ?></td>
                            <?php else: ?>
                                <td></td>
                            <?php endif ?>
                        </tr>
                        <tr>
                            <td>Created by</td>
                            <?php if( $model->author_full_name != "Not Set" ): ?>
                                <td><?= $model->author_full_name ?></td>
                            <?php else: ?>
                                <td><?= $model->author_email ?></td>
                            <?php endif ?>
                        </tr>
                        <?php if( $permission->tehnic_review_send_email ): ?>
                            <tr>
                                <td>Send Email</td>
                                <td>
                                    <?php if ( $model->send_email ): ?>
                                        <?= Html::a('<span class="glyphicon glyphicon-envelope btn-green"></span>', ['send-email', "prufungen_id" => $model->id], ['class' => 'show-form-on-click']) ?>
                                    <?php else: ?>
                                        <?= Html::a('<span class="glyphicon glyphicon-envelope"></span>', ['send-email', "prufungen_id" => $model->id], ['class' => 'show-form-on-click']) ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endif ?>
                        <tr>
                            <td>Send data to Customer !</td>
                            <td>
                                <?php if ( $model->ensure_exist_api_for_anlagen($model) ): ?>
                                   <?= $model->coworker_active ?>
                                    <?php if ( $model->coworker_active == 1 ): ?>
                                        <?= Html::a('<span class="glyphicon glyphicon-star btn-green"></span>', ['update-api', "prufungen_id" => $model->id], ['class' => 'show-form-on-click']) ?>
                                    <?php else: ?>
                                        <?= Html::a('<span class="glyphicon glyphicon-star-empty btn-green"></span>', ['update-api', "prufungen_id" => $model->id], ['class' => 'show-form-on-click']) ?>
                                    <?php endif; ?>                                    
                                <?php endif; ?>
                            </td>
                        </tr>          
                        <tr>
                            <td>Details</td>
                            <td><?= Html::a('Details', ['view', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach ?>
            <div class="pagination">
                <?php
                    echo LinkPager::widget([
                    'pagination' => $pages,
                ]); ?>
            </div>
        <?php Pjax::end(); ?>
    <?php endif ?>
</div>