<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\LinkPager;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Prüfintervall');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="profintervall-index">
    <div class="header-content">
        <h1 class="admin-title">Prüfintervall</h1>
        <?php if( $permission->profintervall_new ): ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success', 'data-toggle' =>"tooltip", 'title'=> "Neuer Profintervall !"]) ?>
        <?php endif ?>
    </div>
    <?php if( $desktop ): ?>
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'columns' => [
                ['class' => 'yii\grid\SerialColumn'],
                'name',
                [
                    'format' => 'raw',
                    'label' => '',
                    'value' => function($model, $key, $index, $column) {

                        return Html::a(
                            '',
                            Url::to(['view', 'id' => $model->id]), 
                            [
                                'id'=>'grid-custom-button',
                                'data-pjax'=>true,
                                'action'=>Url::to(['update', 'id' => $model->id]),
                                'class'=>'glyphicon glyphicon-eye-open',
                            ]
                        );
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => '',
                    'value' => function($model, $key, $index, $column) use ($permission) {
                        if( $permission->profintervall_edit ) {

                            return Html::a(
                                '',
                                Url::to(['update', 'id' => $model->id]), 
                                [
                                    'id'=>'grid-custom-button',
                                    'data-pjax'=>true,
                                    'action'=>Url::to(['update', 'id' => $model->id]),
                                    'class'=>'btn-edit glyphicon glyphicon-pencil',
                                ]
                            );
                        }else {

                            return "";
                        }
                    }
                ],
                [
                    'format' => 'raw',
                    'label' => '',
                    'value' => function($model, $key, $index, $column) use ($permission) {
                        if( $permission->profintervall_destroy ) {

                            return Html::a(
                                '',
                                Url::to(['delete', 'id' => $model->id]), 
                                [
                                    'id'=>'grid-custom-button',
                                    'data-pjax'=>true,
                                    'action'=>Url::to(['delete', 'id' => $model->id]),
                                    'class'=>'btn-delete glyphicon glyphicon-trash',
                                    'data' => [
                                        'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                                        'method' => 'post',
                                    ],
                                ]
                            );
                        }else {
                            
                            return "";
                        }
                    }
                ],
            ],
            'tableOptions' => [
                'id' => 'theDatatable',
                'class'=>'table table-striped table-bordered table-grid-small'
            ],
        ]); ?>
    <?php else: ?>
        <?php foreach ($dataProvider->getModels() as $key => $model ): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Name</td>
                            <td><?= $model->name ?></td>
                        </tr>
                        <?php if( $permission->profintervall_edit ): ?>
                            <tr>
                                <td>Update</td>
                                <td><?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                            </tr>
                        <?php endif ?>
                        <tr>
                            <td>Details</td>
                            <td><?= Html::a('Details', ['view', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach ?>
            <div class="pagination">
                <?php
                echo LinkPager::widget([
                'pagination' => $pagination,
            ]); ?>
            </div>
    <?php endif ?>
</div>
