<?php

/* @var $this \yii\web\View */
/* @var $content string */

    use backend\assets\AppAsset;
    use yii\helpers\Html;
    use yii\bootstrap\Nav;
    use yii\bootstrap\NavBar;
    use yii\widgets\Breadcrumbs;
    use common\widgets\Alert;
    use common\models\User;
    use common\models\Responsive;

    $id = Yii::$app->user->getId();
    if($id) {

        $user = User::find()->where(['id' => $id])->one();
        $desktop = $user->getResponsive()->desktop;
    }else {

        $user = null;
        $desktop = Responsive::findOne(1)->desktop;
    }


    if ( $user ) {

        $permission = $user->getCoworekerPermission();
        $kunden = $permission->kunden;
        $anlagen = $permission->tehnical;
        $prufungen = $permission->tehnic_review;
        $karte = $permission->karte;
        $aufzugswarter = $permission->aufzugswarter;
        $wartungsfirma = $permission->wartungsfirma;
        $karte_marked = $permission->karteMarked;
        $karte_week = $permission->karteWeek;
        $type = $permission->type;
        $type2 = $permission->type2;
        $antriebsart = $permission->antriebsart;
        $betriebskontrollen = $permission->betriebskontrollen;
        $profintervall = $permission->profintervall;
        $art = $permission->art;
        $wartungsfirmafunction = $permission->wartungsfirmafunction;
        $anlagentyp = $permission->anlagentyp;
        $wartungsart = $permission->wartungsart;
        $anlagen_status = $permission->anlagen_status;
        $send_emails = $permission->send_emails;
        $excel_api = $permission->excel_api;
        $gerat_mangels = $permission->gerat_mangels;
        $profile = $permission->profile;
        $excel_inovice = $permission->excel_inovice;
        $norm = $permission->norm;
        $prufgrundlage = $permission->prufgrundlage;        
    }else {

        $kunden = 0;
        $anlagen = 0;
        $prufungen = 0;
        $karte = 0;
        $aufzugswarter = 0;
        $wartungsfirma = 0;
        $karte_marked = 0;
        $karte_week = 0;
        $type = 0;
        $type2 = 0;
        $antriebsart = 0;
        $betriebskontrollen = 0;
        $profintervall = 0;
        $art = 0;
        $wartungsfirmafunction = 0;
        $anlagentyp = 0;
        $wartungsart = 0;
        $anlagen_status = 0;
        $send_emails = 0;
        $excel_api = 0;
        $gerat_mangels = 0;
        $profile = 0;
        $excel_inovice = 0;
        $norm = 0;
        $prufgrundlage = 0;
    }

    $id = Yii::$app->user->getId();
    if ($id) {

        $user = User::find()->where(['id' => $id])->one();
        $desktop = $user->getResponsive()->desktop;
    } else {

        $user = null;
        $desktop = Responsive::findOne(1)->desktop;
    }

    if ($user && $user->role_id == "4") {

        $logo_url = Yii::$app->homeUrl . "coworkers/admin/index";
    } else {

        $logo_url = Yii::$app->homeUrl;
    }

    AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="SHORTCUT ICON" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" />
    <link rel="icon" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" />
    <link rel="shortcut icon" href="http://freieingenieure.s3-eu-central-1.amazonaws.com/live/image/favicon.ico" type="image/x-icon" />
    <link rel="shortcut icon" href="<?php echo Yii::$app->request->baseUrl; ?>/favicon.ico" type="image/x-icon" />
    <link href="https://fonts.googleapis.com/css?family=Encode+Sans+Expanded|Lato|Montserrat|Open+Sans|Raleway|Roboto" rel="stylesheet">
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title> 
    <?php $this->head() ?>
</head>
<body>
<?php $this->beginBody() ?>

<div class="wrap">
    <?php
    NavBar::begin([
        'brandLabel' => Html::img(Yii::$app->request->baseUrl.'/images/FI_logo.jpg', ['alt'=>Yii::$app->name, 'class' => 'img-responsive img-freie']),
        'brandUrl' => $logo_url,
        'options' => [
            'class' => 'navbar-inverse navbar-fixed-top',
        ],
    ]);
    if ( Yii::$app->user->getId() && $user->role_id == '4' )
    { 
        $menuItems = [
            ['label' => $desktop ? '<span class="glyphicon glyphicon-phone navbar-responsive-logo"></span>' : '<span class="glyphicon glyphicon-modal-window navbar-responsive-logo"></span>', 'url' => ['/responsive/index']],
            ['label' => 'Kunden', 'url' => ['/coworkers/admin/index'], 'visible' => $kunden],
            ['label' => 'Anlagen', 'url' => ['/coworkers/tehnical/index'], 'visible' => $anlagen],
            ['label' => 'Prüfungen', 'url' => ['/coworkers/tehnic-review'], 'visible' => $prufungen],
            ['label' => 'Marked', 'url' => ['/coworkers/karte/index'], 'visible' => $karte],
            [
                'label' => 'Settings',
                'items' => [
                    ['label' => 'Aufzugswärter', 'url' => ['/coworkers/aufzugswarter/index'], 'visible' => $aufzugswarter],
                    ['label' => 'Wartungsfirma', 'url' => ['/coworkers/wartungsfirma/index'], 'visible' => $wartungsfirma],
                    ['label' => 'Karte Marked', 'url' => ['/coworkers/karte/marked'], 'visible' => $karte_marked],
                    ['label' => 'Karte Week', 'url' => ['/coworkers/karte/week'], 'visible' => $karte_week],
                    ['label' => 'Type', 'url' => ['/coworkers/type/index'], 'visible' => $type],
                    ['label' => 'Type 2', 'url' => ['/coworkers/type2/index'], 'visible' => $type2],
                    ['label' => 'Antriebsart', 'url' => ['/coworkers/antriebsart/index'], 'visible' => $antriebsart],
                    ['label' => 'Betriebskontrollen', 'url' => ['/coworkers/betriebskontrollen/index'], 'visible' => $betriebskontrollen],
                    ['label' => 'Prüfintervall', 'url' => ['/coworkers/profintervall/index'], 'visible' => $profintervall],
                    ['label' => 'Art', 'url' => ['/coworkers/art/index'], 'visible' => $art],
                    ['label' => 'Wartungsfirma Function', 'url' => ['/coworkers/wartungsfirmafunction/index'], 'visible' => $wartungsfirmafunction],
                    ['label' => 'Anlagentyp', 'url' => ['/coworkers/anlagentyp/index'], 'visible' => $anlagentyp],
                    ['label' => 'Wartungsart', 'url' => ['/coworkers/wartungsart/index'], 'visible' => $wartungsart],
                    ['label' => 'Anlagen Status', 'url' => ['/coworkers/anlagen-status/index'], 'visible' => $anlagen_status],
                    ['label' => 'Send Email', 'url' => ['/coworkers/send-emails/index'], 'visible' => $send_emails],
                    ['label' => 'Excel Api', 'url' => ['/coworkers/excel-api/index'], 'visible' => $excel_api],
                    ['label' => 'Gerät Mangel', 'url' => ['/coworkers/gerat-mangels/index'], 'visible' => $gerat_mangels],
                    ['label' => 'My Profile', 'url' => ['/coworkers/profile/index'], 'visible' => $profile],
                    ['label' => 'Invoice Excel', 'url' => ['/coworkers/invoice/download'], 'visible' => $excel_inovice],
                    ['label' => 'Norm', 'url' => ['/coworkers/norm/index'], 'visible' => $norm],
                    ['label' => 'Prufgrundlage', 'url' => ['/coworkers/prufgrundlage/index'], 'visible' => $prufgrundlage],
                    ['label' => 'Mängel', 'url' => ['/coworkers/mangel-properties/index']],
                ],
            ],
        ];
    }elseif (Yii::$app->user->getId() && $user->role_id == '2') {
        $menuItems = [
        ];
    }
    if (Yii::$app->user->isGuest) {
        $menuItems[] = ['label' => 'Login', 'url' => ['/site/login']];
    } else {
        $menuItems[] = '<li>'
            . Html::beginForm(['/site/logout'], 'post')
            . Html::submitButton(
                'Logout (' . Yii::$app->user->identity->username . ')',
                ['class' => 'btn btn-link logout']
            )
            . Html::endForm()
            . '</li>';
    }
    echo Nav::widget([
        'options' => ['class' => 'navbar-nav navbar-right'],
        'items' => $menuItems,
        'encodeLabels' => false,
    ]);
    NavBar::end();
    ?>

    <div class="container container-mobile">
        <?= Breadcrumbs::widget([
            'links' => isset($this->params['breadcrumbs']) ? $this->params['breadcrumbs'] : [],
        ]) ?>
        <?= Alert::widget() ?>
        <?= $content ?>
    </div>
</div>



<?php $this->endBody() ?>
</body>
</html>
<?php $this->endPage() ?>
