<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
	$this->title = Yii::t('app', 'Marked');
	$this->params['breadcrumbs'][] = "Marked";
?>
<div class="tehnical-index">
    <div class="header-content">
        <h1 class="admin-title">Marked</h1>
        <?php if( $permission->karteMarked ): ?>
            <div class="button-wrapper">
            	<?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-globe"></span>'), ['karte/marked'], ['class' => 'btn btn-success', 'data-toggle' =>"tooltip", 'title'=> "Karte Marked"]) ?>
            </div>
        <?php endif ?>
    </div>
    <?php if( $desktop ): ?>
		<table id="theDatatable" class="table table-striped table-bordered table-grid-view">
			<thead>
				<tr>
					<th>#</th>
					<th>Anlagen Nr</th>
					<th>FabriksNr</th>
					<th>Prüfungsdatum</th>
					<th>AdressePLZ</th>
					<th>AdresseOrt</th>
					<th>AdresseStreat</th>
					<th>Zusatz</th>
					<th>Type</th>
					<th>Betreiber</th>
					<th>View Anlagen</th>
					<th>Unmark</th>
					<th>PDF</th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ($model as $key => $anlagen) : ?>
					<tr>
						<td><?= $key + 1 ?></td>
						<td>AT.<?= $anlagen->id ?></td>
						<td><?= $anlagen->FabriksNr ?></td>
						<td><?= $anlagen->LetzteDate ?></td>
						<td><?= $anlagen->AdressePLZ ?></td>
						<td><?= $anlagen->AdresseOrt ?></td>
						<td><?= $anlagen->AdresseStreat ?></td>
						<td><?= $anlagen->Zusatz ?></td>
						<td><?= $anlagen->Type ?></td>
						<td><?= $anlagen->getUser()->one()->Betreiber; ?></td>
						<td><?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-eye-open"></span>'), ['/coworkers/tehnical/view', 'id' => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Show Anlagen", 'target' => "_blank"]) ?></td>
						<td>
                            <?php if( $permission->tehnical_add_lat_lang ): ?>
                                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-erase"></span>'), ['remove', 'id' => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Remove Anlagen from Google Map ( Karte Marked )"]) ?>
                            <?php endif ?>
                        </td>
						<td>
                            <?php if( $permission->tehnical_pdf_preview ): ?>
                                <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-list-alt"></span>'), ['/coworkers/pdf/pdf-view', "id" => $anlagen->id], ['class' => '', 'data-toggle' =>"tooltip", 'title'=> "Download last PDF !", 'target' => '_blank']) ?>
                            <?php endif ?>       
                        </td>
					</tr>
				<?php endforeach ?>
			</tbody>
		</table>
	<?php else: ?>
		<?php foreach ($model as $key => $anlagen ): ?>
                <table class="table table-striped table-hover table-bordered table-mobile">
                    <tbody>
                        <tr>
                            <td>Fabriks Nr</td>
                            <td><?= $anlagen->FabriksNr ?></td>
                        </tr>
                        <tr>
                            <td>PLZ</td>
                            <td><?= $anlagen->AdressePLZ ?></td>
                        </tr>
                        <tr>
                            <td>Ort</td>
                            <td><?= $anlagen->AdresseOrt ?></td>
                        </tr>
                        <tr>
                            <td>Strasse</td>
                            <td><?= $anlagen->AdresseStreat ?></td>
                        </tr>
                        <tr>
                            <td>Zusatz</td>
                            <td><?= $anlagen->Zusatz ?></td>
                        </tr>
                        <tr>
                            <td>Type</td>
                            <td><?= $anlagen->Type ?></td>
                        </tr>
                        <tr>
                            <td>Betreiber</td>
                            <td><?= $anlagen->getUser()->one()->Betreiber; ?></td>
                        </tr>
                        <tr>
                            <td>View Anlagen <?=  $anlagen->id ?></td>
                            <td><?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-eye-open"></span>'), ['/coworkers/tehnical/view', 'id' => $anlagen->id], ['class' => 'btn btn-block btn-primary', 'target' => "_blank"]) ?></td>
                        </tr>
                        <tr>
                            <td>PDF</td>
                            <td><?= Html::a('<span class="glyphicon glyphicon-list-alt"></span>', ['/coworkers/pdf/pdf-view', "id" => $anlagen->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                        </tr>
                        <tr>
                            <td>Unmark</td>
                            <td><?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-erase"></span>'), ['remove', 'id' => $anlagen->id], ['class' => ' btn btn-block btn-primary']) ?></td>
                        </tr>
                    </tbody>
                </table>
            <?php endforeach ?> 
	<?php endif ?>
</div>