<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

?>
<?php if( $model->display_spielplatzgerat_object() ): ?>
    <div class="container mt40">
        <section class="row">
			<h3>Inspektionsobjekt Fotos</h3>
		    <?php foreach ($model->display_spielplatzgerat_object() as $key => $image): ?>
			    <article class="col-xs-12 col-sm-6 col-md-3">
			        <div class="panel panel-default">
			            <div class="panel-body">
			                <a href="<?= $image->showImageInNewTab(); ?>" target="_blank title="Fotos" class="zoom" data-title="Fotos" data-footer="Fotos" data-type="image" data-toggle="lightbox">
			                    <?= Html::img( $image->showImage(), ['class' => 'desktop-show-logo']);?>
			                    <span class="overlay"><i class="glyphicon glyphicon-fullscreen"></i></span>
			                </a>
			            </div>
			        </div>
			    </article>
			<?php endforeach ?>
		</section>
	</div>
<?php endif ?>
<?php if( $model->display_gerat_object_exists() ): ?>

    <div class="container mt40">
        <section class="row">
			<h3>Gerät Fotos</h3>
		    <?php foreach ($model->display_gerat_object() as $key => $image): ?>
			    <article class="col-xs-12 col-sm-6 col-md-3">
			        <div class="panel panel-default">
			            <div class="panel-body">
			                <a href="<?= $image->showGeratImageInNewTab(); ?>" target="_blank title="Fotos" class="zoom" data-title="Fotos" data-footer="Fotos" data-type="image" data-toggle="lightbox">
			                    <?= Html::img( $image->showGeratImage(), ['class' => 'desktop-show-logo']);?>
			                    <span class="overlay"><i class="glyphicon glyphicon-fullscreen"></i></span>
			                </a>
			            </div>
			        </div>
			    </article>
			<?php endforeach ?>
		</section>
	</div>
<?php endif ?>