<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use common\models\Tehnical;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use dosamigos\datepicker\DatePicker;

/* @var $this yii\web\View */
/* @var $model common\models\Aufzugswarter */
/* @var $form yii\widgets\ActiveForm */
$data = ArrayHelper::map(Tehnical::find()->all(),'id','FabriksNr');
?>

<div class="aufzugswarter-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'tehnic_id')->widget(Select2::classname(), [
	    'data' => $data,
	    'language' => 'de',
	    'options' => ['multiple' => true, 'placeholder' => 'Select a state ...'],
	    'pluginOptions' => [
	        'allowClear' => true
	    ],
	]) ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'function')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'tel')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

    <div class="form-group">
        <label class="control-label" for="tehnical-baujahr">Geprüft am</label>
        <?= DatePicker::widget([
            'model' => $model,
            'attribute' => 'GepruftAm',
            'template' => '{addon}{input}',
                'clientOptions' => [
                    'autoclose' => true,
                    'format' => 'yyyy-m-dd'
                ]
        ]);?>
    </div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
