<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model common\models\User */

/*$this->title = Yii::t('app', 'Update {modelClass}: ', [
    'modelClass' => 'User',
]) . $model->id;*/
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Kunden'), 'url' => ['index']];
$this->params['breadcrumbs'][] = Yii::t('app', 'Update');
?>
<div class="application-wrapper">
    <div class="row header-wrapper">
        <div class="col-xs-10">
            <h2 class="admin-title"><strong>Update Kunden</strong></h2>
        </div>
        <div class="col-xs-2 btn-header">
            
        </div>
    </div>
    <div class="row">
        <div class="col-xs-8 col-xs-offset-2">
	    	<?php $form = ActiveForm::begin(['options' => ['class' => 'admin-form']]); ?>

                <?= $form->field($model, 'email'); ?>

                <?= $form->field($model, 'Betreiber'); ?>
                <?php if( $desktop ): ?>
                    <div class="adresse-tehnic">
                        <?= $form->field($model, 'AdresseStreat')->textInput(['maxlength' => true])->label("Strasse") ?>
                        <?= $form->field($model, 'AdresseOrt')->textInput(['maxlength' => true])->label("Ort") ?>
                        <?= $form->field($model, 'AdressePLZ')->textInput(['maxlength' => true])->label("PLZ") ?>
                        <?= $form->field($model, 'Telefonnummer')->textInput(['maxlength' => true])->label("Telefonnummer") ?>
                        <?= $form->field($model, 'BetreiberPdf')->checkbox(['class' => "role_chackbox_all"]) ?>
                    </div>
                <?php else: ?>
                    <?= $form->field($model, 'AdresseStreat')->textInput(['maxlength' => true])->label("Strasse") ?>
                    <?= $form->field($model, 'AdresseOrt')->textInput(['maxlength' => true])->label("Ort") ?>
                    <?= $form->field($model, 'AdressePLZ')->textInput(['maxlength' => true])->label("PLZ") ?>
                    <?= $form->field($model, 'Telefonnummer')->textInput(['maxlength' => true])->label("Telefonnummer") ?>

                <?php endif ?>
                <div class="form-group <?= $desktop ? '' : 'text-center' ?>">
                    <?= Html::a(Yii::t('app', 'Change Password'), ['change-password', 'id' => $model->id], ['class' => 'btn btn btn-warning']) ?>
                </div>           
                <div class="form-group btn-postion <?= $desktop ? '' : 'text-center' ?>">
                    <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
                </div>
			<?php ActiveForm::end(); ?>
        </div>    
    </div>
</div>