<?php


use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use yii\helpers\Url;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use kartik\select2\Select2;
use common\models\Role;
use yii\widgets\LinkPager;

$this->title = Yii::t('app', 'Kunden');
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="application-wrapper">
    <div class="header-content header-content-mobile">
        <h1>Kunden</h1>
        <?php if( $permission->kunden && $permission->kunden_new ): ?>
            <?= Html::a(Yii::t('app', '<span class="glyphicon glyphicon-plus"></span>'), ['create'], ['class' => 'btn btn-success btn-add-postion', 'data-toggle' =>"tooltip", 'title'=> "Neuer Kunde !"]) ?>
        <?php endif ?>
    </div>
    <?php if( $desktop ): ?>
        <?php Pjax::begin(); ?>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                   'rowOptions' => function ($model) {
                },
                'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    'email',
                    [
                        'label' => 'Role',
                        'value' => function ($data){ return $data->getRole()->one()->name; },
                    ],
                    'Betreiber',
                    ['label' => 'Strasse',
                       'attribute' => "AdresseStreat",
                       'value' => function ($data){ return $data->AdresseStreat; },
                    ],
                    ['label' => 'Ort',
                       'attribute' => "AdresseOrt",
                       'value' => function ($data){ return $data->AdresseOrt; },
                    ],
                    ['label' => 'PLZ',
                       'attribute' => "AdressePLZ",
                       'value' => function ($data){ return $data->AdressePLZ; },
                    ],
                    ['label' => 'Tel.',
                       'attribute' => "Telefonnummer",
                       'value' => function ($data){ return $data->Telefonnummer; },
                    ],
                    [
                        'format' => 'raw',
                        'label' => 'Send Email',
                        'value' => function($model, $key, $index, $column) use ($permission)  {

                            if( $model->role_id != 1 && $permission->kuden_send_email ) {
                                return Html::a(
                                    '',
                                    Url::to(['send-email', 'user_id' => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['send-email', 'user_id' => $model->id]),
                                        'class'=>'glyphicon glyphicon-envelope show-form-on-click',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Send Email to Customer !",
                                    ]
                                );
                            }else {
                                
                                return "";
                            }
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => '',
                        'value' => function($model, $key, $index, $column) use ($permission) {
                            if( $model->role_id != 1 && $permission->kunden_edit ) {
                                return Html::a(
                                    '',
                                    Url::to(['update', 'id' => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['update', 'id' => $model->id]),
                                        'class'=>'btn-edit glyphicon glyphicon-pencil',
                                    ]
                                );
                            }else {

                                return "";
                            }
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => '',
                        'value' => function($model, $key, $index, $column) use ($permission) {
                            if( $model->role_id != 1 && $permission->kunden_destroy ) {
                                return Html::a(
                                    '',
                                    Url::to(['delete', 'id' => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['delete', 'id' => $model->id]),
                                        'class'=>'btn-delete glyphicon glyphicon-trash',
                                        'data' => [
                                            'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                                            'method' => 'post',
                                        ],
                                    ]
                                );
                            }else {
                                
                                return "";
                            }
                        }
                    ],
                    [
                        'format' => 'raw',
                        'label' => '',
                        'value' => function($model, $key, $index, $column) use ($permission) {
                            if( $model->role_id == 2 && $permission->kunden_export ) {
                                return Html::a(
                                    '',
                                    Url::to(['/export/download', 'user_id' => $model->id]), 
                                    [
                                        'id'=>'grid-custom-button',
                                        'data-pjax'=>true,
                                        'action'=>Url::to(['/export/download', 'user_id' => $model->id]),
                                        'class'=>'glyphicon glyphicon-download btn-customer',
                                        'data-toggle' =>"tooltip",
                                        'title'=> "Export data to Excel !",
                                    ]
                                );
                            }else {
                                
                                return "";
                            }
                        }
                    ],
                ],
                'tableOptions' => [
                    'id' => 'theDatatable',
                    'class'=>'table table-striped table-bordered table-grid-view table-grid-view-customers'
                ],
            ]); ?>
        <?php Pjax::end(); ?>
        <div class="form-invitation">
            <?php $form = ActiveForm::begin(); ?>
                <?= $form->field($user_invitation, 'send_standard_content_with_email')->checkBox(['label' => '','data-size'=>'small', 'class'=>'bs_switch'
    , 'id'=>'send_standard_content_with_email']) ?>
                <?= $form->field($user_invitation, 'send_message_from_mail'); ?>
                <div class="form-group">
                    <?= Html::submitButton('Send Email',[ 'name'=>'submit', 'value' => 'send_email', 'class' => 'btn btn-primary pull-right']) ?>
                </div>            
            <?php ActiveForm::end(); ?>
        </div>
    <?php else: ?>
        <div>
            <?php $form = ActiveForm::begin([
                    'action' => ['index'],
                    'method' => 'get',
                ]); ?>
                <label>Seach User:</label>
                <?= $form->field($searchModelGlobal, 'globalSearch')->textInput(['maxlength' => true, 'placeholder' => 'Search'])->label(false); ?>
                <div class="form-group">
                    <?= Html::submitButton('Search', ['class' => 'btn btn-primary hide']) ?>
                </div>
            <?php ActiveForm::end(); ?>
            <?php Pjax::begin(); ?> 
                <?php foreach ($users->getModels() as $key => $model ): ?>
                    <table class="table table-striped table-hover table-bordered table-mobile">
                        <tbody>
                          
                            <tr>
                                <td>Email</td>
                                <td><?= $model->email ?></td>
                            </tr>
                            <tr>
                                <td>Betreiber</td>
                                <td><?= $model->Betreiber ?></td>
                            </tr>
                        <tr>
                            <td>PLZ</td>
                            <td><?= $model->AdressePLZ ?></td>
                        </tr>
                        <tr>
                            <td>Ort</td>
                            <td><?= $model->AdresseOrt ?></td>
                        </tr>
                        <tr>
                            <td>Strasse</td>
                            <td><?= $model->AdresseStreat ?></td>
                        </tr>
                        <?php if( $permission->kuden_send_email ): ?>
                            <tr>
                                <td>Send Email</td>
                                <td><?= Html::a('<span class="glyphicon glyphicon-envelope"></span>', ['send-email', 'user_id' => $model->id], ['class' => 'show-form-on-click']) ?></td>
                            </tr>
                        <?php endif ?>
                        <?php if( $permission->kunden_edit ): ?>
                            <tr>
                                <td>Update</td>
                                <td><?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-block btn-primary']) ?></td>
                            </tr>
                        <?php endif ?>   
                        </tbody>
                    </table>
                <?php endforeach ?>
            <?php Pjax::end(); ?>
        </div>
        <div class="pagination">
            <?php
                echo LinkPager::widget([
                'pagination' => $users->pagination,
            ]); ?>
        </div>
    <?php endif ?>
</div>