<?php

namespace backend\modules\coworkers\controllers;
use Yii;
use common\models\Wartungsfirma;
use common\models\search\WartungsfirmaBackendSearch;
use common\models\search\WartungsfirmaBackendSearchGlobal;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * WartungsfirmaController implements the CRUD actions for Wartungsfirma model.
 */
class WartungsfirmaController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->wartungsfirma ) {
        }else {

            #Yii::$app->session->setFlash('success', 'You do not have permission to access Wartungsfirma !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Wartungsfirma models.
     * @return mixed
     */
    public function actionIndex()
    {
        $permission = $this->CoworkerPermission();
        $searchModel = new WartungsfirmaBackendSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $searchModelGlobal = new WartungsfirmaBackendSearchGlobal();
        $wartungsfirmas = $searchModelGlobal->search(Yii::$app->request->queryParams);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'searchModel' => $searchModel,
            'searchModelGlobal' => $searchModelGlobal,
            'wartungsfirmas' => $wartungsfirmas,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single Wartungsfirma model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $permission = $this->CoworkerPermission();
        $desktop = $this->isDesktop();
        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $model,
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Creates a new Wartungsfirma model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {   
        $permission = $this->CoworkerPermission();

        if ( $permission->wartungsfirma_new ) {

            $model = new Wartungsfirma();
            $desktop = $this->isDesktop();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                    'desktop' => $desktop,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create Wartungsfirma !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Updates an existing Wartungsfirma model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->wartungsfirma_edit ) {

            $model = $this->findModel($id);
            $desktop = $this->isDesktop();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                    'desktop' => $desktop,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to update Wartungsfirma !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Deletes an existing Wartungsfirma model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->wartungsfirma_destry ) {

            $this->findModel($id)->delete();
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to delete Wartungsfirma !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    /**
     * Finds the Wartungsfirma model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Wartungsfirma the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Wartungsfirma::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
