<?php

namespace backend\modules\coworkers\controllers;
use Yii;
use common\models\Profintervall;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;
/**
 * ProfintervallController implements the CRUD actions for Profintervall model.
 */
class ProfintervallController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->profintervall ) {
        }else {

           # Yii::$app->session->setFlash('success', 'You do not have permission to access Prufintervall !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Profintervall models.
     * @return mixed
     */
    public function actionIndex()
    {
        $permission = $this->CoworkerPermission();

        $query = Profintervall::find();
        $count = $query->count();

        $pagination = new Pagination([
            'defaultPageSize' => 20,
            'totalCount' => $count
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'pagination' => $pagination,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single Profintervall model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $permission = $this->CoworkerPermission();

        $desktop = $this->isDesktop();
        return $this->render('view', [
            'model' => $this->findModel($id),
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Creates a new Profintervall model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->profintervall_new ) {

            $model = new Profintervall();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create Prüfintervall !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Updates an existing Profintervall model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->profintervall_edit ) {

            $model = $this->findModel($id);

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }else {


            Yii::$app->session->setFlash('success', 'You do not have permission to edit Prüfintervall !');
            return $this->redirect(['/site/coworker']);        
        }
    }

    /**
     * Deletes an existing Profintervall model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->profintervall_destroy ) {

            $this->findModel($id)->delete();
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to delete Prüfintervall !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Finds the Profintervall model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Profintervall the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Profintervall::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
