<?php

namespace backend\modules\coworkers\controllers;
use Yii;
use common\models\Tehnical;
use common\models\User;
use common\models\Evaluierung;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\TehnicReview;
use yii\web\Response;
use dosamigos\google\maps\services\DirectionsClient;
use dosamigos\google\maps\LatLng;
use dosamigos\google\maps\services\DirectionsWayPoint;
use dosamigos\google\maps\services\TravelMode;
use dosamigos\google\maps\overlays\PolylineOptions;
use dosamigos\google\maps\services\DirectionsRenderer;
use dosamigos\google\maps\services\DirectionsService;
use dosamigos\google\maps\overlays\InfoWindow;
use dosamigos\google\maps\overlays\Marker;
use dosamigos\google\maps\Map;
use dosamigos\google\maps\services\DirectionsRequest;
use dosamigos\google\maps\overlays\Polygon;
use dosamigos\google\maps\layers\BicyclingLayer;
use DateTime;
use common\models\GoogleCordinate;
/**
 * TehnicalController implements the CRUD actions for Tehnical model.
 */
class KarteController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->karte ) {
        }else {

           # Yii::$app->session->setFlash('success', 'You do not have permission to access Karte !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $permission = $this->CoworkerPermission();
        $current_user = $this->currentUser();
        $googleMaps = GoogleCordinate::find()->where(['user_id'=> $current_user->id]);
        $model = $this->ensureAnlagen($googleMaps);
        $desktop = $this->isDesktop();

        return $this->render('index', [
            'model' => $model,
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    public function actionCreate()
    {

        $model = new GoogleCordinate();
        $current_user = $this->currentUser();
        $this->deleteAllCordinates($current_user->id);

        if ($model->load(Yii::$app->request->post()) ) {

            if ( $model->anlagen_cordinates ) {

                foreach ($model->anlagen_cordinates as $key => $tehh) {

                    $tehnical = Tehnical::findOne((int)$tehh);

                    $google = new GoogleCordinate();
                    $google->lat =  $tehnical->lat;
                    $google->lng =  $tehnical->lng;
                    $google->tehnical_id =  $tehnical->id;
                    $google->user_id = $current_user->id;
                    $google->save();
                }
            }    

            return $this->redirect(['index']);
        } else {
            return $this->render('tehnical/index', [
                'model' => $model,
            ]);
        }       
    }

    public function deleteAllCordinates($user_id)
    {

        $x = Yii::$app->db->createCommand("
            DELETE FROM google_cordinates 
            WHERE user_id = '$user_id' 

        ")->execute();

    }


    /**
     * Lists all Tehnical models.
     * @return mixed
     */
    public function actionWeek()
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->karteWeek ) {

            $show_google_map = $this->renderGoogleMapWeek();

            return $this->render('week', [
                'show_google_map' => $show_google_map,
            ]);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to access Karte Week !');
            return $this->redirect(['/site/coworker']);             
        }
    }

    public function actionMarked()
    {
        $permission = $this->CoworkerPermission();
        $current_user = $this->currentUser();

        if ( $permission->karteMarked ) {

            $google = GoogleCordinate::find()->where(['user_id' => $current_user->id])->all();
            $show_google_map = $this->renderMarkedGoogleMap($google);

            return $this->render('marked', [
                'show_google_map' => $show_google_map,
            ]);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to access Karte Marked !');
            return $this->redirect(['/site/coworker']); 
        }
    }

    public function actionRemove($id)
    {
        $google = GoogleCordinate::find()->where(['tehnical_id' => $id])->one();
 
        if ($google->delete()) {
            Yii::$app->session->setFlash('success', 'You have successfully Unmarked !');
        }
        return $this->redirect(['index']);
    }

    protected function ensurePDFforatName($model)
    {
        $anlagen = $model->getTehnic()->one();
        $date_for_pdf = str_replace('.', '-', $model->datum);
        $analgen_nr_for_pdf = "AT".$model->tehnic_id;
        $art_for_pdf = str_replace(' ', '_', $model->Art);
        $full_adress_for_pdf = str_replace(' ', '_', $anlagen->AdressePLZ). "_". str_replace(' ', '_', $anlagen->AdresseOrt). "_".str_replace(' ', '_', $anlagen->AdresseStreat). "_".str_replace(' ', '_', $anlagen->Zusatz);
        $full_adress_for_pdf = str_replace('/', '_', $full_adress_for_pdf);

        $prufungsdatum_for_pdf = str_replace('-', '-', $model->Prufungsdatum);

        if ( $prufungsdatum_for_pdf ) {

            return $prufungsdatum_for_pdf. "_". $analgen_nr_for_pdf. "_". $art_for_pdf. "_". $full_adress_for_pdf;
        }else {

            return $date_for_pdf. "_". $analgen_nr_for_pdf. "_". $art_for_pdf. "_". $full_adress_for_pdf;
        }
    }

    protected function renderGoogleMapWeek()
    {


        $office = new LatLng(['lat' => 48.3510193, 'lng' => 16.327288199999998]);
        $start_destination = new LatLng(['lat' => 48.1662537, 'lng' => 16.38633440000001]);
        $anlagen = new LatLng(['lat' => 48.3510193, 'lng' => 16.327288199999998]);        
        $map = new Map([
            'center' => $start_destination,
            'zoom' => 4,
            'width' => '100%'
        ]);

        $tehnicals = $this->nextWeekDates();

        $waypoints = [];

        foreach ($tehnicals as $key => $tehh) {
            
            if ($tehh->lat && $tehh->lng) {
                
                $lat = $tehh->lat;
                $lng = $tehh->lng;
                $destination = new LatLng(['lat' => $lat, 'lng' => $lng]);
                $anlagen = new LatLng(['lat' => $lat, 'lng' => $lng]);
                array_push($waypoints, new DirectionsWayPoint(['location' => $destination]));
                
            }
            
        }

        $directionsRequest = new DirectionsRequest([

            'origin' => $start_destination,
            'destination' => $anlagen,
            'waypoints' => $waypoints,
            'travelMode' => TravelMode::DRIVING
        ]);

        // Lets configure the polyline that renders the direction
        $polylineOptions = new PolylineOptions([
            'strokeColor' => '#FFAA00',
            'draggable' => true
        ]);

        // Now the renderer
        $directionsRenderer = new DirectionsRenderer([
            'map' => $map->getName(),
            'polylineOptions' => $polylineOptions
        ]);

        // Finally the directions service
        $directionsService = new DirectionsService([
            'directionsRenderer' => $directionsRenderer,
            'directionsRequest' => $directionsRequest
        ]);

        // Thats it, append the resulting script to the map
        $map->appendScript($directionsService->getJs());

        // Lets add a marker now
        $office_marker = new Marker([
            'position' => $start_destination,
            'title' => 'My Home',
        ]);


        // Provide a shared InfoWindow to the marker
        $office_marker->attachInfoWindow(
            new InfoWindow([
                'content' => '<p>Home</p>'
            ])
        );

        // Add marker to the map
        $map->addOverlay($office_marker);

        // Now lets write a polygon
        $coords = [
            $start_destination,
            $office,
        ];

        $polygon = new Polygon([
      //      'paths' => $coords
        ]);

        // Add a shared info window
        $polygon->attachInfoWindow(new InfoWindow([
                'content' => '<p>This is my Office</p>'
            ]));

        // Add it now to the map
        $map->addOverlay($polygon);


        // Lets show the BicyclingLayer :)
    //    $bikeLayer = new BicyclingLayer(['map' => $map->getName()]);

        // Append its resulting script
     //   $map->appendScript($bikeLayer->getJs());
        
        return $map->display();      
    }

    protected function nextWeekDates()
    {

        $date_array = [];

        for ($x = 0; $x <= 7; $x++) {

            $today_date = date("d.m.Y", strtotime('-1 year'));
            $date = new DateTime($today_date);
            $date->modify("+$x day");
            $tomorrowDATE = $date->format('d.m.Y');

            array_push($date_array, $tomorrowDATE);
        }


        $tehnicals = Tehnical::find()->where(['in', 'LetzteDate', $date_array])->all();

        return $tehnicals;
    }

    protected function renderMarkedGoogleMap($google)
    {


        $office = new LatLng(['lat' => 48.3510193, 'lng' => 16.327288199999998]);
        $start_destination = new LatLng(['lat' => 48.1662537, 'lng' => 16.38633440000001]);
        $home = new LatLng(['lat' => 48.3510193, 'lng' => 16.327288199999998]);


        $map = new Map([
            'center' => $start_destination,
            'zoom' => 4,
            'width' => '100%'
        ]);

        $waypoints = [];

        foreach ($google as $key => $cordinate) {

            if ($cordinate->lat && $cordinate->lng) {
                
                $lat = $cordinate->lat;
                $lng = $cordinate->lng;
                $destination = new LatLng(['lat' => $lat, 'lng' => $lng]);
                $home = new LatLng(['lat' => $lat, 'lng' => $lng]);
                array_push($waypoints, new DirectionsWayPoint(['location' => $destination]));
                
            }
            
        }

        $directionsRequest = new DirectionsRequest([

            'origin' => $start_destination,
            'destination' => $home,
            'waypoints' => $waypoints,
            'travelMode' => TravelMode::DRIVING
        ]);

        // Lets configure the polyline that renders the direction
        $polylineOptions = new PolylineOptions([
            'strokeColor' => '#FFAA00',
            'draggable' => true
        ]);

        // Now the renderer
        $directionsRenderer = new DirectionsRenderer([
            'map' => $map->getName(),
            'polylineOptions' => $polylineOptions
        ]);

        // Finally the directions service
        $directionsService = new DirectionsService([
            'directionsRenderer' => $directionsRenderer,
            'directionsRequest' => $directionsRequest
        ]);

        // Thats it, append the resulting script to the map
        $map->appendScript($directionsService->getJs());

        // Lets add a marker now
        $office_marker = new Marker([
            'position' => $start_destination,
            'title' => 'My Home',
        ]);


        // Provide a shared InfoWindow to the marker
        $office_marker->attachInfoWindow(
            new InfoWindow([
                'content' => '<p>Home</p>'
            ])
        );

        // Add marker to the map
        $map->addOverlay($office_marker);

        // Now lets write a polygon
        $coords = [
            $start_destination,
            $office,
        ];

        $polygon = new Polygon([
       //     'paths' => $coords
        ]);

        // Add a shared info window
        $polygon->attachInfoWindow(new InfoWindow([
                'content' => '<p>This is my Office</p>'
            ]));

        // Add it now to the map
        $map->addOverlay($polygon);


        // Lets show the BicyclingLayer :)
      //  $bikeLayer = new BicyclingLayer(['map' => $map->getName()]);

        // Append its resulting script
     //   $map->appendScript($bikeLayer->getJs());
        
        return $map->display();      
    }

    protected function ensureAnlagen($googleMaps)
    {
        $anlagen_array = [];

        foreach ($googleMaps->all() as $key => $google) {
            
            $anlagen = Tehnical::findOne($google->tehnical_id);

            array_push($anlagen_array, $anlagen);
        }

        return $anlagen_array;
    }
}
