<?php

namespace backend\modules\coworkers\controllers;
use Yii;
use common\models\GeratMangel;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GeratMangelsController implements the CRUD actions for GeratMangel model.
 */
class GeratMangelsController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->gerat_mangels ) {
        }else {

          #  Yii::$app->session->setFlash('success', 'You do not have permission to access Gerät Mangel !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GeratMangel models.
     * @return mixed
     */
    public function actionIndex()
    {
        $permission = $this->CoworkerPermission();
        $dataProvider = new ActiveDataProvider([
            'query' => GeratMangel::find(),
        ]);
        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single GeratMangel model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $permission = $this->CoworkerPermission();
        $desktop = $this->isDesktop();

        return $this->render('view', [
            'model' => $this->findModel($id),
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Creates a new GeratMangel model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->gerat_mangels_new ) {

            $model = new GeratMangel();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create Gerät Mangel !');
            $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Updates an existing GeratMangel model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {

        $permission = $this->CoworkerPermission();

        if ( $permission->gerat_mangels_edit ) {

            $model = $this->findModel($id);

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to edit Gerät Mangel !');
            $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Deletes an existing GeratMangel model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->gerat_mangels_destroy ) {

            $this->findModel($id)->delete();
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to delete Gerät Mangel !');
            $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Finds the GeratMangel model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return GeratMangel the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GeratMangel::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
