<?php

namespace backend\modules\coworkers\controllers;
use Yii;
use common\models\TehnicReview;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\Magel;
/**
 * TehnicController implements the CRUD actions for Tehnical model.
 */
class FotosController extends BaseController
{

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $this->currentUser()->role_id == "4" ) {
        }else {

           # Yii::$app->session->setFlash('success', 'You do not have permission to access Fotos !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }



    /**
     * Displays a single Tehnical model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    
    public function actionMangelPhoto($id)
    {
        $model = $this->findModel($id);

        return $this->render('mangel-photo', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionAllgemeinerZustand($id)
    {
        $model = $this->findModel($id);

        return $this->render('allgemeiner_zustand', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionWartungsbuch ($id)
    {
        $model = $this->findModel($id);

        return $this->render('wartungsbuch', [
            'model' => $this->findModel($id),
        ]);
    }


    /**
     * Finds the Tehnical model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tehnical the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = TehnicReview::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}