<?php

namespace backend\modules\coworkers\controllers;

	use Yii;
    use Closure;
    use yii\i18n\Formatter;
    use yii\base\InvalidConfigException;
    use yii\helpers\Url;
    use yii\helpers\Html;
    use yii\helpers\Json;
    use yii\helpers\ArrayHelper;
    use yii\widgets\BaseListView;
    use yii\base\Model;
    use common\models\User;
    use \PHPExcel;
    use \PHPExcel_IOFactory;
    use \PHPExcel_Settings;
    use \PHPExcel_Style_Fill;
    use \PHPExcel_Writer_IWriter;
    use \PHPExcel_Worksheet;
    use \PHPExcel_Style_Alignment;
    use \PHPExcel_Style_Border;
    use common\models\Tehnical;
    use common\models\Wartungsfirma;
	use DateTime;
	use DateTimeZone;
/**
 * AdminController implements the CRUD actions for User model.
 */
class ExportBaseController extends BaseController
{

    //////////////////////HEADERINITIALIZE////////////////////////////////////////

    protected function headerInitializeAufzug($sheet)
    {
        $sheet->SetCellValue('A1', 'Betreiber');
        $sheet->SetCellValue('B1', '');
        $sheet->SetCellValue('C1', '');
        $sheet->SetCellValue('D1', '');
        $sheet->SetCellValue('E1', '');
        $sheet->SetCellValue('F1', 'ADRESSE');
        $sheet->SetCellValue('G1', '');
        $sheet->SetCellValue('H1', '');
        $sheet->SetCellValue('I1', '');
        $sheet->SetCellValue('J1', '');
        $sheet->SetCellValue('K1', '');
        $sheet->SetCellValue('L1', '');
        $sheet->SetCellValue('M1', '');
        $sheet->SetCellValue('N1', '');
        $sheet->SetCellValue('O1', '');
        $sheet->SetCellValue('P1', '');
        $sheet->SetCellValue('Q1', '');
        $sheet->SetCellValue('R1', '');
        $sheet->SetCellValue('S1', '');
        $sheet->SetCellValue('T1', '');
        $sheet->SetCellValue('U1', '');
        $sheet->SetCellValue('V1', '');
        $sheet->SetCellValue('W1', '');
        $sheet->SetCellValue('X1', '');
        $sheet->SetCellValue('Y1', '');
        $sheet->SetCellValue('Z1', '');
        $sheet->SetCellValue('AA1', 'Format must be set to: Text or General !');
        $sheet->SetCellValue('AB1', '');
        $sheet->SetCellValue('AC1', '');
        $sheet->SetCellValue('AD1', '');
        $sheet->SetCellValue('AE1', '');
        $sheet->SetCellValue('AF1', '');
        $sheet->SetCellValue('AG1', '');
        $sheet->SetCellValue('AH1', '');
        $sheet->SetCellValue('AI1', '');
        $sheet->SetCellValue('AJ1', 'Google Maps');
        $sheet->SetCellValue('AK1', '');
        $sheet->SetCellValue('AL1', '');
        $sheet->SetCellValue('AM1', '');
        $sheet->SetCellValue('AN1', '');
        $sheet->SetCellValue('AO1', '');
        $sheet->SetCellValue('AP1', '');
        $sheet->SetCellValue('AQ1', 'Format must be set to: Text or General !');
        $sheet->SetCellValue('AR1', '');
        $sheet->SetCellValue('AS1', '');
        $sheet->SetCellValue('AT1', '');
        $sheet->SetCellValue('AU1', '');
        $sheet->SetCellValue('AV1', '');
        $sheet->SetCellValue('AW1', '');
        $sheet->SetCellValue('AX1', '');
        $sheet->SetCellValue('AY1', '');

        $sheet->SetCellValue('A2', 'Betreiber');
        $sheet->SetCellValue('B2', 'User email');
        $sheet->SetCellValue('C2', 'Send e-mail to Company, if new company true or false');
        $sheet->SetCellValue('D2', 'Anlagen Nr');
        $sheet->SetCellValue('E2', 'Fabriks Nr');
        $sheet->SetCellValue('F2', 'PLZ');
        $sheet->SetCellValue('G2', 'ORT');
        $sheet->SetCellValue('H2', 'ADRESSE');
        $sheet->SetCellValue('I2', 'Zusatz');
        $sheet->SetCellValue('J2', 'Hersteller');
        $sheet->SetCellValue('K2', 'Baujahr');
        $sheet->SetCellValue('L2', 'Type');
        $sheet->SetCellValue('M2', 'Anlagentyp');
        $sheet->SetCellValue('N2', 'Antriebsart');
        $sheet->SetCellValue('O2', 'Haltestellen');
        $sheet->SetCellValue('P2', 'Ladestellen');
        $sheet->SetCellValue('Q2', 'Nennlast');
        $sheet->SetCellValue('R2', 'Notruftel');
        $sheet->SetCellValue('S2', 'Schachtart');
        $sheet->SetCellValue('T2', 'Evaluierung');
        $sheet->SetCellValue('U2', 'Wartungsfirma');
        $sheet->SetCellValue('V2', 'Wartungsart');
        $sheet->SetCellValue('W2', 'Betriebskontrollen');
        $sheet->SetCellValue('X2', 'Aufzugswärter');
        $sheet->SetCellValue('Y2', 'Notizen');
        $sheet->SetCellValue('Z2', 'Letzte Regelmäßige Prüfung durch Letze');
        $sheet->SetCellValue('AA2', 'Prüfungsdatum (Letzte Date)');
        $sheet->SetCellValue('AB2', 'Preis WP');
        $sheet->SetCellValue('AC2', 'Objekt Nr.');
        $sheet->SetCellValue('AD2', 'UID NUMMER');
        $sheet->SetCellValue('AE2', 'Fakturenadresse');
        $sheet->SetCellValue('AF2', 'Hausverwalter');
        $sheet->SetCellValue('AG2', 'Hausverwalter Email');
        $sheet->SetCellValue('AH2', 'Kontakt Verwalter');
        $sheet->SetCellValue('AI2', 'Status');
        $sheet->SetCellValue('AJ2', 'longitude');
        $sheet->SetCellValue('AK2', 'longitude');
        $sheet->SetCellValue('AL2', 'Personen');
        $sheet->SetCellValue('AM2', 'Nenngeschwindigkeit');
        $sheet->SetCellValue('AN2', 'Hubhöhe');
        $sheet->SetCellValue('AO2', 'Gesetz');
        $sheet->SetCellValue('AP2', 'Prüfintervall');
        $sheet->SetCellValue('AQ2', 'Evaluierung Fristen');
        $sheet->SetCellValue('AR2', 'Datum der Abnahmeprüfung');
        $sheet->SetCellValue('AS2', 'GeräteNummer');
        $sheet->SetCellValue('AT2', 'KundenNr.');
        $sheet->SetCellValue('AU2', 'Kunden_Rechnungszusatz');
        $sheet->SetCellValue('AV2', 'Kunden_Straße');
        $sheet->SetCellValue('AW2', 'Kunden_PLZ');
        $sheet->SetCellValue('AX2', 'Kunden_Ort');
        $sheet->SetCellValue('AY2', 'Kunden_Referenzzeile');
        $sheet->SetCellValue('AZ2', 'Kunden_Rechnungsemail');
    }

    protected function headerInitializeKFZ($sheet)
    {
        $sheet->SetCellValue('A1', 'Betreiber');
        $sheet->SetCellValue('B1', '');
        $sheet->SetCellValue('C1', '');
        $sheet->SetCellValue('D1', '');
        $sheet->SetCellValue('E1', '');
        $sheet->SetCellValue('F1', 'ADRESSE');
        $sheet->SetCellValue('G1', '');
        $sheet->SetCellValue('H1', '');
        $sheet->SetCellValue('I1', '');
        $sheet->SetCellValue('J1', '');
        $sheet->SetCellValue('K1', '');
        $sheet->SetCellValue('L1', '');
        $sheet->SetCellValue('M1', '');
        $sheet->SetCellValue('N1', '');
        $sheet->SetCellValue('O1', '');
        $sheet->SetCellValue('P1', '');
        $sheet->SetCellValue('Q1', '');
        $sheet->SetCellValue('R1', '');
        $sheet->SetCellValue('S1', '');
        $sheet->SetCellValue('T1', '');
        $sheet->SetCellValue('U1', 'Format must be set to: Text or General !');
        $sheet->SetCellValue('V1', '');
        $sheet->SetCellValue('W1', '');
        $sheet->SetCellValue('X1', '');
        $sheet->SetCellValue('Y1', '');
        $sheet->SetCellValue('Z1', '');
        $sheet->SetCellValue('AA1', '');
        $sheet->SetCellValue('AB1', '');
        $sheet->SetCellValue('AC1', '');
        $sheet->SetCellValue('AD1', '');
        $sheet->SetCellValue('AE1', 'Google Maps');
        $sheet->SetCellValue('AF1', '');
        $sheet->SetCellValue('AG1', '');
        $sheet->SetCellValue('AH1', '');
        $sheet->SetCellValue('AI1', '');
        $sheet->SetCellValue('AJ1', '');
        $sheet->SetCellValue('AK1', '');
        $sheet->SetCellValue('AL1', '');
        $sheet->SetCellValue('AM1', '');
        $sheet->SetCellValue('AN1', '');
        $sheet->SetCellValue('AO1', '');
        $sheet->SetCellValue('AP1', '');
        $sheet->SetCellValue('AQ1', '');
        $sheet->SetCellValue('AR1', '');
        $sheet->SetCellValue('AS1', '');

        $sheet->SetCellValue('A2', 'Betreiber');
        $sheet->SetCellValue('B2', 'User email');
        $sheet->SetCellValue('C2', 'Send e-mail to Company, if new company true or false');
        $sheet->SetCellValue('D2', 'Anlagen Nr');
        $sheet->SetCellValue('E2', 'Fabriks Nr');
        $sheet->SetCellValue('F2', 'PLZ');
        $sheet->SetCellValue('G2', 'ORT');
        $sheet->SetCellValue('H2', 'ADRESSE');
        $sheet->SetCellValue('I2', 'Zusatz');
        $sheet->SetCellValue('J2', 'Hersteller');
        $sheet->SetCellValue('K2', 'Baujahr');
        $sheet->SetCellValue('L2', 'Type');
        $sheet->SetCellValue('M2', 'Prüfgrundlage');
        $sheet->SetCellValue('N2', 'Antriebsart');
        $sheet->SetCellValue('O2', 'Parkeranlagen');
        $sheet->SetCellValue('P2', 'Anzahl Stellplätze');
        $sheet->SetCellValue('Q2', 'Nennlast');
        $sheet->SetCellValue('R2', 'Wartungsfirma');
        $sheet->SetCellValue('S2', 'Notizen');
        $sheet->SetCellValue('T2', 'Letzte Regelmäßige Prüfung durch Letze');
        $sheet->SetCellValue('U2', 'Prüfungsdatum (Letzte Date)');
        $sheet->SetCellValue('V2', 'Prüfintervall');
        $sheet->SetCellValue('W2', 'Preis WP');
        $sheet->SetCellValue('X2', 'Objekt Nr.');
        $sheet->SetCellValue('Y2', 'UID NUMMER');
        $sheet->SetCellValue('Z2', 'Fakturenadresse');
        $sheet->SetCellValue('AA2', 'Hausverwalter');
        $sheet->SetCellValue('AB2', 'Hausverwalter Email');
        $sheet->SetCellValue('AC2', 'Kontakt Verwalter');
        $sheet->SetCellValue('AD2', 'Status');
        $sheet->SetCellValue('AE2', 'longitude');
        $sheet->SetCellValue('AF2', 'longitude');
        $sheet->SetCellValue('AG2', 'GeräteNummer');
        $sheet->SetCellValue('AH2', 'KundenNr.');
        $sheet->SetCellValue('AI2', 'Kunden_Rechnungszusatz');
        $sheet->SetCellValue('AJ2', 'Kunden_Straße');
        $sheet->SetCellValue('AK2', 'Kunden_PLZ');
        $sheet->SetCellValue('AL2', 'Kunden_Ort');
        $sheet->SetCellValue('AM2', 'Kunden_Referenzzeile');
        $sheet->SetCellValue('AN2', 'Kunden_Rechnungsemail');
    }

    protected function headerInitializeArbeitsmittel($sheet)
    {
        $sheet->SetCellValue('A1', 'Betreiber');
        $sheet->SetCellValue('B1', '');
        $sheet->SetCellValue('C1', '');
        $sheet->SetCellValue('D1', '');
        $sheet->SetCellValue('E1', '');
        $sheet->SetCellValue('F1', 'ADRESSE');
        $sheet->SetCellValue('G1', '');
        $sheet->SetCellValue('H1', '');
        $sheet->SetCellValue('I1', '');
        $sheet->SetCellValue('J1', '');
        $sheet->SetCellValue('K1', '');
        $sheet->SetCellValue('L1', '');
        $sheet->SetCellValue('M1', '');
        $sheet->SetCellValue('N1', '');
        $sheet->SetCellValue('O1', '');
        $sheet->SetCellValue('P1', '');
        $sheet->SetCellValue('Q1', '');
        $sheet->SetCellValue('R1', '');
        $sheet->SetCellValue('S1', '');
        $sheet->SetCellValue('T1', 'Format must be set to: Text or General !');
        $sheet->SetCellValue('U1', '');
        $sheet->SetCellValue('V1', '');
        $sheet->SetCellValue('W1', '');
        $sheet->SetCellValue('X1', '');
        $sheet->SetCellValue('Y1', '');
        $sheet->SetCellValue('Z1', '');
        $sheet->SetCellValue('AA1', '');
        $sheet->SetCellValue('AB1', '');
        $sheet->SetCellValue('AC1', '');
        $sheet->SetCellValue('AD1', 'Google Maps');
        $sheet->SetCellValue('AE1', '');
        $sheet->SetCellValue('AF1', '');
        $sheet->SetCellValue('AG1', '');
        $sheet->SetCellValue('AH1', '');
        $sheet->SetCellValue('AI1', '');
        $sheet->SetCellValue('AJ1', '');
        $sheet->SetCellValue('AK1', '');
        $sheet->SetCellValue('AL1', '');
        $sheet->SetCellValue('AM1', '');
        $sheet->SetCellValue('AN1', '');
        $sheet->SetCellValue('AO1', '');
        $sheet->SetCellValue('AP1', '');
        $sheet->SetCellValue('AQ1', '');
        $sheet->SetCellValue('AR1', '');
        $sheet->SetCellValue('AS1', '');

        $sheet->SetCellValue('A2', 'Betreiber');
        $sheet->SetCellValue('B2', 'User email');
        $sheet->SetCellValue('C2', 'Send e-mail to Company, if new company true or false');
        $sheet->SetCellValue('D2', 'Anlagen Nr');
        $sheet->SetCellValue('E2', 'Fabriks Nr');
        $sheet->SetCellValue('F2', 'PLZ');
        $sheet->SetCellValue('G2', 'ORT');
        $sheet->SetCellValue('H2', 'ADRESSE');
        $sheet->SetCellValue('I2', 'Zusatz');
        $sheet->SetCellValue('J2', 'Hersteller');
        $sheet->SetCellValue('K2', 'Baujahr');
        $sheet->SetCellValue('L2', 'Type');
        $sheet->SetCellValue('M2', 'Type 2');
        $sheet->SetCellValue('N2', 'Prüfgrundlage');
        $sheet->SetCellValue('O2', 'Antriebsart');
        $sheet->SetCellValue('P2', 'Durchfahrtslichte in m');
        $sheet->SetCellValue('Q2', 'Wartungsfirma');
        $sheet->SetCellValue('R2', 'Notizen');
        $sheet->SetCellValue('S2', 'Letzte Regelmäßige Prüfung durch Letze');
        $sheet->SetCellValue('T2', 'Prüfungsdatum (Letzte Date)');      
        $sheet->SetCellValue('U2', 'Prüfintervall');
        $sheet->SetCellValue('V2', 'Preis WP');
        $sheet->SetCellValue('W2', 'Objekt Nr.');
        $sheet->SetCellValue('X2', 'UID NUMMER');
        $sheet->SetCellValue('Y2', 'Fakturenadresse');
        $sheet->SetCellValue('Z2', 'Hausverwalter');
        $sheet->SetCellValue('AA2', 'Hausverwalter Email');
        $sheet->SetCellValue('AB2', 'Kontakt Verwalter');
        $sheet->SetCellValue('AC2', 'Status');
        $sheet->SetCellValue('AD2', 'longitude');
        $sheet->SetCellValue('AE2', 'longitude');
        $sheet->SetCellValue('AF2', 'GeräteNummer');
        $sheet->SetCellValue('AG2', 'KundenNr.');
        $sheet->SetCellValue('AH2', 'Kunden_Rechnungszusatz');
        $sheet->SetCellValue('AI2', 'Kunden_Straße');
        $sheet->SetCellValue('AJ2', 'Kunden_PLZ');
        $sheet->SetCellValue('AK2', 'Kunden_Ort');
        $sheet->SetCellValue('AL2', 'Kunden_Referenzzeile');
        $sheet->SetCellValue('AM2', 'Kunden_Rechnungsemail');
    }

    protected function headerInitializeSpiel($sheet)
    {
        $sheet->SetCellValue('A1', 'Betreiber');
        $sheet->SetCellValue('B1', '');
        $sheet->SetCellValue('C1', '');
        $sheet->SetCellValue('D1', '');
        $sheet->SetCellValue('E1', '');
        $sheet->SetCellValue('F1', 'ADRESSE');
        $sheet->SetCellValue('G1', '');
        $sheet->SetCellValue('H1', '');
        $sheet->SetCellValue('I1', '');
        $sheet->SetCellValue('J1', '');
        $sheet->SetCellValue('K1', '');
        $sheet->SetCellValue('L1', '');
        $sheet->SetCellValue('M1', '');
        $sheet->SetCellValue('N1', '');
        $sheet->SetCellValue('O1', '');
        $sheet->SetCellValue('P1', '');
        $sheet->SetCellValue('Q1', '');
        $sheet->SetCellValue('R1', 'Format must be set to: Text or General !');
        $sheet->SetCellValue('S1', '');
        $sheet->SetCellValue('T1', '');
        $sheet->SetCellValue('U1', '');
        $sheet->SetCellValue('V1', '');
        $sheet->SetCellValue('W1', '');
        $sheet->SetCellValue('X1', '');
        $sheet->SetCellValue('Y1', '');
        $sheet->SetCellValue('Z1', '');
        $sheet->SetCellValue('AA1', '');
        $sheet->SetCellValue('AB1', 'Google Maps');
        $sheet->SetCellValue('AC1', '');
        $sheet->SetCellValue('AD1', '');
        $sheet->SetCellValue('AE1', '');
        $sheet->SetCellValue('AF1', '');
        $sheet->SetCellValue('AG1', '');
        $sheet->SetCellValue('AH1', '');
        $sheet->SetCellValue('AI1', '');
        $sheet->SetCellValue('AJ1', '');
        $sheet->SetCellValue('AK1', '');
        $sheet->SetCellValue('AL1', '');
        $sheet->SetCellValue('AM1', '');
        $sheet->SetCellValue('AN1', '');
        $sheet->SetCellValue('AO1', '');
        $sheet->SetCellValue('AP1', '');
        $sheet->SetCellValue('AQ1', '');
        $sheet->SetCellValue('AR1', '');
        $sheet->SetCellValue('AS1', '');

        $sheet->SetCellValue('A2', 'Betreiber');
        $sheet->SetCellValue('B2', 'User email');
        $sheet->SetCellValue('C2', 'Send e-mail to Company, if new company true or false');
        $sheet->SetCellValue('D2', 'Anlagen Nr');
        $sheet->SetCellValue('E2', 'Fabriks Nr');
        $sheet->SetCellValue('F2', 'PLZ');
        $sheet->SetCellValue('G2', 'ORT');
        $sheet->SetCellValue('H2', 'ADRESSE');
        $sheet->SetCellValue('I2', 'Zusatz');
        $sheet->SetCellValue('J2', 'Hersteller');
        $sheet->SetCellValue('K2', 'Baujahr');
        $sheet->SetCellValue('L2', 'Inspektionsobjekt');
        $sheet->SetCellValue('M2', 'Norm');
        $sheet->SetCellValue('N2', 'Prüfgrundlage');
        $sheet->SetCellValue('O2', 'Wartungsfirma');
        $sheet->SetCellValue('P2', 'Notizen');
        $sheet->SetCellValue('Q2', 'Letzte Regelmäßige Prüfung durch Letze');
        $sheet->SetCellValue('R2', 'Prüfungsdatum (Letzte Date)');
        $sheet->SetCellValue('S2', 'Prüfintervall');
        $sheet->SetCellValue('T2', 'Preis WP');
        $sheet->SetCellValue('U2', 'Objekt Nr.');
        $sheet->SetCellValue('V2', 'UID NUMMER');
        $sheet->SetCellValue('W2', 'Fakturenadresse');
        $sheet->SetCellValue('X2', 'Hausverwalter');
        $sheet->SetCellValue('Y2', 'Hausverwalter Email');
        $sheet->SetCellValue('Z2', 'Kontakt Verwalter');
        $sheet->SetCellValue('AA2', 'Status');
        $sheet->SetCellValue('AB2', 'longitude');
        $sheet->SetCellValue('AC2', 'longitude');
        $sheet->SetCellValue('AD2', 'GeräteNummer');
        $sheet->SetCellValue('AE2', 'KundenNr.');
        $sheet->SetCellValue('AF2', 'Kunden_Rechnungszusatz');
        $sheet->SetCellValue('AG2', 'Kunden_Straße');
        $sheet->SetCellValue('AH2', 'Kunden_PLZ');
        $sheet->SetCellValue('AI2', 'Kunden_Ort');
        $sheet->SetCellValue('AJ2', 'Kunden_Referenzzeile');
        $sheet->SetCellValue('AK2', 'Kunden_Rechnungsemail');
    }

    //////////////////////////////////////////////////////////////////////////////

    //////////////////////////////DATA INITIALIZE/////////////////////////////////


    protected function dataInitializeAufzug($sheet, $tehnicals)
    {
        foreach ($tehnicals as $key => $tehnic) {

            $row = 2 + $key + 1;
            $user = $tehnic->getUser()->one();
            $sent_to_email = $this->sendMailToCustomer($user);
            $ensure_evaluierungFristen_excel = $this->ensure_evaluierungFristen_excel($tehnic->evaluierungFristen);

            $sheet->SetCellValue( 'A'.$row, $user->Betreiber );
            $sheet->SetCellValue( 'B'.$row, $user->email );
            $sheet->SetCellValue( 'C'.$row, $sent_to_email );
            $sheet->SetCellValue( 'D'.$row, 'AT'.$tehnic->id  );
            $sheet->SetCellValue( 'E'.$row, $tehnic->FabriksNr  ); 
            $sheet->SetCellValue( 'F'.$row, $tehnic->AdressePLZ  ); 
            $sheet->SetCellValue( 'G'.$row, $tehnic->AdresseOrt  ); 
            $sheet->SetCellValue( 'H'.$row, $tehnic->AdresseStreat  ); 
            $sheet->SetCellValue( 'I'.$row, $tehnic->Zusatz  ); 
            $sheet->SetCellValue( 'J'.$row, $tehnic->Hersteller  ); 
            $sheet->SetCellValue( 'K'.$row, $tehnic->Baujahr  ); 
            $sheet->SetCellValue( 'L'.$row, $tehnic->Type  ); 
            $sheet->SetCellValue( 'M'.$row, $tehnic->Anlagentyp  ); 
            $sheet->SetCellValue( 'N'.$row, $tehnic->Antriebsart  ); 
            $sheet->SetCellValue( 'O'.$row, $tehnic->Haltestellen  ); 
            $sheet->SetCellValue( 'P'.$row, $tehnic->Ladestellen  ); 
            $sheet->SetCellValue( 'Q'.$row, $tehnic->Nennlast  ); 
            $sheet->SetCellValue( 'R'.$row, $tehnic->Notruftel  ); 
            $sheet->SetCellValue( 'S'.$row, $tehnic->Schachtart  ); 
            $sheet->SetCellValue( 'T'.$row, $tehnic->evaluierungName ); 
            $sheet->SetCellValue( 'U'.$row, $this->renderFirmaName( $tehnic->fabric_id )); 
            $sheet->SetCellValue( 'V'.$row, $tehnic->Wartungsart  ); 
            $sheet->SetCellValue( 'W'.$row, $tehnic->Betriebskontrollen  ); 
            $sheet->SetCellValue( 'X'.$row, $this->renderAufzugswarter($tehnic)  ); 
            $sheet->SetCellValue( 'Y'.$row, $tehnic->Notizen  ); 
            $sheet->SetCellValue( 'Z'.$row, $tehnic->Letzte  ); 
            $sheet->SetCellValue( 'AA'.$row, $tehnic->LetzteDate );
            $sheet->SetCellValue( 'AB'.$row, $tehnic->PreisWP );
            $sheet->SetCellValue( 'AC'.$row, $tehnic->ObjektNr );
            $sheet->SetCellValue( 'AD'.$row, $tehnic->UIDNUMMER  );
            $sheet->SetCellValue( 'AE'.$row, $tehnic->Fakturenadresse  ); 
            $sheet->SetCellValue( 'AF'.$row, $tehnic->Hausverwalter  ); 
            $sheet->SetCellValue( 'AG'.$row, $tehnic->HausverwalterEmail  ); 
            $sheet->SetCellValue( 'AH'.$row, $tehnic->KontaktVerwalter  ); 
            $sheet->SetCellValue( 'AI'.$row, $tehnic->status  ); 
            $sheet->SetCellValue( 'AJ'.$row, $tehnic->lat  ); 
            $sheet->SetCellValue( 'AK'.$row, $tehnic->lng  ); 
            $sheet->SetCellValue( 'AL'.$row, $tehnic->Personen  ); 
            $sheet->SetCellValue( 'AM'.$row,  $tehnic->Nenngeschwindigkeit );
            $sheet->SetCellValue( 'AN'.$row,  $tehnic->Hubhohe );
            $sheet->SetCellValue( 'AO'.$row,  $tehnic->Gesetzt );
            $sheet->SetCellValue( 'AP'.$row,  $tehnic->Profintervall );
            $sheet->SetCellValue( 'AQ'.$row,  $ensure_evaluierungFristen_excel );
            $sheet->SetCellValue( 'AR'.$row,  $tehnic->DatumderAbnahmeprufung );
            $sheet->SetCellValue( 'AS'.$row,  $tehnic->GerateNummer );
            $sheet->SetCellValue( 'AT'.$row,  $tehnic->KundenNr );
            $sheet->SetCellValue( 'AU'.$row,  $tehnic->Kunden_Rechnungszusatz );
            $sheet->SetCellValue( 'AV'.$row,  $tehnic->Kunden_Straße );
            $sheet->SetCellValue( 'AW'.$row,  $tehnic->Kunden_PLZ );
            $sheet->SetCellValue( 'AX'.$row,  $tehnic->Kunden_Ort );
            $sheet->SetCellValue( 'AY'.$row,  $tehnic->Kunden_Referenzzeile );
            $sheet->SetCellValue( 'AZ'.$row,  $tehnic->Kunden_Rechnungsemail );
        }
    }

    protected function dataInitializeKFZ($sheet, $tehnicals)
    {
        foreach ($tehnicals as $key => $tehnic) {

            $row = 2 + $key + 1;
            $user = $tehnic->getUser()->one();
            $sent_to_email = $this->sendMailToCustomer($user);
            $ensure_evaluierungFristen_excel = $this->ensure_evaluierungFristen_excel($tehnic->evaluierungFristen);

            $sheet->SetCellValue( 'A'.$row, $user->Betreiber );
            $sheet->SetCellValue( 'B'.$row, $user->email );
            $sheet->SetCellValue( 'C'.$row, $sent_to_email );
            $sheet->SetCellValue( 'D'.$row, 'AT'.$tehnic->id  );
            $sheet->SetCellValue( 'E'.$row, $tehnic->FabriksNr  ); 
            $sheet->SetCellValue( 'F'.$row, $tehnic->AdressePLZ  ); 
            $sheet->SetCellValue( 'G'.$row, $tehnic->AdresseOrt  ); 
            $sheet->SetCellValue( 'H'.$row, $tehnic->AdresseStreat  ); 
            $sheet->SetCellValue( 'I'.$row, $tehnic->Zusatz  ); 
            $sheet->SetCellValue( 'J'.$row, $tehnic->Hersteller  ); 
            $sheet->SetCellValue( 'K'.$row, $tehnic->Baujahr  ); 
            $sheet->SetCellValue( 'L'.$row, $tehnic->Type  ); 
            $sheet->SetCellValue( 'M'.$row, $tehnic->Prufgrundlage  ); 
            $sheet->SetCellValue( 'N'.$row, $tehnic->Antriebsart  ); 
            $sheet->SetCellValue( 'O'.$row, $tehnic->Parkeranagen  ); 
            $sheet->SetCellValue( 'P'.$row, $tehnic->AnzahltStellplatze  ); 
            $sheet->SetCellValue( 'Q'.$row, $tehnic->Nennlast  ); 
            $sheet->SetCellValue( 'R'.$row, $this->renderFirmaName( $tehnic->fabric_id )  );
            $sheet->SetCellValue( 'S'.$row, $tehnic->Notizen  );
            $sheet->SetCellValue( 'T'.$row, $tehnic->Letzte  );
            $sheet->SetCellValue( 'U'.$row, $tehnic->LetzteDate );
            $sheet->SetCellValue( 'V'.$row, $tehnic->Profintervall  );
            $sheet->SetCellValue( 'W'.$row, $tehnic->PreisWP );
            $sheet->SetCellValue( 'X'.$row, $tehnic->ObjektNr );
            $sheet->SetCellValue( 'Y'.$row, $tehnic->UIDNUMMER  );
            $sheet->SetCellValue( 'Z'.$row, $tehnic->Fakturenadresse  );    
            $sheet->SetCellValue( 'AA'.$row, $tehnic->Hausverwalter  ); 
            $sheet->SetCellValue( 'AB'.$row, $tehnic->HausverwalterEmail  ); 
            $sheet->SetCellValue( 'AC'.$row, $tehnic->KontaktVerwalter  ); 
            $sheet->SetCellValue( 'AD'.$row, $tehnic->status  );
            $sheet->SetCellValue( 'AE'.$row, $tehnic->lat  ); 
            $sheet->SetCellValue( 'AF'.$row, $tehnic->lng  );
            $sheet->SetCellValue( 'AG'.$row,  $tehnic->GerateNummer );
            $sheet->SetCellValue( 'AH'.$row,  $tehnic->KundenNr );
            $sheet->SetCellValue( 'AI'.$row,  $tehnic->Kunden_Rechnungszusatz );
            $sheet->SetCellValue( 'AJ'.$row,  $tehnic->Kunden_Straße );
            $sheet->SetCellValue( 'AK'.$row,  $tehnic->Kunden_PLZ );
            $sheet->SetCellValue( 'AL'.$row,  $tehnic->Kunden_Ort );
            $sheet->SetCellValue( 'AM'.$row,  $tehnic->Kunden_Referenzzeile );
            $sheet->SetCellValue( 'AN'.$row,  $tehnic->Kunden_Rechnungsemail );
        }
    }

    protected function dataInitializeArbeitsmittel($sheet, $tehnicals)
    {
        foreach ($tehnicals as $key => $tehnic) {

            $row = 2 + $key + 1;
            $user = $tehnic->getUser()->one();
            $sent_to_email = $this->sendMailToCustomer($user);
            $ensure_evaluierungFristen_excel = $this->ensure_evaluierungFristen_excel($tehnic->evaluierungFristen);

            $sheet->SetCellValue( 'A'.$row, $user->Betreiber );
            $sheet->SetCellValue( 'B'.$row, $user->email );
            $sheet->SetCellValue( 'C'.$row, $sent_to_email );
            $sheet->SetCellValue( 'D'.$row, 'AT'.$tehnic->id  );
            $sheet->SetCellValue( 'E'.$row, $tehnic->FabriksNr  ); 
            $sheet->SetCellValue( 'F'.$row, $tehnic->AdressePLZ  ); 
            $sheet->SetCellValue( 'G'.$row, $tehnic->AdresseOrt  ); 
            $sheet->SetCellValue( 'H'.$row, $tehnic->AdresseStreat  ); 
            $sheet->SetCellValue( 'I'.$row, $tehnic->Zusatz  ); 
            $sheet->SetCellValue( 'J'.$row, $tehnic->Hersteller  ); 
            $sheet->SetCellValue( 'K'.$row, $tehnic->Baujahr  ); 
            $sheet->SetCellValue( 'L'.$row, $tehnic->Type  );
            $sheet->SetCellValue( 'M'.$row, $tehnic->type2  );
            $sheet->SetCellValue( 'N'.$row, $tehnic->Prufgrundlage  );
            $sheet->SetCellValue( 'O'.$row, $tehnic->Antriebsart  );
            $sheet->SetCellValue( 'P'.$row, $tehnic->Durchfahrtslichte_in_m  );
            $sheet->SetCellValue( 'Q'.$row, $this->renderFirmaName( $tehnic->fabric_id )  );
            $sheet->SetCellValue( 'R'.$row, $tehnic->Notizen  );
            $sheet->SetCellValue( 'S'.$row, $tehnic->Letzte  ); 
            $sheet->SetCellValue( 'T'.$row, $tehnic->LetzteDate );
            $sheet->SetCellValue( 'U'.$row, $tehnic->Profintervall  );
            $sheet->SetCellValue( 'V'.$row, $tehnic->PreisWP );
            $sheet->SetCellValue( 'W'.$row, $tehnic->ObjektNr );
            $sheet->SetCellValue( 'X'.$row, $tehnic->UIDNUMMER  );
            $sheet->SetCellValue( 'Y'.$row, $tehnic->Fakturenadresse  );    
            $sheet->SetCellValue( 'Z'.$row, $tehnic->Hausverwalter  ); 
            $sheet->SetCellValue( 'AA'.$row, $tehnic->HausverwalterEmail  ); 
            $sheet->SetCellValue( 'AB'.$row, $tehnic->KontaktVerwalter  ); 
            $sheet->SetCellValue( 'AC'.$row, $tehnic->status  );
            $sheet->SetCellValue( 'AD'.$row, $tehnic->lat  ); 
            $sheet->SetCellValue( 'AE'.$row, $tehnic->lng  );
            $sheet->SetCellValue( 'AF'.$row,  $tehnic->GerateNummer );
            $sheet->SetCellValue( 'AG'.$row,  $tehnic->KundenNr );
            $sheet->SetCellValue( 'AH'.$row,  $tehnic->Kunden_Rechnungszusatz );
            $sheet->SetCellValue( 'AI'.$row,  $tehnic->Kunden_Straße );
            $sheet->SetCellValue( 'AJ'.$row,  $tehnic->Kunden_PLZ );
            $sheet->SetCellValue( 'AK'.$row,  $tehnic->Kunden_Ort );
            $sheet->SetCellValue( 'AL'.$row,  $tehnic->Kunden_Referenzzeile );
            $sheet->SetCellValue( 'AM'.$row,  $tehnic->Kunden_Rechnungsemail );
        }
    }

    protected function dataInitializeSpiel($sheet, $tehnicals)
    {
        foreach ($tehnicals as $key => $tehnic) {

            $row = 2 + $key + 1;
            $user = $tehnic->getUser()->one();
            $sent_to_email = $this->sendMailToCustomer($user);
            $ensure_evaluierungFristen_excel = $this->ensure_evaluierungFristen_excel($tehnic->evaluierungFristen);

            $sheet->SetCellValue( 'A'.$row, $user->Betreiber );
            $sheet->SetCellValue( 'B'.$row, $user->email );
            $sheet->SetCellValue( 'C'.$row, $sent_to_email );
            $sheet->SetCellValue( 'D'.$row, 'AT'.$tehnic->id  );
            $sheet->SetCellValue( 'E'.$row, $tehnic->FabriksNr  ); 
            $sheet->SetCellValue( 'F'.$row, $tehnic->AdressePLZ  ); 
            $sheet->SetCellValue( 'G'.$row, $tehnic->AdresseOrt  ); 
            $sheet->SetCellValue( 'H'.$row, $tehnic->AdresseStreat  ); 
            $sheet->SetCellValue( 'I'.$row, $tehnic->Zusatz  ); 
            $sheet->SetCellValue( 'J'.$row, $tehnic->Hersteller  ); 
            $sheet->SetCellValue( 'K'.$row, $tehnic->Baujahr  );
            $sheet->SetCellValue( 'L'.$row, $tehnic->Inspetkionsobjekt  );
            $sheet->SetCellValue( 'M'.$row, $tehnic->Norm  );
            $sheet->SetCellValue( 'N'.$row, $tehnic->Prufgrundlage  );
            $sheet->SetCellValue( 'O'.$row, $this->renderFirmaName( $tehnic->fabric_id )  );
            $sheet->SetCellValue( 'P'.$row, $tehnic->Notizen  );
            $sheet->SetCellValue( 'Q'.$row, $tehnic->Letzte  ); 
            $sheet->SetCellValue( 'R'.$row, $tehnic->LetzteDate );
            $sheet->SetCellValue( 'S'.$row, $tehnic->Profintervall  );
            $sheet->SetCellValue( 'T'.$row, $tehnic->PreisWP );
            $sheet->SetCellValue( 'U'.$row, $tehnic->ObjektNr );
            $sheet->SetCellValue( 'V'.$row, $tehnic->UIDNUMMER  );
            $sheet->SetCellValue( 'W'.$row, $tehnic->Fakturenadresse  );    
            $sheet->SetCellValue( 'X'.$row, $tehnic->Hausverwalter  ); 
            $sheet->SetCellValue( 'Y'.$row, $tehnic->HausverwalterEmail  ); 
            $sheet->SetCellValue( 'Z'.$row, $tehnic->KontaktVerwalter  ); 
            $sheet->SetCellValue( 'AA'.$row, $tehnic->status  );
            $sheet->SetCellValue( 'AB'.$row, $tehnic->lat  ); 
            $sheet->SetCellValue( 'AC'.$row, $tehnic->lng  );
            $sheet->SetCellValue( 'AD'.$row,  $tehnic->GerateNummer );
            $sheet->SetCellValue( 'AE'.$row,  $tehnic->KundenNr );
            $sheet->SetCellValue( 'AF'.$row,  $tehnic->Kunden_Rechnungszusatz );
            $sheet->SetCellValue( 'AG'.$row,  $tehnic->Kunden_Straße );
            $sheet->SetCellValue( 'AH'.$row,  $tehnic->Kunden_PLZ );
            $sheet->SetCellValue( 'AI'.$row,  $tehnic->Kunden_Ort );
            $sheet->SetCellValue( 'AJ'.$row,  $tehnic->Kunden_Referenzzeile );
            $sheet->SetCellValue( 'AK'.$row,  $tehnic->Kunden_Rechnungsemail );
        }
    }

    ///////////////////////////////////////////////////////////////////////////

    //////////////////////////////EXCEL STYLESHEET///////////////////////////////////

    protected function headerStyleAufzug( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color )
    {
        $sheet->getStyle('A')->applyFromArray($align_text);
        $sheet->getStyle('B')->applyFromArray($align_text);
        $sheet->getStyle('C')->applyFromArray($align_text);
        $sheet->getStyle('D')->applyFromArray($align_text);
        $sheet->getStyle('E')->applyFromArray($align_text);
        $sheet->getStyle('F')->applyFromArray($align_text);
        $sheet->getStyle('G')->applyFromArray($align_text);
        $sheet->getStyle('H')->applyFromArray($align_text);
        $sheet->getStyle('I')->applyFromArray($align_text);
        $sheet->getStyle('J')->applyFromArray($align_text);
        $sheet->getStyle('K')->applyFromArray($align_text);
        $sheet->getStyle('L')->applyFromArray($align_text);
        $sheet->getStyle('M')->applyFromArray($align_text);
        $sheet->getStyle('N')->applyFromArray($align_text);
        $sheet->getStyle('O')->applyFromArray($align_text);
        $sheet->getStyle('P')->applyFromArray($align_text);
        $sheet->getStyle('Q')->applyFromArray($align_text);
        $sheet->getStyle('R')->applyFromArray($align_text);
        $sheet->getStyle('S')->applyFromArray($align_text);
        $sheet->getStyle('T')->applyFromArray($align_text);
        $sheet->getStyle('U')->applyFromArray($align_text);
        $sheet->getStyle('V')->applyFromArray($align_text);
        $sheet->getStyle('W')->applyFromArray($align_text);
        $sheet->getStyle('X')->applyFromArray($align_text);
        $sheet->getStyle('Y')->applyFromArray($align_text);
        $sheet->getStyle('Z')->applyFromArray($align_text);
        $sheet->getStyle('AA')->applyFromArray($align_text);
        $sheet->getStyle('AB')->applyFromArray($align_text);
        $sheet->getStyle('AC')->applyFromArray($align_text);
        $sheet->getStyle('AD')->applyFromArray($align_text);
        $sheet->getStyle('AE')->applyFromArray($align_text);
        $sheet->getStyle('AF')->applyFromArray($align_text);
        $sheet->getStyle('AG')->applyFromArray($align_text);
        $sheet->getStyle('AH')->applyFromArray($align_text);
        $sheet->getStyle('AI')->applyFromArray($align_text);
        $sheet->getStyle('AJ')->applyFromArray($align_text);
        $sheet->getStyle('AK')->applyFromArray($align_text);
        $sheet->getStyle('AL')->applyFromArray($align_text);
        $sheet->getStyle('AM')->applyFromArray($align_text);
        $sheet->getStyle('AN')->applyFromArray($align_text);
        $sheet->getStyle('AO')->applyFromArray($align_text);
        $sheet->getStyle('AP')->applyFromArray($align_text);
        $sheet->getStyle('AQ')->applyFromArray($align_text);
        $sheet->getStyle('AR')->applyFromArray($align_text);
        $sheet->getStyle('AS')->applyFromArray($align_text);
        $sheet->getStyle('AT')->applyFromArray($align_text);
        $sheet->getStyle('AU')->applyFromArray($align_text);
        $sheet->getStyle('AV')->applyFromArray($align_text);
        $sheet->getStyle('AW')->applyFromArray($align_text);
        $sheet->getStyle('AX')->applyFromArray($align_text);
        $sheet->getStyle('AY')->applyFromArray($align_text);

        $sheet->getStyle('A1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('A1'), 'B1:E1');        /// allow us to copy style from one field to another
        $sheet->getStyle('A2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('A2'), 'B2:E2');

        $sheet->getStyle('F1')->applyFromArray($styleHeaderCustomer_F_T);
        $sheet->duplicateStyle($sheet->getStyle('F1'), 'F1:T1');
        $sheet->getStyle('F2')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->duplicateStyle($sheet->getStyle('F2'), 'F2:T2');

        $sheet->getStyle('U1')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('U1'), 'U1:W1');
        $sheet->getStyle('U2')->applyFromArray($styleHeaderFirma2);
        $sheet->duplicateStyle($sheet->getStyle('U2'), 'U2:W2');

        $sheet->getStyle('Y1')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('Y1'), 'Y1:AA1');
        $sheet->getStyle('Y2')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('Y2'), 'Y2:AA2');

        $sheet->getStyle('AB1')->applyFromArray($styleHeaderPreisWP);
        $sheet->getStyle('AB2')->applyFromArray($styleHeaderPreisWP);

        $sheet->getStyle('AC1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('AC1'), 'AC1:AP1');
        $sheet->getStyle('AC2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('AC2'), 'AC2:AP2');

        $sheet->getStyle('AJ1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('AJ1'), 'AJ1:AK1');

        $sheet->getStyle('AQ1')->applyFromArray($styleHeaderDate);
        $sheet->duplicateStyle($sheet->getStyle('AQ1'), 'AQ1:AR1');
        $sheet->getStyle('AQ2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('AQ2'), 'AQ2:AR2');

        $sheet->getStyle('AS1')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->getStyle('AS2')->applyFromArray($styleHeaderCustomer_F_T2);

        $sheet->getStyle('AT1')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AT1'), 'AT1:AZ1');
        $sheet->getStyle('AT2')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AT2'), 'AT2:AZ2');


        $sheet->getStyle('C2')->getAlignment()->setWrapText(true); // text in new line
    }

    protected function headerStyleKFZ( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color )
    {
        $sheet->getStyle('A')->applyFromArray($align_text);
        $sheet->getStyle('B')->applyFromArray($align_text);
        $sheet->getStyle('C')->applyFromArray($align_text);
        $sheet->getStyle('D')->applyFromArray($align_text);
        $sheet->getStyle('E')->applyFromArray($align_text);
        $sheet->getStyle('F')->applyFromArray($align_text);
        $sheet->getStyle('G')->applyFromArray($align_text);
        $sheet->getStyle('H')->applyFromArray($align_text);
        $sheet->getStyle('I')->applyFromArray($align_text);
        $sheet->getStyle('J')->applyFromArray($align_text);
        $sheet->getStyle('K')->applyFromArray($align_text);
        $sheet->getStyle('L')->applyFromArray($align_text);
        $sheet->getStyle('M')->applyFromArray($align_text);
        $sheet->getStyle('N')->applyFromArray($align_text);
        $sheet->getStyle('O')->applyFromArray($align_text);
        $sheet->getStyle('P')->applyFromArray($align_text);
        $sheet->getStyle('Q')->applyFromArray($align_text);
        $sheet->getStyle('R')->applyFromArray($align_text);
        $sheet->getStyle('S')->applyFromArray($align_text);
        $sheet->getStyle('T')->applyFromArray($align_text);
        $sheet->getStyle('U')->applyFromArray($align_text);
        $sheet->getStyle('V')->applyFromArray($align_text);
        $sheet->getStyle('W')->applyFromArray($align_text);
        $sheet->getStyle('X')->applyFromArray($align_text);
        $sheet->getStyle('Y')->applyFromArray($align_text);
        $sheet->getStyle('Z')->applyFromArray($align_text);
        $sheet->getStyle('AA')->applyFromArray($align_text);
        $sheet->getStyle('AB')->applyFromArray($align_text);
        $sheet->getStyle('AC')->applyFromArray($align_text);
        $sheet->getStyle('AD')->applyFromArray($align_text);
        $sheet->getStyle('AE')->applyFromArray($align_text);
        $sheet->getStyle('AF')->applyFromArray($align_text);
        $sheet->getStyle('AG')->applyFromArray($align_text);
        $sheet->getStyle('AH')->applyFromArray($align_text);
        $sheet->getStyle('AI')->applyFromArray($align_text);
        $sheet->getStyle('AJ')->applyFromArray($align_text);
        $sheet->getStyle('AK')->applyFromArray($align_text);
        $sheet->getStyle('AL')->applyFromArray($align_text);
        $sheet->getStyle('AM')->applyFromArray($align_text);
        $sheet->getStyle('AN')->applyFromArray($align_text);
        $sheet->getStyle('AO')->applyFromArray($align_text);
        $sheet->getStyle('AP')->applyFromArray($align_text);
        $sheet->getStyle('AQ')->applyFromArray($align_text);
        $sheet->getStyle('AR')->applyFromArray($align_text);
        $sheet->getStyle('AS')->applyFromArray($align_text);
        $sheet->getStyle('AT')->applyFromArray($align_text);
        $sheet->getStyle('AU')->applyFromArray($align_text);
        $sheet->getStyle('AV')->applyFromArray($align_text);
        $sheet->getStyle('AW')->applyFromArray($align_text);
        $sheet->getStyle('AX')->applyFromArray($align_text);
        $sheet->getStyle('AY')->applyFromArray($align_text);

        $sheet->getStyle('A1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('A1'), 'B1:E1');        /// allow us to copy style from one field to another
        $sheet->getStyle('A2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('A2'), 'B2:E2');

        $sheet->getStyle('F1')->applyFromArray($styleHeaderCustomer_F_T);
        $sheet->duplicateStyle($sheet->getStyle('F1'), 'F1:Q1');
        $sheet->getStyle('F2')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->duplicateStyle($sheet->getStyle('F2'), 'F2:Q2');

        $sheet->getStyle('U1')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('R1'), 'R1:U1');
        $sheet->getStyle('U2')->applyFromArray($styleHeaderFirma2);
        $sheet->duplicateStyle($sheet->getStyle('R2'), 'R2:U2');

        $sheet->getStyle('R1')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('R1'), 'R1:U1');
        $sheet->getStyle('R2')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('R2'), 'R2:U2');

        $sheet->getStyle('V1')->applyFromArray($styleHeaderCustomer);
        $sheet->getStyle('V2')->applyFromArray($styleHeaderCustomer2);

        $sheet->getStyle('W1')->applyFromArray($styleHeaderPreisWP);
        $sheet->getStyle('W2')->applyFromArray($styleHeaderPreisWP);

        $sheet->getStyle('X1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('X1'), 'X1:AF1');
        $sheet->getStyle('AC2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('X2'), 'X2:AF2');

        $sheet->getStyle('AE1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('AE1'), 'AE1:AF1');

        $sheet->getStyle('AQ1')->applyFromArray($styleHeaderDate);
        $sheet->duplicateStyle($sheet->getStyle('AQ1'), 'AQ1:AR1');
        $sheet->getStyle('AQ2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('AQ2'), 'AQ2:AR2');

        $sheet->getStyle('AG1')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->getStyle('AG2')->applyFromArray($styleHeaderCustomer_F_T2);

        $sheet->getStyle('AH1')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AH1'), 'AH1:AN1');
        $sheet->getStyle('AH2')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AH2'), 'AH2:AN2');

        $sheet->getStyle('C2')->getAlignment()->setWrapText(true); // text in new line
    }

    protected function headerStyleArbeitsmittel( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color )
    {
        $sheet->getStyle('A')->applyFromArray($align_text);
        $sheet->getStyle('B')->applyFromArray($align_text);
        $sheet->getStyle('C')->applyFromArray($align_text);
        $sheet->getStyle('D')->applyFromArray($align_text);
        $sheet->getStyle('E')->applyFromArray($align_text);
        $sheet->getStyle('F')->applyFromArray($align_text);
        $sheet->getStyle('G')->applyFromArray($align_text);
        $sheet->getStyle('H')->applyFromArray($align_text);
        $sheet->getStyle('I')->applyFromArray($align_text);
        $sheet->getStyle('J')->applyFromArray($align_text);
        $sheet->getStyle('K')->applyFromArray($align_text);
        $sheet->getStyle('L')->applyFromArray($align_text);
        $sheet->getStyle('M')->applyFromArray($align_text);
        $sheet->getStyle('N')->applyFromArray($align_text);
        $sheet->getStyle('O')->applyFromArray($align_text);
        $sheet->getStyle('P')->applyFromArray($align_text);
        $sheet->getStyle('Q')->applyFromArray($align_text);
        $sheet->getStyle('R')->applyFromArray($align_text);
        $sheet->getStyle('S')->applyFromArray($align_text);
        $sheet->getStyle('T')->applyFromArray($align_text);
        $sheet->getStyle('U')->applyFromArray($align_text);
        $sheet->getStyle('V')->applyFromArray($align_text);
        $sheet->getStyle('W')->applyFromArray($align_text);
        $sheet->getStyle('X')->applyFromArray($align_text);
        $sheet->getStyle('Y')->applyFromArray($align_text);
        $sheet->getStyle('Z')->applyFromArray($align_text);
        $sheet->getStyle('AA')->applyFromArray($align_text);
        $sheet->getStyle('AB')->applyFromArray($align_text);
        $sheet->getStyle('AC')->applyFromArray($align_text);
        $sheet->getStyle('AD')->applyFromArray($align_text);
        $sheet->getStyle('AE')->applyFromArray($align_text);
        $sheet->getStyle('AF')->applyFromArray($align_text);
        $sheet->getStyle('AG')->applyFromArray($align_text);
        $sheet->getStyle('AH')->applyFromArray($align_text);
        $sheet->getStyle('AI')->applyFromArray($align_text);
        $sheet->getStyle('AJ')->applyFromArray($align_text);
        $sheet->getStyle('AK')->applyFromArray($align_text);
        $sheet->getStyle('AL')->applyFromArray($align_text);
        $sheet->getStyle('AM')->applyFromArray($align_text);
        $sheet->getStyle('AN')->applyFromArray($align_text);
        $sheet->getStyle('AO')->applyFromArray($align_text);
        $sheet->getStyle('AP')->applyFromArray($align_text);
        $sheet->getStyle('AQ')->applyFromArray($align_text);
        $sheet->getStyle('AR')->applyFromArray($align_text);
        $sheet->getStyle('AS')->applyFromArray($align_text);
        $sheet->getStyle('AT')->applyFromArray($align_text);
        $sheet->getStyle('AU')->applyFromArray($align_text);
        $sheet->getStyle('AV')->applyFromArray($align_text);
        $sheet->getStyle('AW')->applyFromArray($align_text);
        $sheet->getStyle('AX')->applyFromArray($align_text);
        $sheet->getStyle('AY')->applyFromArray($align_text);

        $sheet->getStyle('A1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('A1'), 'B1:E1');        /// allow us to copy style from one field to another
        $sheet->getStyle('A2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('A2'), 'B2:E2');

        $sheet->getStyle('F1')->applyFromArray($styleHeaderCustomer_F_T);
        $sheet->duplicateStyle($sheet->getStyle('F1'), 'F1:P1');
        $sheet->getStyle('F2')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->duplicateStyle($sheet->getStyle('F2'), 'F2:P2');

        $sheet->getStyle('Q1')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('Q1'), 'Q1:T1');
        $sheet->getStyle('Q2')->applyFromArray($styleHeaderFirma2);
        $sheet->duplicateStyle($sheet->getStyle('Q2'), 'Q2:T2');

        $sheet->getStyle('U1')->applyFromArray($styleHeaderCustomer);
        $sheet->getStyle('U2')->applyFromArray($styleHeaderCustomer2);

        $sheet->getStyle('V1')->applyFromArray($styleHeaderPreisWP);
        $sheet->getStyle('V2')->applyFromArray($styleHeaderPreisWP);

        $sheet->getStyle('W1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('W1'), 'W1:AE1');
        $sheet->getStyle('W2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('W2'), 'W2:AE2');

        $sheet->getStyle('AF1')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->getStyle('AF2')->applyFromArray($styleHeaderCustomer_F_T2);

        $sheet->getStyle('AG1')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AG1'), 'AG1:AM1');
        $sheet->getStyle('AG2')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AG2'), 'AG2:AM2');

        $sheet->getStyle('C2')->getAlignment()->setWrapText(true); // text in new line
    }

    protected function headerStyleSpiel( $sheet, $align_text, $styleHeaderCustomer, $styleHeaderCustomer_F_T, $styleHeaderFirma, $styleHeaderPreisWP, $styleHeaderCustomer2, $styleHeaderCustomer_F_T2, $styleHeaderFirma2, $styleHeaderDate, $invoice_color )
    {
        $sheet->getStyle('A')->applyFromArray($align_text);
        $sheet->getStyle('B')->applyFromArray($align_text);
        $sheet->getStyle('C')->applyFromArray($align_text);
        $sheet->getStyle('D')->applyFromArray($align_text);
        $sheet->getStyle('E')->applyFromArray($align_text);
        $sheet->getStyle('F')->applyFromArray($align_text);
        $sheet->getStyle('G')->applyFromArray($align_text);
        $sheet->getStyle('H')->applyFromArray($align_text);
        $sheet->getStyle('I')->applyFromArray($align_text);
        $sheet->getStyle('J')->applyFromArray($align_text);
        $sheet->getStyle('K')->applyFromArray($align_text);
        $sheet->getStyle('L')->applyFromArray($align_text);
        $sheet->getStyle('M')->applyFromArray($align_text);
        $sheet->getStyle('N')->applyFromArray($align_text);
        $sheet->getStyle('O')->applyFromArray($align_text);
        $sheet->getStyle('P')->applyFromArray($align_text);
        $sheet->getStyle('Q')->applyFromArray($align_text);
        $sheet->getStyle('R')->applyFromArray($align_text);
        $sheet->getStyle('S')->applyFromArray($align_text);
        $sheet->getStyle('T')->applyFromArray($align_text);
        $sheet->getStyle('U')->applyFromArray($align_text);
        $sheet->getStyle('V')->applyFromArray($align_text);
        $sheet->getStyle('W')->applyFromArray($align_text);
        $sheet->getStyle('X')->applyFromArray($align_text);
        $sheet->getStyle('Y')->applyFromArray($align_text);
        $sheet->getStyle('Z')->applyFromArray($align_text);
        $sheet->getStyle('AA')->applyFromArray($align_text);
        $sheet->getStyle('AB')->applyFromArray($align_text);
        $sheet->getStyle('AC')->applyFromArray($align_text);
        $sheet->getStyle('AD')->applyFromArray($align_text);
        $sheet->getStyle('AE')->applyFromArray($align_text);
        $sheet->getStyle('AF')->applyFromArray($align_text);
        $sheet->getStyle('AG')->applyFromArray($align_text);
        $sheet->getStyle('AH')->applyFromArray($align_text);
        $sheet->getStyle('AI')->applyFromArray($align_text);
        $sheet->getStyle('AJ')->applyFromArray($align_text);
        $sheet->getStyle('AK')->applyFromArray($align_text);
        $sheet->getStyle('AL')->applyFromArray($align_text);
        $sheet->getStyle('AM')->applyFromArray($align_text);
        $sheet->getStyle('AN')->applyFromArray($align_text);
        $sheet->getStyle('AO')->applyFromArray($align_text);
        $sheet->getStyle('AP')->applyFromArray($align_text);
        $sheet->getStyle('AQ')->applyFromArray($align_text);
        $sheet->getStyle('AR')->applyFromArray($align_text);
        $sheet->getStyle('AS')->applyFromArray($align_text);
        $sheet->getStyle('AT')->applyFromArray($align_text);
        $sheet->getStyle('AU')->applyFromArray($align_text);
        $sheet->getStyle('AV')->applyFromArray($align_text);
        $sheet->getStyle('AW')->applyFromArray($align_text);
        $sheet->getStyle('AX')->applyFromArray($align_text);
        $sheet->getStyle('AY')->applyFromArray($align_text);

        $sheet->getStyle('A1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('A1'), 'B1:E1');        /// allow us to copy style from one field to another
        $sheet->getStyle('A2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('A2'), 'B2:E2');

        $sheet->getStyle('F1')->applyFromArray($styleHeaderCustomer_F_T);
        $sheet->duplicateStyle($sheet->getStyle('F1'), 'F1:N1');
        $sheet->getStyle('F2')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->duplicateStyle($sheet->getStyle('F2'), 'F2:N2');

        $sheet->getStyle('O1')->applyFromArray($styleHeaderFirma);
        $sheet->duplicateStyle($sheet->getStyle('O1'), 'O1:R1');
        $sheet->getStyle('O2')->applyFromArray($styleHeaderFirma2);
        $sheet->duplicateStyle($sheet->getStyle('O2'), 'O2:R2');

        $sheet->getStyle('S1')->applyFromArray($styleHeaderCustomer);
        $sheet->getStyle('S2')->applyFromArray($styleHeaderCustomer2);

        $sheet->getStyle('T1')->applyFromArray($styleHeaderPreisWP);
        $sheet->getStyle('T2')->applyFromArray($styleHeaderPreisWP);

        $sheet->getStyle('U1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('U1'), 'U1:AC1');
        $sheet->getStyle('U2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('U2'), 'U2:AC2');

        $sheet->getStyle('AB1')->applyFromArray($styleHeaderCustomer);
        $sheet->duplicateStyle($sheet->getStyle('AB1'), 'AB1:AC1');

        $sheet->getStyle('AQ1')->applyFromArray($styleHeaderDate);
        $sheet->duplicateStyle($sheet->getStyle('AQ1'), 'AQ1:AR1');
        $sheet->getStyle('AQ2')->applyFromArray($styleHeaderCustomer2);
        $sheet->duplicateStyle($sheet->getStyle('AQ2'), 'AQ2:AR2');

        $sheet->getStyle('AD1')->applyFromArray($styleHeaderCustomer_F_T2);
        $sheet->getStyle('AD2')->applyFromArray($styleHeaderCustomer_F_T2);

        $sheet->getStyle('AE1')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AE1'), 'AE1:AK1');
        $sheet->getStyle('AE2')->applyFromArray($invoice_color);
        $sheet->duplicateStyle($sheet->getStyle('AE2'), 'AE2:AK2');

        $sheet->getStyle('C2')->getAlignment()->setWrapText(true); // text in new line
    }


    //////////////////////////////////////////////////////////////////////////////////

    /////////////////////////////EXCEL CLASSES AND CELLS /////////////////////////////

    protected function ensureSheetSize($sheet, $sheet_title)
    {

        $this->column_size( $sheet );
        $this->execelMergeCells($sheet, $columns = 'A1:C1' );
        $this->execelMergeCells($sheet, $columns = 'F1:I1' );

        if ( $sheet_title == "Aufzug" ) {

            $this->execelMergeCells($sheet, $columns = 'AJ1:AK1' );
            $this->execelMergeCells($sheet, $columns = 'AQ1:AR1' );
        }
    }    

    protected function ensureInvoiceSheetSize($sheet)
    {

        $this->column_invoce_size( $sheet );
    }

    protected function column_invoce_size( $sheet )
    {

        $sheet->getRowDimension('1')->setRowHeight(20);
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(50);

        foreach(range('C','Z') as $columnID) {

            $sheet->getColumnDimension($columnID)
                ->setAutoSize(true);
        }        
    }

    protected function column_size( $sheet )
    {
        $sheet->getRowDimension('1')->setRowHeight(60);
        $sheet->getColumnDimension('A')->setWidth(50);
        $sheet->getColumnDimension('B')->setWidth(50);
        $sheet->getColumnDimension('C')->setWidth(20);
        $sheet->getColumnDimension('AQ')->setWidth(50);
        $sheet->getColumnDimension('AR')->setWidth(50);


        foreach(range('E','Z') as $columnID) {

            $sheet->getColumnDimension($columnID)
                ->setAutoSize(true);
        }

        $sheet->getColumnDimension('AA')->setAutoSize(true);
        $sheet->getColumnDimension('AB')->setAutoSize(true);
        $sheet->getColumnDimension('AC')->setAutoSize(true);
        $sheet->getColumnDimension('AD')->setAutoSize(true);
        $sheet->getColumnDimension('AE')->setAutoSize(true);
        $sheet->getColumnDimension('AF')->setAutoSize(true);
        $sheet->getColumnDimension('AG')->setAutoSize(true);
        $sheet->getColumnDimension('AH')->setAutoSize(true);
        $sheet->getColumnDimension('AI')->setAutoSize(true);
        $sheet->getColumnDimension('AJ')->setAutoSize(true);
        $sheet->getColumnDimension('AK')->setAutoSize(true);
        $sheet->getColumnDimension('AL')->setAutoSize(true);
        $sheet->getColumnDimension('AM')->setAutoSize(true);
        $sheet->getColumnDimension('AN')->setAutoSize(true);
        $sheet->getColumnDimension('AO')->setAutoSize(true);
        $sheet->getColumnDimension('AP')->setAutoSize(true);
        $sheet->getColumnDimension('AQ')->setAutoSize(true);
        $sheet->getColumnDimension('AR')->setAutoSize(true);
        $sheet->getColumnDimension('AS')->setAutoSize(true);
        $sheet->getColumnDimension('AT')->setAutoSize(true);
        $sheet->getColumnDimension('AU')->setAutoSize(true);
        $sheet->getColumnDimension('AV')->setAutoSize(true);
        $sheet->getColumnDimension('AW')->setAutoSize(true);
        $sheet->getColumnDimension('AX')->setAutoSize(true);
        $sheet->getColumnDimension('AY')->setAutoSize(true);
        $sheet->getColumnDimension('AZ')->setAutoSize(true);
    }
    
    protected function align_text_stylesheetInitialize()
    {
        return array(

            'font' => array(
                'bold' => false,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            )
        );
    }

    protected function styleHeaderCustomerStylesheetInitializeA1E1()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => 'ffffff'),
                'size'  => 18,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FFE699')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderCustomerStylesheetInitializeA2E2()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FFE699')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderCustomerStylesheetInitializeF1T1()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => 'ffffff'),
                'size'  => 18,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FF9999')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderCustomerStylesheetInitializeF2T2()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FF9999')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderInvoiceColor()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '95B3D7')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderFirma()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => 'ffffff'),
                'size'  => 18,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'CCCC99')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderFirma2()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'CCCC99')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderDate()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => 'ffffff'),
                'size'  => 14,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FFE699')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }


    protected function styleHeaderPreisWP()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FFCC00')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderInvoiceTitleLightBrowun()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'fcd5b4')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }


    protected function styleDefaultColorAndAlignCenter()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'ffffff')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function styleHeaderInvoiceTitleBrowun()
    {

        return array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => '000000'),
                'size'  => 10,
                'name' => 'Calibri'
            ),
            'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => '808080')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            ),
            'borders' => array(
                'outline' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'ffffff')
                )
            )
        );
    }

    protected function execelMergeCells($sheet, $columns)
    {
        $sheet->mergeCells($columns);
    }


    protected function ensure_evaluierungFristen_excel($evaluierungFristen)
    {
        if ( $evaluierungFristen != null || $evaluierungFristen != "" ) {

            $evaluierungFristen = DateTime::createFromFormat('Y-m-d', $evaluierungFristen)->format('d-m-Y');
            $evaluierungFristen = str_replace("-",".", $evaluierungFristen);

            return $evaluierungFristen;
        } else {

            return null;
        }
    }

    protected function renderAufzugswarter($model)
    {
        $name = [];
        if ( count($model->getAufzugswarters()->all()) > 0 ) {

            foreach ($model->getAufzugswarters()->all() as $key => $data) {
                array_push($name, $data->name);
                $name_separated_with_comma = implode(", ", $name);
            }

            return $name_separated_with_comma;
        }else {
            return null;
        }
    }

    protected function renderFirmaName($firma_id)
    {
        $firma = Wartungsfirma::findOne($firma_id);
        return $firma->name;
    }

    protected function sendMailToCustomer($customer)
    {
        if ( $customer->send_mail ) {

            return true;
        }else {

            return null;
        }
    }
    ////////////////////////////////////////////////////////////////////////////////
}