<?php

namespace backend\modules\coworkers\controllers;

use Yii;
use common\models\User;
use common\models\CoworkerControll;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\Role;
use common\models\Responsive;
use common\models\Type;
use common\models\Tehnical;
use yii\helpers\ArrayHelper;
use yii\filters\AccessControl;
/**
 * AdminController implements the CRUD actions for User model.
 */
class BaseController extends Controller
{

    public function init() {
        parent::init();
        $this->layout = '@backend/modules/coworkers/views/layouts/main.php';
        // custom initialization code goes here
    }

    protected function currentUser()
    {
        $id = Yii::$app->user->getId();

        if($id)
        {
            $user= User::find()->where(['id' => $id])->one();

            return $user;
        }else {
            $this->redirect(['site/login']);
        }
    }

    protected function logUser()
    {
        $id = Yii::$app->user->getId();
        return $id ? User::find()->where(['id' => $id])->one() : false;
    }

    protected function isAdmin()
    {
        $id = Yii::$app->user->getId();
        return $id ? true : false;
    }

    public function isDesktop()
    {

        $responsive = $this->currentUser()->getResponsive();

        if(!$responsive) {
            $responsive = new Responsive();
            $responsive->name = "Responsive Application";
            $responsive->user_id = $this->currentUser()->id;
            $responsive->desktop = 1;
            $responsive->save();
        }

        if ( $responsive->desktop ) {

            return true;
        }else {

            return false;
        }
    }


    public function today()
    {

        return date("d.m.Y");
    }

    public function CoworkerPermission()
    {
        $user = $this->currentUser();
        $permission = $user->getCoworekerPermission();
        return $permission;
    }


    protected function ensureType($user)
    {
        $anlagen_type =  $user->getCoworekerPermission()->tehnical_type_string_array;
        $anlagen_type = unserialize($anlagen_type);

        $types = Type::find()->where(['id' => $anlagen_type])->all();
        return ArrayHelper::map($types,'id', 'name');
    }

    protected function ensureUsers($user)
    {

        $kunden_betraibers = $user->getCoworekerPermission()->kunden_betraiber_string_array;
        $kunden_betraibers = unserialize($kunden_betraibers);

        $users = User::find()->where(['user.id' => $kunden_betraibers])->andWhere(['role_id' => 2])->all();
        return ArrayHelper::map($users,'id', 'id');
    }

    protected function ensureAnlagens($user_ids, $type_ids)
    {

        $anlagens = Tehnical::find()->where(['user_id' => $user_ids])->andWhere(['Type' => $type_ids])->all();
        return ArrayHelper::map($anlagens,'id', 'id');
    }

    protected function ensureClients($user)
    {

        $kunden_betraibers = $user->getCoworekerPermission()->kunden_betraiber_string_array;
        $kunden_betraibers = unserialize($kunden_betraibers);
        $users = User::find()->where(['user.id' => $kunden_betraibers]);

        $clients_array = ArrayHelper::map($users->all(),'id','Betreiber');
        return array_unique($clients_array);
    }
}