<?php

namespace backend\modules\coworkers\controllers;

use Yii;
use common\models\Aufzugswarter;
use common\models\AufzugswarterTehnicJoin;
use common\models\search\AufzugswarterBackendSearch;
use common\models\search\AufzugswarterBackendSearchGlobal;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * AufzugswarterController implements the CRUD actions for Aufzugswarter model.
 */
class AufzugswarterController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->aufzugswarter ) {
        }else {

         #   Yii::$app->session->setFlash('success', 'You do not have permission to access Anlagen !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Aufzugswarter models.
     * @return mixed
     */
    public function actionIndex()
    {
        $permission = $this->CoworkerPermission();
        $searchModel = new AufzugswarterBackendSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $searchModelGlobal = new AufzugswarterBackendSearchGlobal();
        $aufzugswarters = $searchModelGlobal->search(Yii::$app->request->queryParams);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'searchModel' => $searchModel,
            'searchModelGlobal' => $searchModelGlobal,
            'aufzugswarters' => $aufzugswarters,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single Aufzugswarter model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $permission = $this->CoworkerPermission();
        $desktop = $this->isDesktop();
        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $model,
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Creates a new Aufzugswarter model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {   
        $permission = $this->CoworkerPermission();

        if ( $permission->aufzugswarter_new ) {

            $model = new Aufzugswarter();
            $desktop = $this->isDesktop();

            if ($model->load(Yii::$app->request->post()) ) {

                $lifts = Yii::$app->request->post()["Aufzugswarter"]["tehnic_id"];

                if ( $model->save() ) {

                    if ( $lifts != "" ) {

                        foreach ($lifts as $key => $lift_id) {

                            $model_lift = new AufzugswarterTehnicJoin();
                            $model_lift->tehnic_id = (int)$lift_id;
                            $model_lift->aufzugswarter_id = (int)$model->id;
                            $model_lift->save();

                        }
                    }
                }

                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                    'desktop' => $desktop,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create Aufzugswarter !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Updates an existing Aufzugswarter model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->aufzugswarter_edit ) {

            $model = $this->findModel($id);
            $desktop = $this->isDesktop();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                    'desktop' => $desktop,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to edit Aufzugswarter !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    /**
     * Deletes an existing Aufzugswarter model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->aufzugswarter_edit ) {

            $this->findModel($id)->delete();
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to destroy Aufzugswarter !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    /**
     * Finds the Aufzugswarter model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Aufzugswarter the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Aufzugswarter::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
