<?php

namespace backend\modules\coworkers\controllers;

use Yii;
use common\models\Anlagentyp;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * AnlagentypController implements the CRUD actions for Anlagentyp model.
 */
class AnlagentypController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->anlagentyp ) {
        }else {

           # Yii::$app->session->setFlash('success', 'You do not have permission to access Anlagen Type !');
            $this->redirect(['/coworkers/tehnical/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Anlagentyp models.
     * @return mixed
     */
    public function actionIndex()
    {   
        $permission = $this->CoworkerPermission();
        $query = Anlagentyp::find();
        $count = $query->count();

        $pagination = new Pagination([
            'defaultPageSize' => 20,
            'totalCount' => $count
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [ 'pageSize' => 20 ],
        ]);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'pagination' => $pagination,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single Anlagentyp model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $permission = $this->CoworkerPermission();
        $desktop = $this->isDesktop();
        return $this->render('view', [
            'model' => $this->findModel($id),
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Creates a new Anlagentyp model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {

        $permission = $this->CoworkerPermission();

        if ( $permission->anlagentyp_new ) {

            $model = new Anlagentyp();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create Anlagentyp !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Updates an existing Anlagentyp model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->anlagentyp_edit ) {

            $model = $this->findModel($id);

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to edit Anlagentyp !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    /**
     * Deletes an existing Anlagentyp model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->anlagentyp_destroy ) {

            $this->findModel($id)->delete();
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to delete Anlagentyp !');
            return $this->redirect(['/site/coworker']);               
        }
    }

    /**
     * Finds the Anlagentyp model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Anlagentyp the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Anlagentyp::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
