<?php

namespace backend\modules\coworkers\controllers;

use Yii;
use common\models\AnlagenStatus;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * AnlagenStatusController implements the CRUD actions for AnlagenStatus model.
 */
class AnlagenStatusController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->anlagen_status ) {
        }else {
            $this->redirect(['/coworkers/tehnical/index']);
        }
        
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all AnlagenStatus models.
     * @return mixed
     */
    public function actionIndex()
    {   
        $permission = $this->CoworkerPermission();
        $query = AnlagenStatus::find();
        $count = $query->count();

        $pagination = new Pagination([
            'defaultPageSize' => 2,
            'totalCount' => $count
        ]);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [ 'pageSize' => 2 ],
        ]);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'pagination' => $pagination,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single AnlagenStatus model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $permission = $this->CoworkerPermission();
        $desktop = $this->isDesktop();
        return $this->render('view', [
            'model' => $this->findModel($id),
            'desktop' => $desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Creates a new AnlagenStatus model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->anlagen_status_new ) {

            $model = new AnlagenStatus();

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('create', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create AnlagenStatus !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Updates an existing AnlagenStatus model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->anlagen_status_edit ) {

            $model = $this->findModel($id);

            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
                return $this->render('update', [
                    'model' => $model,
                ]);
            }
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to edit AnlagenStatus !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    /**
     * Deletes an existing AnlagenStatus model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->anlagen_status_destroy ) {

            $this->findModel($id)->delete();
            return $this->redirect(['index']);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to delete AnlagenStatus !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Finds the AnlagenStatus model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return AnlagenStatus the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = AnlagenStatus::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
