<?php

namespace backend\modules\coworkers\controllers;

use Yii;
use common\models\User;
use common\models\search\UserBackendCoworkerSearch;
use common\models\CoworkerControll;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\SendInvitationForm;
use common\models\Role;
use yii\data\Pagination;
use common\models\search\UserBackendCoworkerSearchGlobal;
use yii\helpers\ArrayHelper;

/**
 * AdminController implements the CRUD actions for User model.
 */
class AdminController extends BaseController
{
    public function beforeAction($action)
    {
        if ($this->logUser() == false) {

            if ( $_SERVER['HTTP_HOST'] == "www.anlagendoku.com" ) {

                header("Location: https://www.anlagendoku.com/admin/site/login");
            }else if ( $_SERVER['HTTP_HOST'] == "stage.anlagendoku.com" ) {

                header("Location: https://stage.anlagendoku.com/admin/site/login");
            }else if ( $_SERVER['HTTP_HOST'] == "dev.anlagendoku.com" ) {

                header("Location: https://dev.anlagendoku.com/admin/site/login");
            }else {

                header("Location: http://localhost/Aufzugstechnik/backend/web/site/login");   
            }
            die();
        }
        return true;
    }
    /**
     * @inheritdoc
     */
    public function behaviors()
    {   
        $permission = $this->CoworkerPermission();
        if ( $this->currentUser() && $permission->kunden ) {
        }else {
            $this->redirect(['/coworkers/tehnical/index']);
        }

        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex()
    {
        $permission = $this->CoworkerPermission();

        $searchModel = new UserBackendCoworkerSearch();
        $searchModelGlobal = new UserBackendCoworkerSearchGlobal();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $users = $searchModelGlobal->search(Yii::$app->request->queryParams);

        $user = $this->currentUser();
        $clients_unique_array = $this->ensureClients($user);
        $users->query->andFilterWhere(['IN','Betreiber', $clients_unique_array]);

        $user_invitation = new SendInvitationForm();
        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'searchModel' => $searchModel,
            'user_invitation' => $user_invitation,
            'searchModelGlobal' => $searchModelGlobal,
            'users' => $users,
            'desktop' =>$desktop,
            'permission' => $permission,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $permission = $this->CoworkerPermission();

        if ( $permission->kunden_new ) {

            $model = new SendInvitationForm();
            $desktop = $this->isDesktop();
            if($model->load(Yii::$app->request->post()))
            {

                $user_password = bin2hex(openssl_random_pseudo_bytes(10));
                $user = $model->SendInvitation($user_password);

                if (isset($user)) {  
                    Yii::$app->session->setFlash('success', 'You have successfully created user !');
                    if ($model->send_mail == "1") {
                        $user_invitation = null;
                     #   $this->sendMailToUser($user, $user_password, $user_invitation);
                    }
                    return $this->redirect('index');
                }
            }
            return $this->render('create', [
                'model' => $model,
                'desktop' => $desktop,
            ]);
        } else {

            Yii::$app->session->setFlash('success', 'You do not have permission to create user !');
            return $this->redirect(['/site/coworker']);            
        }    
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $this->ensureRelevantUser($id);
        $permission = $this->CoworkerPermission();

        if ( $permission->kunden_edit ) {

            $desktop = $this->isDesktop();
            $model = $this->findModel($id);

            if ($model->load(Yii::$app->request->post()) ) {

                $model->send_mail = "0";
                $model->username = $model->email;

                if ( $model->save()) {

                    Yii::$app->session->setFlash('success', 'You have successfully updated user !');
                    return $this->redirect(['index']);
                }
            } else {
                return $this->render('update', [
                    'model' => $model,
                    'desktop' => $desktop,
                ]);
            }
        } else {

            Yii::$app->session->setFlash('success', 'You do not have permission to updated user !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    public function actionChangePassword($id)
    {
        $desktop = $this->isDesktop();
        $model = $this->findModel($id);
        $model->setScenario('changePswAdmin');

        if ($model->load(Yii::$app->request->post()) ) {

            $model->setPassword($model->new_password);
            $model->client_password = $model->new_password;

            if ( $model->save() ) {

                Yii::$app->session->setFlash('success', 'You have successfully changed User password !');
                return $this->redirect(['index']);
            }         
        }else {

            return $this->render('password', [
                'model' => $model,
                'desktop' => $desktop,
            ]);
        }
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $permission = $this->CoworkerPermission();
        
        if ( $permission->kunden_destroy ) {

            if ($this->findModel($id)->delete()) {
                Yii::$app->session->setFlash('success', 'You have successfully deleted user !');
            }

            return $this->redirect(['index']);
        } else {

            Yii::$app->session->setFlash('success', 'You do not have permission to delete user !');
            return $this->redirect(['/site/coworker']);            
        }
    }

    public function actionSendEmail()
    {

        $permission = $this->CoworkerPermission();

        if ( $permission->kuden_send_email ) {

            $user_id = $_GET['user_id'];
            $user_invitation = new SendInvitationForm();
            $this->initialize_user_for_send_email($user_id, $user_invitation);

            $query = User::find();
            $count = $query->count();
            $pagination = new Pagination([
                'defaultPageSize' => 10,
                'totalCount' => $count
            ]);

            $dataProvider = $query->offset($pagination->offset)
                ->limit($pagination->limit)
                ->all();

            return $this->render('send_email', [
                'dataProvider' => $dataProvider,
                'pagination' => $pagination,
                'user_invitation' => $user_invitation,
            ]);
        }else {

            Yii::$app->session->setFlash('success', 'You do not have permission to send Email !');
            return $this->redirect(['/site/coworker']);
        }
    }

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */

    protected function initialize_user_for_send_email($user_id, $user_invitation)
    {   
        if ($user_id) {

            $user = $this->findModel($user_id);

            if ($user_invitation->load(Yii::$app->request->post()) ) {

                $this->send_message_from_form($user, $user_invitation);
            }
        }        
    }

    protected function send_message_from_form($user, $user_invitation)
    {   

        if ( $user_invitation->send_standard_content_with_email ) {

            $this->sendMailToUser($user, $user->client_password, $user_invitation);
        }else {

            $this->sendMailToUserWithoutStandardContent($user, $user_invitation);
        }
        return $this->redirect('index');   
    }

    protected function findModel($id)
    {
        if (($model = User::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    protected function sendMailToUser($user, $user_password, $user_invitation)
    {

        Yii::$app->mailer->compose('contact', ['model' => $user, 'password' => $user_password, 'user_invitation' => $user_invitation])
            ->setFrom('office@anlagendoku.com')
            ->setTo($user->email)
          #  ->setCc(array('belmir.hamidovic@anlagendoku.com'))
            ->setSubject("Ihre Zugangsdaten zu anlagendoku.com")
            ->send();
        Yii::$app->session->setFlash('success', 'The mail has been sent successfully !');  
    }


    protected function sendMailToUserWithoutStandardContent($user, $user_invitation)
    {
        if ( $user_invitation->emails ) {
            $emails = explode(", ", $user_invitation->emails);
            Yii::$app->mailer->compose('contact_without_standard_content', ['user_invitation' => $user_invitation])
                ->setFrom('office@anlagendoku.com')
                ->setTo($emails)
                ->setCc(array('belmir.hamidovic@anlagendoku.com'))
                ->setSubject($user_invitation->subject)
                ->send();
            Yii::$app->session->setFlash('success', 'The mails have been successfully sent !');
        }else {

            Yii::$app->mailer->compose('contact_without_standard_content', ['model' => $user, 'user_invitation' => $user_invitation])
                ->setFrom('office@anlagendoku.com')
                ->setTo($user->email)
                ->setCc(array('belmir.hamidovic@anlagendoku.com'))
                ->setSubject($user_invitation->subject)
                ->send();
            Yii::$app->session->setFlash('success', 'The mail has been sent successfully !');
        }   
    }

    protected function updatePasswordForUser($user, $user_password)
    {
        Yii::$app->mailer->compose('update_contact', ['model' => $user, 'password' => $user_password])
            ->setFrom('office@anlagendoku.com')
            ->setTo($user->email)
          #  ->setCc(array('belmir.hamidovic@anlagendoku.com'))
            ->setSubject("Anlagendoku Update Password")
            ->send();
    }

    public function display_pagination_unlesss_SearchQueryParams()
    {       
        if ( !isset($_GET['page']) && Yii::$app->request->queryParams && $_GET['UserFrontendSearchGlobal']["globalSearch"] != "" ) {
            return false;
        }else {
            return true;
        }
    }


    protected function ensureRelevantUser($id)
    {
        $user = $this->currentUser();

        $kunden_betraibers = $user->getCoworekerPermission()->kunden_betraiber_string_array;
        $kunden_betraibers = unserialize($kunden_betraibers);

        $user_array = [2, 3]; 

        $users = User::find()->where(['user.id' => $kunden_betraibers])->andWhere(['role_id' => $user_array])->all();
        $user_ids = ArrayHelper::map($users,'id', 'id');


        if ( in_array( $id, $user_ids ) ) {

            return true;
        }else {

        Yii::$app->session->setFlash('success', 'You do not have permission to update this Prüfungen !');
        return $this->redirect(['/site/coworker']);        }
    }
}