<?php
namespace backend\models;

use yii\base\Model;
use common\models\User;

/**
 * Signup form
 */
class SendInvitationForm extends Model
{
    public $email;
    public $email2;
    public $user;
    public $role_id;
    public $company_id;
    public $password;
    public $Betreiber;
    public $AdresseBundesland;
    public $AdresseOrt;
    public $AdresseStreat;
    public $AdressePLZ;
    public $AdresseStiege;
    public $Telefonnummer;
    public $send_mail;
    public $send_message_from_mail;
    public $send_standard_content_with_email;
    public $subject;
    public $emails;
    public $last_name;
    public $first_name;
    public $send_attachement;

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
          //  ['role_id', 'required'],
            ['user', 'safe'],
            [['company_id','Betreiber', 'AdresseBundesland', 'AdresseOrt', 'AdresseStreat', 'AdressePLZ', 'AdresseStiege', 'Telefonnummer', 'send_mail', 'send_message_from_mail', 'send_standard_content_with_email', 'subject', 'emails', 'first_name', 'last_name', 'send_attachement'], 'safe'],
            ['username','safe'],
            ['email2','safe'],
            ['email', 'trim'],
            [['email', 'Betreiber'], 'required'],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['email', 'unique', 'targetClass' => '\common\models\User', 'message' => 'This email address has already been taken.'],
            [['emails', 'subject', 'send_message_from_mail'], 'required', 'on' => 'sendFromSendEmailController'],
           /* ['password', 'required'],
            ['password', 'string', 'min' => 6],*/
        ];
    }

    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
    public function SendInvitation($user_password)
    {
        if (!$this->validate()) {
            return null;
        }
        $user = new User();
        $user->username = $this->email;
        $user->email = $this->email;
        $user->role_id = 2;
        $user->setPassword($user_password);
        $user->client_password = $user_password;
        $user->generateAuthKey();
        $user->Betreiber = $this->Betreiber;
        $user->AdresseBundesland = $this->AdresseBundesland;
        $user->AdresseOrt = $this->AdresseOrt;
        $user->AdresseStreat = $this->AdresseStreat;
        $user->AdressePLZ = $this->AdressePLZ;
        $user->AdresseStiege = $this->AdresseStiege;
        $user->Telefonnummer = $this->Telefonnummer;
        $user->email2 = $this->email2;
        return $user->save() ? $user : null;
    }

    public function SendCoworkerInvitation($user_password)
    {
        if (!$this->validate()) {
            return null;
        }
        $user = new User();
        $user->username = $this->email;
        $user->email = $this->email;
        $user->role_id = 4;
        $user->setPassword($user_password);
        $user->client_password = $user_password;
        $user->generateAuthKey();
        $user->Betreiber = "FI - Technisches Büro für Aufzugstechnik e.U";
        $user->AdresseBundesland = $this->AdresseBundesland;
        $user->AdresseOrt = $this->AdresseOrt;
        $user->AdresseStreat = $this->AdresseStreat;
        $user->AdressePLZ = $this->AdressePLZ;
        $user->AdresseStiege = $this->AdresseStiege;
        $user->Telefonnummer = $this->Telefonnummer;
        $user->first_name = $this->first_name;
        $user->last_name = $this->last_name;
        $user->email2 = $this->email2;
        return $user->save() ? $user : null;
    }
}
