<?php

namespace backend\controllers;

use Yii;
use common\models\Wartungsfirma;
use common\models\search\WartungsfirmaBackendSearch;
use common\models\search\WartungsfirmaBackendSearchGlobal;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;

/**
 * WartungsfirmaController implements the CRUD actions for Wartungsfirma model.
 */
class WartungsfirmaController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Wartungsfirma models.
     * @return mixed
     */
    public function actionIndex()
    {

        $searchModel = new WartungsfirmaBackendSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        $searchModelGlobal = new WartungsfirmaBackendSearchGlobal();
        $wartungsfirmas = $searchModelGlobal->search(Yii::$app->request->queryParams);

        $desktop = $this->isDesktop();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'searchModel' => $searchModel,
            'searchModelGlobal' => $searchModelGlobal,
            'wartungsfirmas' => $wartungsfirmas,
        ]);
    }

    /**
     * Displays a single Wartungsfirma model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {   
        $desktop = $this->isDesktop();
        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $model,
            'desktop' => $desktop,
        ]);
    }

    /**
     * Creates a new Wartungsfirma model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Wartungsfirma();
        $desktop = $this->isDesktop();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
                'desktop' => $desktop,
            ]);
        }
    }

    /**
     * Updates an existing Wartungsfirma model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $desktop = $this->isDesktop();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'desktop' => $desktop,
            ]);
        }
    }

    /**
     * Deletes an existing Wartungsfirma model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Wartungsfirma model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Wartungsfirma the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Wartungsfirma::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
