<?php

namespace backend\controllers;

use Yii;
use common\models\Tehnical;
use common\models\CronXls;
use common\models\Images;
use common\models\InvoiceData;
use common\models\search\TehinicalSearch;
use common\models\search\TehinicalInactiveSearch;
use common\models\search\TehinicalGlobalBackendSearch;
use common\models\Aufzugswarter;
use common\models\AufzugswarterTehnicJoin;
use common\models\User;
use common\models\Wartungsfirma;
use common\models\Type;
use common\models\Type2;
use common\models\Antriebsart;
use common\models\Betriebskontrollen;
use common\models\Wartungsart;
use common\models\Anlagentyp;
use common\models\AnlagenStatus;
use common\models\Evaluierung;
use common\models\GoogleCordinate; # Add Anlagen to the map
use common\models\GeratMangel;
use common\models\Frist;
use common\models\TehnicalDocument;
use common\models\UserAnlagenCoworkerControl;
use common\models\CoworkerControll;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
//use mPDF;
use common\models\TehnicReview;
use common\models\Role;
use yii\web\UploadedFile;
use yii\web\Response;
use kartik\mpdf\Pdf;
use dosamigos\google\maps\services\DirectionsClient;
use dosamigos\google\maps\LatLng;
use dosamigos\google\maps\services\DirectionsWayPoint;
use dosamigos\google\maps\services\TravelMode;
use dosamigos\google\maps\overlays\PolylineOptions;
use dosamigos\google\maps\services\DirectionsRenderer;
use dosamigos\google\maps\services\DirectionsService;
use dosamigos\google\maps\overlays\InfoWindow;
use dosamigos\google\maps\overlays\Marker;
use dosamigos\google\maps\Map;
use dosamigos\google\maps\services\DirectionsRequest;
use dosamigos\google\maps\overlays\Polygon;
use dosamigos\google\maps\layers\BicyclingLayer;
use DateTime;
use DateTimeZone;
use yii\helpers\ArrayHelper;
use yii\data\Pagination;
use common\models\Prufgrundlage;
use common\models\Norm;
use common\models\Magel;
use common\models\MangelProperties;
use common\models\RestApiAuth;

/**
 * TehnicalController implements the CRUD actions for Tehnical model.
 */
class TehnicalController extends PdfBaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Tehnical models.
     * @return mixed
     */

    public function actionIndex()
    {
        $excel_object = new Tehnical();
        $searchModel = new TehinicalSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $searchModelGlobal = new TehinicalGlobalBackendSearch();
        $tehnicals_mobile = $searchModelGlobal->search(Yii::$app->request->queryParams);
        $google = new GoogleCordinate();
        $desktop = $this->isDesktop();
        $title = 'Inactive';
        $link = 'inactive';
        
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'excel_object' => $excel_object,
            'google' => $google,
            'desktop' => $desktop,
            'searchModelGlobal' => $searchModelGlobal,
            'tehnicals_mobile' => $tehnicals_mobile,
            'title' => $title,
            'link' => $link
        ]);
    }

    public function actionInactive()
    {
        $excel_object = new Tehnical();
        $searchModel = new TehinicalInactiveSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $searchModelGlobal = new TehinicalGlobalBackendSearch();
        $tehnicals_mobile = $searchModelGlobal->search(Yii::$app->request->queryParams);
        $google = new GoogleCordinate();
        $desktop = $this->isDesktop();
        $title = 'Active';
        $link = 'index';


        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'excel_object' => $excel_object,
            'google' => $google,
            'desktop' => $desktop,
            'searchModelGlobal' => $searchModelGlobal,
            'tehnicals_mobile' => $tehnicals_mobile,
            'title' => $title,
            'link' => $link
        ]);
    }


    public function ensure_coworekr_lifts($worker_id) {

        $coworker_anlagen_control_ids = array();


        $coworker_anlagen_control = UserAnlagenCoworkerControl::find()
            ->select('user_anlagen_coworker_control.*')
            ->leftJoin('tehnical', '`tehnical`.`id` = `user_anlagen_coworker_control`.`anlagen_id`')
            ->where(['user_anlagen_coworker_control.user_id' => $worker_id])
            ->with('tehnical')
            ->all();

            if($coworker_anlagen_control) {

               if (!array_key_exists($worker_id, $coworker_anlagen_control_ids)) {

                   $coworker_anlagen_control_ids[$worker_id]['user'] = array();
                   $coworker_anlagen_control_ids[$worker_id]['anlagen'] = array();
                }

                $user_ids = array();
                $anlagen_ids = array();

                foreach ($coworker_anlagen_control as $key => $value) {


                    array_push($user_ids, $value->tehnical->user_id);
                    array_push($anlagen_ids, $value->anlagen_id);
                }


                array_push($coworker_anlagen_control_ids[$worker_id]['user'], $user_ids);

                array_push($coworker_anlagen_control_ids[$worker_id]['anlagen'], $anlagen_ids);
            }

        foreach ($coworker_anlagen_control_ids as $key => $value) {

            $types = $this->getAllTypes();
            $betreibers = array_unique($value['user'][0]);
            $betreibers = serialize($betreibers);
            $anlagen_string = array_unique($value['anlagen'][0]);
            $anlagen_string = serialize($anlagen_string);

            $coworker_control = CoworkerControll::find()->where(['user_id' => $key])->one();

            if($coworker_control) {
                //update
                $coworker_control->tehnical_type_string_array = $types;
                $coworker_control->kunden_betraiber_string_array = $betreibers;
                $coworker_control->anlagen_string = $anlagen_string;
                $coworker_control->save();
            }else {
                //create

                $model = new CoworkerControll();
                $model->tehnical_type_string_array = $types;
                $model->kunden_betraiber_string_array = $betreibers;
                $model->anlagen_string = $anlagen_string;
                $model->user_id = $key;
                $model->kunden = 1;
                $model->kunden_new = 0;
                $model->kunden_edit = 0;
                $model->kunden_destroy = 0;
                $model->kuden_send_email = 0;
                $model->kunden_export = 0;

                $model->tehnical = 1;
                $model->tehnical_new = 0;
                $model->tehnical_edit = 0;
                $model->tehnical_destroy = 0;
                $model->tehnical_import_data = 0;
                $model->tehnical_export_data = 0;
                $model->tehnical_add_lat_lang = 0;
                $model->tehnical_prufungen = 0;
                $model->tehnical_pdf_preview = 0;

                $model->tehnic_review = 1;
                $model->tehnic_review_new = 0;
                $model->tehnic_review_edit = 0;
                $model->tehnic_review_destroy = 0;
                $model->tehnic_review_send_email = 0;

                $model->karte = 0;
                $model->karteMarked = 0;
                $model->karteWeek = 0;

                $model->aufzugswarter = 0;
                $model->aufzugswarter_new = 0;
                $model->aufzugswarter_edit = 0;
                $model->aufzugswarter_destroy = 0;

                $model->wartungsfirma = 0;
                $model->wartungsfirma_new = 0;
                $model->wartungsfirma_edit = 0;
                $model->wartungsfirma_destry = 0;

                $model->type = 0;
                $model->type_new = 0;
                $model->type_edit = 0;
                $model->type_destroy = 0;

                $model->type2 = 0;
                $model->type2_new = 0;
                $model->type2_eduit = 0;
                $model->type2_destroy = 0;

                $model->antriebsart = 0;
                $model->antriebsart_new = 0;
                $model->antriebsart_edit = 0;
                $model->antriebsart_destroy = 0;

                $model->betriebskontrollen = 0;
                $model->betriebskontrollen_new = 0;
                $model->betriebskontrollen_edit = 0;
                $model->betriebskontrollen_destroy = 0;

                $model->profintervall = 0;
                $model->profintervall_new = 0;
                $model->profintervall_edit = 0;
                $model->profintervall_destroy = 0;

                $model->art = 0;
                $model->art_new = 0;
                $model->art_edit = 0;
                $model->art_destroy = 0;

                $model->wartungsfirmafunction = 0;
                $model->wartungsfirmafunction_new = 0;
                $model->wartungsfirmafunction_edit = 0;
                $model->wartungsfirmafunction_destroy = 0;

                $model->anlagentyp = 0;
                $model->anlagentyp_new = 0;
                $model->anlagentyp_edit = 0;
                $model->anlagentyp_destroy = 0;

                $model->wartungsart = 0;
                $model->wartungsart_new = 0;
                $model->wartungsart_destroy = 0;
                $model->wartungsart_edit = 0;

                $model->anlagen_status = 0;
                $model->anlagen_status_new = 0;
                $model->anlagen_status_edit = 0;
                $model->anlagen_status_destroy = 0;

                $model->send_emails = 0;
                $model->excel_api = 0;

                $model->gerat_mangels = 0;
                $model->gerat_mangels_new = 0;
                $model->gerat_mangels_edit = 0;
                $model->gerat_mangels_destroy = 0;

                $model->profile = 0;
                $model->profile_edit = 0;

                $model->excel_inovice = 0;

                $model->norm = 0;
                $model->norm_new = 0;
                $model->norm_destroy = 0;
                $model->norm_edit = 0;

                $model->prufgrundlage = 0;
                $model->prufgrundlage_new = 0;
                $model->prufgrundlage_edit = 0;
                $model->prufgrundlage_destroy = 0;
                $model->save();
            }
        }
    }

    public function ensureAdminCoworkers() {

        $coworkers = User::find()->where(['role_id' => 4])->all();
        $coworker_anlagen_control_ids = array();

        foreach ($coworkers as $key => $worker) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()
                ->select('user_anlagen_coworker_control.*')
                ->leftJoin('tehnical', '`tehnical`.`id` = `user_anlagen_coworker_control`.`anlagen_id`')
                ->where(['user_anlagen_coworker_control.user_id' => $worker->id])
                ->with('tehnical')
                ->all();

            
            if($coworker_anlagen_control) {

               if (!array_key_exists($worker->id, $coworker_anlagen_control_ids)) {

                   $coworker_anlagen_control_ids[$worker->id]['user'] = array();
                   $coworker_anlagen_control_ids[$worker->id]['anlagen'] = array();
                }

                $user_ids = array();
                $anlagen_ids = array();

                foreach ($coworker_anlagen_control as $key => $value) {


                    array_push($user_ids, $value->tehnical->user_id);
                    array_push($anlagen_ids, $value->anlagen_id);
                }


                array_push($coworker_anlagen_control_ids[$worker->id]['user'], $user_ids);

                array_push($coworker_anlagen_control_ids[$worker->id]['anlagen'], $anlagen_ids);
            }

        }

        foreach ($coworker_anlagen_control_ids as $key => $value) {

            $types = $this->getAllTypes();
            $betreibers = array_unique($value['user'][0]);
            $betreibers = serialize($betreibers);
            $anlagen_string = array_unique($value['anlagen'][0]);
            $anlagen_string = serialize($anlagen_string);

            $coworker_control = CoworkerControll::find()->where(['user_id' => $key])->one();

            if($coworker_control) {
                //update
                $coworker_control->tehnical_type_string_array = $types;
                $coworker_control->kunden_betraiber_string_array = $betreibers;
                $coworker_control->anlagen_string = $anlagen_string;
                $coworker_control->save();
            }else {
                //create

                $model = new CoworkerControll();
                $model->tehnical_type_string_array = $types;
                $model->kunden_betraiber_string_array = $betreibers;
                $model->anlagen_string = $anlagen_string;
                $model->user_id = $key;
                $model->kunden = 1;
                $model->kunden_new = 0;
                $model->kunden_edit = 0;
                $model->kunden_destroy = 0;
                $model->kuden_send_email = 0;
                $model->kunden_export = 0;

                $model->tehnical = 1;
                $model->tehnical_new = 0;
                $model->tehnical_edit = 0;
                $model->tehnical_destroy = 0;
                $model->tehnical_import_data = 0;
                $model->tehnical_export_data = 0;
                $model->tehnical_add_lat_lang = 0;
                $model->tehnical_prufungen = 0;
                $model->tehnical_pdf_preview = 0;

                $model->tehnic_review = 1;
                $model->tehnic_review_new = 0;
                $model->tehnic_review_edit = 0;
                $model->tehnic_review_destroy = 0;
                $model->tehnic_review_send_email = 0;

                $model->karte = 0;
                $model->karteMarked = 0;
                $model->karteWeek = 0;

                $model->aufzugswarter = 0;
                $model->aufzugswarter_new = 0;
                $model->aufzugswarter_edit = 0;
                $model->aufzugswarter_destroy = 0;

                $model->wartungsfirma = 0;
                $model->wartungsfirma_new = 0;
                $model->wartungsfirma_edit = 0;
                $model->wartungsfirma_destry = 0;

                $model->type = 0;
                $model->type_new = 0;
                $model->type_edit = 0;
                $model->type_destroy = 0;

                $model->type2 = 0;
                $model->type2_new = 0;
                $model->type2_eduit = 0;
                $model->type2_destroy = 0;

                $model->antriebsart = 0;
                $model->antriebsart_new = 0;
                $model->antriebsart_edit = 0;
                $model->antriebsart_destroy = 0;

                $model->betriebskontrollen = 0;
                $model->betriebskontrollen_new = 0;
                $model->betriebskontrollen_edit = 0;
                $model->betriebskontrollen_destroy = 0;

                $model->profintervall = 0;
                $model->profintervall_new = 0;
                $model->profintervall_edit = 0;
                $model->profintervall_destroy = 0;

                $model->art = 0;
                $model->art_new = 0;
                $model->art_edit = 0;
                $model->art_destroy = 0;

                $model->wartungsfirmafunction = 0;
                $model->wartungsfirmafunction_new = 0;
                $model->wartungsfirmafunction_edit = 0;
                $model->wartungsfirmafunction_destroy = 0;

                $model->anlagentyp = 0;
                $model->anlagentyp_new = 0;
                $model->anlagentyp_edit = 0;
                $model->anlagentyp_destroy = 0;

                $model->wartungsart = 0;
                $model->wartungsart_new = 0;
                $model->wartungsart_destroy = 0;
                $model->wartungsart_edit = 0;

                $model->anlagen_status = 0;
                $model->anlagen_status_new = 0;
                $model->anlagen_status_edit = 0;
                $model->anlagen_status_destroy = 0;

                $model->send_emails = 0;
                $model->excel_api = 0;

                $model->gerat_mangels = 0;
                $model->gerat_mangels_new = 0;
                $model->gerat_mangels_edit = 0;
                $model->gerat_mangels_destroy = 0;

                $model->profile = 0;
                $model->profile_edit = 0;

                $model->excel_inovice = 0;

                $model->norm = 0;
                $model->norm_new = 0;
                $model->norm_destroy = 0;
                $model->norm_edit = 0;

                $model->prufgrundlage = 0;
                $model->prufgrundlage_new = 0;
                $model->prufgrundlage_edit = 0;
                $model->prufgrundlage_destroy = 0;
                $model->save();
            }
        }
    }

    public function actionCoworkers() {

        $coworkers = User::find()->where(['role_id' => 4])->all();
        $coworker_anlagen_control_ids = array();

        foreach ($coworkers as $key => $worker) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()
                ->select('user_anlagen_coworker_control.*')
                ->leftJoin('tehnical', '`tehnical`.`id` = `user_anlagen_coworker_control`.`anlagen_id`')
                ->where(['user_anlagen_coworker_control.user_id' => $worker->id])
                ->with('tehnical')
                ->all();

            
            if($coworker_anlagen_control) {

               if (!array_key_exists($worker->id, $coworker_anlagen_control_ids)) {

                   $coworker_anlagen_control_ids[$worker->id]['user'] = array();
                   $coworker_anlagen_control_ids[$worker->id]['anlagen'] = array();
                }

                $user_ids = array();
                $anlagen_ids = array();

                foreach ($coworker_anlagen_control as $key => $value) {


                    array_push($user_ids, $value->tehnical->user_id);
                    array_push($anlagen_ids, $value->anlagen_id);
                }

                array_push($coworker_anlagen_control_ids[$worker->id]['user'], $user_ids);
                array_push($coworker_anlagen_control_ids[$worker->id]['anlagen'], $anlagen_ids);
            }

        }

        foreach ($coworker_anlagen_control_ids as $key => $value) {

            $types = $this->getAllTypes();
            $betreibers = array_unique($value['user'][0]);
            $betreibers = serialize($betreibers);
            $anlagen_string = array_unique($value['anlagen'][0]);
            $anlagen_string = serialize($anlagen_string);

            $coworker_control = CoworkerControll::find()->where(['user_id' => $key])->one();

            if($coworker_control) {
                //update
                $coworker_control->tehnical_type_string_array = $types;
                $coworker_control->kunden_betraiber_string_array = $betreibers;
                $coworker_control->anlagen_string = $anlagen_string;
                $coworker_control->save();
            }else {
                //create

                $model = new CoworkerControll();
                $model->tehnical_type_string_array = $types;
                $model->kunden_betraiber_string_array = $betreibers;
                $model->anlagen_string = $anlagen_string;
                $model->user_id = $key;
                $model->kunden = 1;
                $model->kunden_new = 0;
                $model->kunden_edit = 0;
                $model->kunden_destroy = 0;
                $model->kuden_send_email = 0;
                $model->kunden_export = 0;

                $model->tehnical = 1;
                $model->tehnical_new = 0;
                $model->tehnical_edit = 0;
                $model->tehnical_destroy = 0;
                $model->tehnical_import_data = 0;
                $model->tehnical_export_data = 0;
                $model->tehnical_add_lat_lang = 0;
                $model->tehnical_prufungen = 0;
                $model->tehnical_pdf_preview = 0;

                $model->tehnic_review = 1;
                $model->tehnic_review_new = 0;
                $model->tehnic_review_edit = 0;
                $model->tehnic_review_destroy = 0;
                $model->tehnic_review_send_email = 0;

                $model->karte = 0;
                $model->karteMarked = 0;
                $model->karteWeek = 0;

                $model->aufzugswarter = 0;
                $model->aufzugswarter_new = 0;
                $model->aufzugswarter_edit = 0;
                $model->aufzugswarter_destroy = 0;

                $model->wartungsfirma = 0;
                $model->wartungsfirma_new = 0;
                $model->wartungsfirma_edit = 0;
                $model->wartungsfirma_destry = 0;

                $model->type = 0;
                $model->type_new = 0;
                $model->type_edit = 0;
                $model->type_destroy = 0;

                $model->type2 = 0;
                $model->type2_new = 0;
                $model->type2_eduit = 0;
                $model->type2_destroy = 0;

                $model->antriebsart = 0;
                $model->antriebsart_new = 0;
                $model->antriebsart_edit = 0;
                $model->antriebsart_destroy = 0;

                $model->betriebskontrollen = 0;
                $model->betriebskontrollen_new = 0;
                $model->betriebskontrollen_edit = 0;
                $model->betriebskontrollen_destroy = 0;

                $model->profintervall = 0;
                $model->profintervall_new = 0;
                $model->profintervall_edit = 0;
                $model->profintervall_destroy = 0;

                $model->art = 0;
                $model->art_new = 0;
                $model->art_edit = 0;
                $model->art_destroy = 0;

                $model->wartungsfirmafunction = 0;
                $model->wartungsfirmafunction_new = 0;
                $model->wartungsfirmafunction_edit = 0;
                $model->wartungsfirmafunction_destroy = 0;

                $model->anlagentyp = 0;
                $model->anlagentyp_new = 0;
                $model->anlagentyp_edit = 0;
                $model->anlagentyp_destroy = 0;

                $model->wartungsart = 0;
                $model->wartungsart_new = 0;
                $model->wartungsart_destroy = 0;
                $model->wartungsart_edit = 0;

                $model->anlagen_status = 0;
                $model->anlagen_status_new = 0;
                $model->anlagen_status_edit = 0;
                $model->anlagen_status_destroy = 0;

                $model->send_emails = 0;
                $model->excel_api = 0;

                $model->gerat_mangels = 0;
                $model->gerat_mangels_new = 0;
                $model->gerat_mangels_edit = 0;
                $model->gerat_mangels_destroy = 0;

                $model->profile = 0;
                $model->profile_edit = 0;

                $model->excel_inovice = 0;

                $model->norm = 0;
                $model->norm_new = 0;
                $model->norm_destroy = 0;
                $model->norm_edit = 0;

                $model->prufgrundlage = 0;
                $model->prufgrundlage_new = 0;
                $model->prufgrundlage_edit = 0;
                $model->prufgrundlage_destroy = 0;
                $model->save();
            }
        }

        return $this->redirect(['index']);
    }

    protected function getAllTypes() {

        $types = Type::find()->all();
        $type_names = ArrayHelper::map($types, 'id', 'id');
        return serialize($type_names);
    }

    public function actionKarte($id)
    {

        $model = $this->findModel($id);
        $google = new GoogleCordinate();
        $current_user = $this->currentUser();

      #  if ( $model->lat && $model->lng ) {  

                $google->lat =  $model->lat;
                $google->lng =  $model->lng;
                $google->tehnical_id =  $model->id;
                $google->user_id = $current_user->id;

                if ( $google->save() ) {

                    Yii::$app->session->setFlash('success', 'You have successfully added Anlagen to the Map !');
                    return $this->redirect(['view', 'id' => $model->id]);
                } else {
                    Yii::$app->session->setFlash('success', 'This Anlagen has been already added to the Map !');
                    return $this->redirect(['view', 'id' => $model->id]);
                }
      #  }else {
       #     Yii::$app->session->setFlash('success', 'Please fill out coordinates of Anlagen !');
       #     return $this->redirect(['view', 'id' => $model->id]);            
      #  }
    }

    public function actionUnmark($id)
    {

        $google = GoogleCordinate::find()->where(['tehnical_id' => $id])->one();
 
        if ($google->delete()) {
            Yii::$app->session->setFlash('success', 'You have successfully Unmarked Anlagen from the Map !');
        }
        return $this->redirect(['view', 'id' => $id]);
    }

    /**
     * Displays a single Tehnical model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        
        $model = $this->findModel($id);
        $rest_api = RestApiAuth::find()->where(['company_id'=> $model->user_id])->one();
        $show_google_map = $this->renderGoogleMap($model);
        $desktop = $this->isDesktop();
        $google_map_exist = GoogleCordinate::find()->where(['tehnical_id'=> $id])->one();
        $documents = $model->getTehnicalDocuments()->orderBy('id DESC')->all();

        return $this->render('view', [
            'model' => $model,
            'show_google_map' => $show_google_map,
            'desktop' => $desktop,
            'google_map_exist' => $google_map_exist,
            'documents' => $documents,
            'rest_api' => $rest_api
        ]);
    }

    public function actionCopy($id)
    {

        $model = $this->findModel($id);
        $data = $model->attributes;

        $copy_model = new Tehnical();
        $copy_model->setAttributes($data);
        $copy_model->FabriksNr = "Fill the data";

        if ( $copy_model->save() ) {  

            $aufzugswarters = $model->getAufzugswarters()->all();
            $aufzugswarters_ids = ArrayHelper::map($aufzugswarters,'id', 'id');
            $this->ensure_copy_aufzugswarters( $aufzugswarters_ids, $copy_model );
            
            return $this->redirect(['update', 'id' => $copy_model->id]);
        } else {
            return $this->render('view', [
                'model' => $model,
            ]);
        }
    }

    protected function ensureinvoceData($model) {
        $data = InvoiceData::find()->where(['KundenNr' => $model->KundenNr])->one();

        if(!$data) {
            $data = new InvoiceData();
            $data->KundenNr = $model->KundenNr;
            $data->Kunden_Rechnungszusatz = $model->Kunden_Rechnungszusatz;
            $data->Kunden_Strase = $model->Kunden_Straße;
            $data->Kunden_PLZ = $model->Kunden_PLZ;
            $data->Kunden_Ort = $model->Kunden_Ort;
            $data->Kunden_Referenzzeilec = $model->Kunden_Referenzzeile;
            $data->Kunden_Rechnungsemail = $model->Kunden_Rechnungsemail;
            $data->save();
        }
        return true;
    }



    /**
     * Creates a new Tehnical model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {

        $model = new Tehnical();
        $model->active = 1;
        $desktop = $this->isDesktop();
        $role = Role::find()->where(['name' => "Client"])->one();
        $clients = $role->getUsers()->all();
        $workers = User::find()->where(['role_id' => 4])->all();

        if ($model->load(Yii::$app->request->post())) {



            $model->ErstelltAm = date("Y.m.d");

            if ( $model->LetzteDate ) {

                $model->LetzteDate = date("d-m-Y", strtotime($model->LetzteDate));
                $model->LetzteDate = str_replace("-",".", $model->LetzteDate);
            }

            $aufzugswarters = Yii::$app->request->post()["Tehnical"]["aufzugswarter_id"];

            if ( $model->save() ) {  

                $this->ensureinvoceData($model);
                $this->ensure_aufzugswarters( $aufzugswarters, $model );

                if( $model->workerID != null && $model->workerID != "" ) {
                    $this->createOrUpdateUserAnlagenCoworkerControl($model->id, null, $model->workerID);
                    $this->ensure_coworekr_lifts($model->workerID);

                }
                
                return $this->redirect(['view', 'id' => $model->id]);
            } else {
            return $this->render('create', [
                'model' => $model,
                'desktop' => $desktop,
                'clients' => $clients,
            ]);
        } 
        } else { 
            return $this->render('create', [
                'model' => $model,
                'desktop' => $desktop,
                'clients' => $clients,
                'workers' => $workers
            ]);
        }
    }

    private function url(){
      return sprintf(
        "%s://%s%s",
        isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http',
        $_SERVER['SERVER_NAME'],
        $_SERVER['REQUEST_URI']
      );
    }


    public function actionImport()
    {
        $excel_object = new Tehnical();
        set_time_limit(0);

        $excel_file = UploadedFile::getInstance($excel_object, 'file');
        $inputFile = null;
        $excelformat = null;


        if ( $excel_file != null || $excel_file != "" ) {
            $excelformat = 'document.'.$excel_file->extension;
        }
        if(isset($excelformat) && $excelformat) {

            $excel_file->saveAs('uploads/'.$excelformat);
            $inputFile = 'uploads/'.$excelformat;    
        }


        try {

            $inputFileType = \PHPExcel_IOFactory::identify($inputFile);
            $objectReader = \PHPExcel_IOFactory::createReader($inputFileType);
            $excelObj = $objectReader->load($inputFile);
        }catch(Exception $e) {

        }
/*
        $url = "http://" . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
        $url = str_replace("tehnical/index", "", $url);
        $url = str_replace("tehnical/import", "", $url);
        $url = $url. $inputFile;
*/
        $date_now = date('Y-m-d H:i');

        $cron = CronXls::find()->one();
        $cron->date = $date_now;
        $cron->url = $inputFile;
        $cron->save();

        $this->redirect(['tehnical/index']);

/*
        $sheets = [0, 1, 2, 3];

        $last_sheet = end( $sheets );

        foreach ($sheets as $key => $sheet) {

            $worksheet = $excelObj->getSheet($sheet);
            $lastRow = $worksheet->getHighestRow();
            $lastColumn = $worksheet->getHighestColumn();

            for ($row = 1; $row <= $lastRow; $row++) {

                if ( $row == 1 || $row == 2 ) {

                    continue;
                }

                $rowData = $worksheet->rangeToArray('A'.$row.":".$lastColumn.$row, NULL, TRUE, FALSE);

                if($rowData[0][1] == "" || $rowData[0][1] == null) {

                    if ( $sheet == $last_sheet && $row == $lastRow ) {
                        gc_collect_cycles();
                        unlink('uploads/'.$excelformat); 
                        $this->ensureAdminCoworkers();
                        $this->redirect(['tehnical/index']);

                    }

                    continue;
                }

                $AnlagenIdWithAT = $rowData[0][3];
                $AnlagenId = filter_var($AnlagenIdWithAT, FILTER_SANITIZE_NUMBER_INT);
                $anlagen_exist = Tehnical::findOne($AnlagenId);   
                $Email = $rowData[0][1];
                $user = $this->check_or_create_user($Email, $rowData);

                if ( $anlagen_exist ) {

                    $this->import_new_or_update_database_from_xls_file( $anlagen_exist, $user, $rowData, $sheet );
                } else {

                    $anlagen = new Tehnical();
                    $anlagen->id = $AnlagenId;
                    $anlagen->ErstelltAm = date("Y.m.d");
                    $this->import_new_or_update_database_from_xls_file( $anlagen, $user, $rowData, $sheet );
                }

                if ( $sheet == $last_sheet && $row == $lastRow ) {

                    gc_collect_cycles();
                    unlink('uploads/'.$excelformat); 
                    $this->ensureAdminCoworkers();
                    $this->redirect(['tehnical/index']);
                }
            }
        }
        $this->ensureAdminCoworkers();
        $this->redirect(['tehnical/index']);
        */
    }

    private function renderData() {
        $excel_object = new Tehnical();
        $searchModel = new TehinicalSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $searchModelGlobal = new TehinicalGlobalBackendSearch();
        $tehnicals_mobile = $searchModelGlobal->search(Yii::$app->request->queryParams);
        $google = new GoogleCordinate();
        $desktop = $this->isDesktop();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'excel_object' => $excel_object,
            'google' => $google,
            'desktop' => $desktop,
            'searchModelGlobal' => $searchModelGlobal,
            'tehnicals_mobile' => $tehnicals_mobile,
        ]);        
    }

    public function actionReview($id) {
        $tehnical = $this->findModel($id);
        $model = new TehnicReview();
        $s3_env = S3_ENV;
        $desktop = $this->isDesktop();
        $user = $this->currentUser();
        $betraiber_user = User::find()->where(['id' => $tehnical->user_id])->one();
        $betreiber_pdf = $betraiber_user->BetreiberPdf;
        $model->Prufungsdatum = date("d.m.Y");
        $mangel = new Magel();
        $frist = new Frist();
        
        if ( $model->load( Yii::$app->request->post() ) ) {

            $allgemeiner_zustand_images = UploadedFile::getInstances($model, 'AllgemeinerZustandImages');
            $wartungsbuch = UploadedFile::getInstances($model, 'Wartungsbuch');
            $model->author_email = $user->username;
            $model->author_full_name = $user->fuullName();
            $model->coworker_active = (int)$model->sendToAPI;

            if ( $tehnical->Type == "Spielplatzgeräte" ) {

                $images = UploadedFile::getInstances($model, 'image_file');
                $gerat_images = UploadedFile::getInstances($model, 'gerat_image');
            }else {

                $images = UploadedFile::getInstances($model, 'files');
                $gerat_images = null;
            }

            $model->tehnic_id = $id;
            $model->datum = date("Y.m.d");

            $pdf_name = $this->ensurePDFformatName($model);
            $image_name = $this->ensureImageformatName($model);
            $this->ensureUpdateTehnicalDate($model);

            if ( !$model->DieInstandhaltungderAnlagewar ) {
                $model->DieInstandhaltungderAnlagewar = "gut";
            }

            if($model->save()) {

                $mangelsInputArray = array();
                if( $model->mangelsInputArray ) {
                    $mangelsInputArray = json_decode($model->mangelsInputArray);
                }
                
                $mangel_images = UploadedFile::getInstances($model, 'mangel_image');
                
                $this->ensureUploadMangelImages( $mangel_images, $image_name, $model, $s3_env, $mangelsInputArray, $mangel );
                $this->ensureUploadImages( $images, $image_name, $model, $s3_env );
                $this->ensureUploadGeratImages( $gerat_images, $image_name, $model, $s3_env );

                if($allgemeiner_zustand_images && count($allgemeiner_zustand_images)) {
                    $this->ensureUploadAllgemeinerZustandImages( $allgemeiner_zustand_images, $image_name, $model, $s3_env, "AllgemeinerZustandImages" );
                }

                if($wartungsbuch && count($wartungsbuch)) {
                    $this->ensureUploadAllgemeinerZustandImages( $wartungsbuch, $image_name, $model, $s3_env, "Wartungsbuch" );
                }

                $model->mangelsInputArray = $this->strucutreMangales($mangelsInputArray);

                $this->ensureUploadPDF( $model, $pdf_name, $s3_env, $betreiber_pdf );

                Yii::$app->session->setFlash('success', 'You have successfully uploaded document!');            
            }

            return $this->redirect(['view', 'id' => $id]);
        } else {
            return $this->render('review', [
                'model' => $model,
                'desktop' => $desktop,
                'tehnical' => $tehnical,
                'mangel' => $mangel,
                'frist' => $frist
            ]);
        }       
    }

    /**
     * Updates an existing Tehnical model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $desktop = $this->isDesktop();
        $role = Role::find()->where(['name' => "Client"])->one();
        $clients = $role->getUsers()->all();
        $workers = User::find()->where(['role_id' => 4])->all();
        
        if ($model->load(Yii::$app->request->post())) {
            $old_workerID = $model->getOldAttribute('workerID');
            $workerID = $model->workerID;

            $model->ErstelltAm = date("Y.m.d");
            if ( $model->LetzteDate ) {

                $model->LetzteDate = date("d-m-Y", strtotime($model->LetzteDate));
                $model->LetzteDate = str_replace("-",".", $model->LetzteDate);
            }

            $aufzugswarters = Yii::$app->request->post()["Tehnical"]["aufzugswarter_id"];

            if ( $model->save() ) {  

                $this->ensure_aufzugswarters( $aufzugswarters, $model );
                $this->ensure_updateAllANlagens( $model );

            //    if(($workerID && !$old_workerID && $workerID != '') || $workerID != $old_workerID ) {
                    $old_workerID = $model->getOldAttribute('workerID');
                    $workerID = $model->workerID;
                    $this->createOrUpdateUserAnlagenCoworkerControl($model->id, $old_workerID, $workerID);
                  //  $this->ensure_coworekr_lifts($workerID);
                    $this->ensureAdminCoworkers();
             //   }
            }

            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
                'desktop' => $desktop,
                'clients' => $clients,
                'workers' => $workers
            ]);
        }
    }

    private function ensure_updateAllANlagens( $model ) {
        $anglagens = Tehnical::find()->where(['KundenNr' => $model->KundenNr])->all();

        foreach ($anglagens as $key => $anlagen) 
        {
            $anlagen->Kunden_Rechnungszusatz = $model->Kunden_Rechnungszusatz;
            $anlagen->Kunden_Straße = $model->Kunden_Straße;
            $anlagen->Kunden_PLZ = $model->Kunden_PLZ;
            $anlagen->Kunden_Ort = $model->Kunden_Ort;
            $anlagen->Kunden_Referenzzeile = $model->Kunden_Referenzzeile;
            $anlagen->Kunden_Rechnungsemail = $model->Kunden_Rechnungsemail;
            $anlagen->KundenNr = $model->KundenNr;
            $anlagen->save();
       }
    }

    private function createOrUpdateUserAnlagenCoworkerControl($anlagen_id, $old_workerID, $workerID) {


        /***********************************OLD WORKER**************************************************/
        if( $old_workerID ) {
            $x = Yii::$app->db->createCommand("
                DELETE FROM user_anlagen_coworker_control 
                WHERE anlagen_id = '$anlagen_id' 

            ")->execute();
        }
        /**************************************END***********************************************/

        /***********************************NEW WORKER**************************************************/
        $model = new UserAnlagenCoworkerControl();
        $model->user_id = $workerID;
        $model->anlagen_id = $anlagen_id;
        $model->save();
        /**********************************END *NEW WORKER**************************************************/

       // $this->ensureAdminCoworkers();
    }

    public function actionWiederkehrende($id)
    {   
        $today = date("d.m.Y");
        $model = $this->findModel($id);
        $tehnical = $model->getTehnicReviews()->where(['Art' => ['Wiederkehrende Überprüfung', 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen']])->orderBy('id DESC')->one();

        $tehnical_reviews = $model->getTehnicReviews()->where(['Art' => ['Wiederkehrende Überprüfung', 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen']])->orderBy('id DESC')->all();

        $before_sort = [];

        foreach ($tehnical_reviews as $key => $tehnic_review) {
            
            if ( ($tehnic_review->Art == "Wiederkehrende Überprüfung" || $tehnic_review->Art == 'Wiederkehrende Überprüfung und Abnahmeprüfung nach Instandsetzungen') && $tehnic_review->Prufungsdatum ) {

                $date = str_replace(".","-", $tehnic_review->Prufungsdatum);
                $date = DateTime::createFromFormat('d-m-Y', $date)->format('Y-m-d');

                $tehnic_review->Prufungsdatum = $date;
                array_push($before_sort, $tehnic_review);
            }
        }

        #ArrayHelper::multisort($before_sort, ['Prufungsdatum', 'id'], [SORT_ASC, SORT_DESC]);
        ArrayHelper::multisort($before_sort, ['Prufungsdatum'], [SORT_DESC]);


        foreach ($before_sort as $key => $tehnic_review) {
            return $this->redirect(['tehnic-review/update', 'id' => $tehnic_review->id]);
        }
    }

/*
    public function actionPdfView($id)
    {

        $model = $this->findModel($id);

        $mpdf=new mPDF();
        $mpdf->WriteHTML($this->renderPartial('pdf',array('model'=>$model)));
        $mpdf->Output();
        exit;
    }*/


    /**
     * Deletes an existing Tehnical model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();
        return $this->redirect(['index']);
    }

    public function actionRemoveDocument($document_id, $id) {

        $env = S3_ENV;
        $document = TehnicalDocument::findOne($document_id);
        Yii::$app->get('s3bucket')->delete($env. 'documents/'.$document->url);
        $document->delete();

        return $this->redirect(['/tehnical/view', 'id' => $id]);
    }

    public function actionExportexcel()
    {
        $anlagens = Yii::$app->request->post('param1', null);

    }

    /**
     * Finds the Tehnical model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Tehnical the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Tehnical::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }

    protected function import_new_or_update_database_from_xls_file( $anlagen_exist, $user, $rowData, $sheet )
    {

        if ( $sheet == 0 ) {

            $this->import_new_or_update_database_from_xls_fileAufzug( $anlagen_exist, $user, $rowData );
        }else if ( $sheet == 1 ) {

            $this->import_new_or_update_database_from_xls_fileKFZ( $anlagen_exist, $user, $rowData );
        }else if ( $sheet == 2 ) {
            
            $this->import_new_or_update_database_from_xls_fileArbeitsmittel( $anlagen_exist, $user, $rowData );
        }else if ( $sheet == 3 )  {

            $this->import_new_or_update_database_from_xls_fileSpiel( $anlagen_exist, $user, $rowData );
        }
    }

/*
    protected function sendMailToUserWithUploadNewInformationWithoutTinmce($user, $lift, $user_invitation)
    {
        $emails = explode(", ", $lift->HausverwalterEmail);

        if ( $emails && $emails[0] && $emails[0] != "" ) {

            Yii::$app->mailer->compose('pdf_without_standard_content_without_tinmce', ['lift' => $lift, 'user_invitation' => $user_invitation])
                ->setFrom('office@anlagendoku.com')
                ->setTo($emails)
                ->setCc(array('belmir.hamidovic@anlagendoku.com'))
                ->setSubject($user_invitation->subject)
                ->send();
        }  
    }
*/
    protected function import_new_or_update_database_from_xls_fileAufzug( $anlagen, $user, $rowData )
    {

        $firma_id = $this->ensure_wartungs_firma( $rowData, 20 );
        $type_name = $this->ensure_type_excel( $rowData, 11 );
        $antriebsart_name = $this->ensure_antriebsart_excel( $rowData, 13 );
        $betriebskontrollen_name = $this->ensure_betriebskontrollen_excel( $rowData );
        $wartungsart_name = $this->ensure_wartungsart_excel( $rowData );
        $anlagentyp_name = $this->ensure_anlagentyp_excel( $rowData );
        $status_name = $this->ensure_anlagen_status_excel( $rowData );
        $evaluierung_name = $this->ensure_evaluierung_excel( $rowData );
        $evaluierungFristen = $this->ensure_evaluierungFristen_excel( $rowData ); 

        $worker = NULL;

        if( $rowData[0][25] ) {
            $worker = User::find()->where(['email' => $rowData[0][25]])->one();
        }
        
        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData[0][4];
        $anlagen->AdressePLZ = (string)$rowData[0][5];
        $anlagen->AdresseOrt = (string)$rowData[0][6];
        $anlagen->AdresseStreat = (string)$rowData[0][7];
        $anlagen->Zusatz = (string)$rowData[0][8];
        $anlagen->Hersteller = (string)$rowData[0][9];
        $anlagen->Baujahr = (string)$rowData[0][10];
        $anlagen->Type = $type_name;
        $anlagen->Anlagentyp = $rowData[0][12];
        $anlagen->Antriebsart = $antriebsart_name;
        $anlagen->Haltestellen = (string)$rowData[0][14];
        $anlagen->Ladestellen = (string)$rowData[0][15];
        $anlagen->Nennlast = (int)$rowData[0][16];
        $anlagen->Notruftel = $rowData[0][17];
        $anlagen->Schachtart = $rowData[0][18];
        $anlagen->evaluierungName = $evaluierung_name;
        $anlagen->fabric_id = $firma_id;
        $anlagen->Wartungsart = $wartungsart_name;
        $anlagen->Betriebskontrollen = $betriebskontrollen_name;
        $anlagen->Notizen = $rowData[0][24];
        $anlagen->worker_email = $rowData[0][25];
        $anlagen->LetzteDate = $rowData[0][26];
        $anlagen->PreisWP = $rowData[0][27];
        $anlagen->ObjektNr = $rowData[0][28];
        $anlagen->UIDNUMMER = $rowData[0][29];
        $anlagen->Fakturenadresse = $rowData[0][30];
        $anlagen->Hausverwalter = $rowData[0][31];
        $anlagen->HausverwalterEmail = $rowData[0][32];
        $anlagen->KontaktVerwalter = $rowData[0][33];
        $anlagen->status = $rowData[0][34];
        $anlagen->lat = $rowData[0][35];
        $anlagen->lng = $rowData[0][36];
        $anlagen->Personen = (int)$rowData[0][37];
        $anlagen->Nenngeschwindigkeit = (string)$rowData[0][38];
        $anlagen->Hubhohe = (string)$rowData[0][39];
        $anlagen->Gesetzt = (string)$rowData[0][40];
        $anlagen->Profintervall = (int)$rowData[0][41];
        $anlagen->evaluierungFristen = $evaluierungFristen;
        $anlagen->DatumderAbnahmeprufung = (string)$rowData[0][43];
        $anlagen->AnlagenNrKunde =(string)$rowData[0][44];
        $anlagen->KundenNr =(string)$rowData[0][45];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData[0][46];
        $anlagen->Kunden_Straße =(string)$rowData[0][47];
        $anlagen->Kunden_PLZ =(string)$rowData[0][48];
        $anlagen->Kunden_Ort =(string)$rowData[0][49];
        $anlagen->Kunden_Referenzzeile =(string)$rowData[0][50];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData[0][51];
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;


        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        }

        $this->ensure_aufzugswarters_excel( $rowData, $anlagen );
    }

    protected function import_new_or_update_database_from_xls_fileKFZ( $anlagen, $user, $rowData )
    {

        $firma_id = $this->ensure_wartungs_firma( $rowData, 17 );
        $type_name = $this->ensure_type_excel( $rowData, 11 );
        $prufgrundlage = $this->ensure_prufgrundlage_excel( $rowData, 12 );
        $antriebsart_name = $this->ensure_antriebsart_excel( $rowData, 13 );
        $worker = NULL;

        if( $rowData[0][19] ) {
            $worker = User::find()->where(['email' => $rowData[0][19]])->one();
        }

        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData[0][4];
        $anlagen->AdressePLZ = (string)$rowData[0][5];
        $anlagen->AdresseOrt = (string)$rowData[0][6];
        $anlagen->AdresseStreat = (string)$rowData[0][7];
        $anlagen->Zusatz = (string)$rowData[0][8];
        $anlagen->Hersteller = (string)$rowData[0][9];
        $anlagen->Baujahr = (string)$rowData[0][10];
        $anlagen->Type = $type_name;
        $anlagen->Prufgrundlage = $prufgrundlage;
        $anlagen->Antriebsart = $antriebsart_name;
        $anlagen->Parkeranagen = $rowData[0][14];
        $anlagen->AnzahltStellplatze = (string)$rowData[0][15];
        $anlagen->Nennlast = (int)$rowData[0][16];
        $anlagen->fabric_id = $firma_id;
        $anlagen->Notizen = $rowData[0][18];
        $anlagen->worker_email = $rowData[0][19];
        $anlagen->LetzteDate = $rowData[0][20];
        $anlagen->Profintervall = (string)$rowData[0][21];
        $anlagen->PreisWP = $rowData[0][22];
        $anlagen->ObjektNr = $rowData[0][23];
        $anlagen->UIDNUMMER = $rowData[0][24];
        $anlagen->Fakturenadresse = $rowData[0][25];
        $anlagen->Hausverwalter = $rowData[0][26];
        $anlagen->HausverwalterEmail = $rowData[0][27];
        $anlagen->KontaktVerwalter = $rowData[0][27];
        $anlagen->status = $rowData[0][29];
        $anlagen->lat = $rowData[0][30];
        $anlagen->lng = $rowData[0][31];
        $anlagen->AnlagenNrKunde =(string)$rowData[0][32];
        $anlagen->KundenNr =(string)$rowData[0][33];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData[0][34];
        $anlagen->Kunden_Straße =(string)$rowData[0][35];
        $anlagen->Kunden_PLZ =(string)$rowData[0][36];
        $anlagen->Kunden_Ort =(string)$rowData[0][37];
        $anlagen->Kunden_Referenzzeile =(string)$rowData[0][38];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData[0][39];
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;

        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        } 
    }

    protected function import_new_or_update_database_from_xls_fileArbeitsmittel( $anlagen, $user, $rowData )
    {

        $firma_id = $this->ensure_wartungs_firma( $rowData, 16 );
        $type_name = $this->ensure_type_excel( $rowData, 11 );
        $type2_name = $this->ensure_type2_excel( $rowData, 12 );
        $prufgrundlage = $this->ensure_prufgrundlage_excel( $rowData, 13 );
        $antriebsart_name = $this->ensure_antriebsart_excel( $rowData, 14 );

        $worker = NULL;

        if( $rowData[0][18] ) {
            $worker = User::find()->where(['email' => $rowData[0][18]])->one();
        }

        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData[0][4];
        $anlagen->AdressePLZ = (string)$rowData[0][5];
        $anlagen->AdresseOrt = (string)$rowData[0][6];
        $anlagen->AdresseStreat = (string)$rowData[0][7];
        $anlagen->Zusatz = (string)$rowData[0][8];
        $anlagen->Hersteller = (string)$rowData[0][9];
        $anlagen->Baujahr = (string)$rowData[0][10];
        $anlagen->Type = $type_name;
        $anlagen->type2 = $type2_name;
        $anlagen->Prufgrundlage = $prufgrundlage;
        $anlagen->Antriebsart = $antriebsart_name;
        $anlagen->Durchfahrtslichte_in_m = $rowData[0][15];
        $anlagen->fabric_id = $firma_id;
        $anlagen->Notizen = $rowData[0][17];
        $anlagen->worker_email = $rowData[0][18];
        $anlagen->LetzteDate = $rowData[0][19];
        $anlagen->Profintervall = (string)$rowData[0][20];
        $anlagen->PreisWP = $rowData[0][21];
        $anlagen->ObjektNr = $rowData[0][22];
        $anlagen->UIDNUMMER = $rowData[0][23];
        $anlagen->Fakturenadresse = $rowData[0][24];
        $anlagen->Hausverwalter = $rowData[0][25];
        $anlagen->HausverwalterEmail = $rowData[0][26];
        $anlagen->KontaktVerwalter = $rowData[0][27];
        $anlagen->status = $rowData[0][28];
        $anlagen->lat = $rowData[0][29];
        $anlagen->lng = $rowData[0][30];
        $anlagen->AnlagenNrKunde =(string)$rowData[0][31];
        $anlagen->KundenNr =(string)$rowData[0][32];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData[0][33];
        $anlagen->Kunden_Straße =(string)$rowData[0][34];
        $anlagen->Kunden_PLZ =(string)$rowData[0][35];
        $anlagen->Kunden_Ort =(string)$rowData[0][36];
        $anlagen->Kunden_Referenzzeile =(string)$rowData[0][37];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData[0][38];
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;


        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        } 
    }

    protected function import_new_or_update_database_from_xls_fileSpiel( $anlagen, $user, $rowData )
    {
        $norm = $this->ensure_norm_excel( $rowData, 12 );
        $prufgrundlage = $this->ensure_prufgrundlage_excel( $rowData, 13 );
        $firma_id = $this->ensure_wartungs_firma( $rowData, 14 ); 

        $worker = NULL;

        if( $rowData[0][16] ) {
            $worker = User::find()->where(['email' => $rowData[0][16]])->one();
        }

        $anlagen->user_id = $user->id;
        $anlagen->FabriksNr = (string)$rowData[0][4];
        $anlagen->AdressePLZ = (string)$rowData[0][5];
        $anlagen->AdresseOrt = (string)$rowData[0][6];
        $anlagen->AdresseStreat = (string)$rowData[0][7];
        $anlagen->Zusatz = (string)$rowData[0][8];
        $anlagen->Hersteller = (string)$rowData[0][9];
        $anlagen->Baujahr = (string)$rowData[0][10];
        $anlagen->Inspetkionsobjekt = $rowData[0][11];
        $anlagen->Norm = $norm;
        $anlagen->Prufgrundlage = $prufgrundlage;
        $anlagen->fabric_id = $firma_id;
        $anlagen->Notizen = $rowData[0][15];
        $anlagen->worker_email = $rowData[0][16];
        $anlagen->LetzteDate = $rowData[0][17];
        $anlagen->Profintervall = (string)$rowData[0][18];
        $anlagen->PreisWP = $rowData[0][19];
        $anlagen->ObjektNr = $rowData[0][20];
        $anlagen->UIDNUMMER = $rowData[0][21];
        $anlagen->Fakturenadresse = $rowData[0][22];
        $anlagen->Hausverwalter = $rowData[0][23];
        $anlagen->HausverwalterEmail = $rowData[0][24];
        $anlagen->KontaktVerwalter = $rowData[0][25];
        $anlagen->status = $rowData[0][26];
        $anlagen->lat = $rowData[0][27];
        $anlagen->lng = $rowData[0][28];
        $anlagen->AnlagenNrKunde =(string)$rowData[0][29];
        $anlagen->KundenNr =(string)$rowData[0][30];
        $anlagen->Kunden_Rechnungszusatz =(string)$rowData[0][31];
        $anlagen->Kunden_Straße =(string)$rowData[0][32];
        $anlagen->Kunden_PLZ =(string)$rowData[0][33];
        $anlagen->Kunden_Ort =(string)$rowData[0][34];
        $anlagen->Kunden_Referenzzeile =(string)$rowData[0][35];
        $anlagen->Kunden_Rechnungsemail =(string)$rowData[0][36];    
        $anlagen->Type = "Spielplatzgeräte";
        $anlagen->workerID = $worker && $worker->id ? $worker->id : null;
        $anlagen->save();
        $anlagen_id = $anlagen->id;


        if( $worker && isset($worker->id) ) {

            $coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen->id])->one();

            if( isset($coworker_anlagen_control) ) {

                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->save();
            }else {
                $coworker_anlagen_control = new UserAnlagenCoworkerControl();
                $coworker_anlagen_control->user_id = $worker->id;
                $coworker_anlagen_control->anlagen_id = $anlagen_id;
                $coworker_anlagen_control->save();
            }
                
        }else {
            $old_coworker_anlagen_control = UserAnlagenCoworkerControl::find()->where(['anlagen_id' => $anlagen_id])->one();
            if( $old_coworker_anlagen_control ) {
                $old_coworker_anlagen_control->delete();
            }
        } 
    }

    protected function check_or_create_user($Email, $rowData)
    {
        $user = User::find()->where(['email'=> $Email])->one();

        if ( !$user  ) {

            $user = new User();

            $user_password = bin2hex(openssl_random_pseudo_bytes(10));
            $user_email =  $rowData[0][1];
            $send_mail = $rowData[0][2];

            $user->username = $user_email;
            $user->email = $user_email;
            $user->role_id = 2;
            $user->send_mail = $send_mail;
            $user->setPassword($user_password);
            $user->client_password = $user_password;
            $user->generateAuthKey();
            $user->Betreiber = $rowData[0][0];
            $user->save();


         #   if ( $send_mail === true || $send_mail === "true" ) {

         #       $this->sendMailToUserWithoutTinmceDescription($user, $user_password);
         #       sleep(1);
         #   }

            return $user;
        }else {

            return $user;
        }
    }

    protected function ensure_wartungs_firma( $rowData, $row_num )
    {
        $firma_name = (string)$rowData[0][$row_num];
        $firma  = Wartungsfirma::find()->where(['name'=> $firma_name])->one();

        if ( $firma ) {

            return $firma->id;

        }elseif ( $firma_name ) {

            $firma = new Wartungsfirma();
            $firma->name = (string)$rowData[0][20];
            $firma->save();
            return $firma->id;
        }else {
            return false;
        }
    }

    protected function ensure_aufzugswarters( $aufzugswarters, $model )
    {


        if ( $aufzugswarters != "" || $aufzugswarters != null ) {

            AufzugswarterTehnicJoin::deleteAll('tehnic_id = :tehnic_id', [':tehnic_id' => (int)$model->id ]);

            foreach ($aufzugswarters as $key => $aufzugswarters_id) {

                $model_lift = new AufzugswarterTehnicJoin();
                $model_lift->tehnic_id = (int)$model->id;
                $model_lift->aufzugswarter_id = (int)$aufzugswarters_id;
                $model_lift->save();
            }
        }
    }

    protected function ensure_copy_aufzugswarters($aufzugswarters_ids, $copy_model)
    {
        foreach ($aufzugswarters_ids as $key => $aufzugswarters_id) {

            $model_lift = new AufzugswarterTehnicJoin();
            $model_lift->tehnic_id = (int)$copy_model->id;
            $model_lift->aufzugswarter_id = (int)$aufzugswarters_id;
            $model_lift->save();
        }
    }

    protected function ensure_aufzugswarters_excel( $rowData, $anlagen ) 
    {
        $aufzugswarters_string = $rowData[0][23];
        $aufzugswarters_array = explode(', ', $aufzugswarters_string);
        AufzugswarterTehnicJoin::deleteAll('tehnic_id = :tehnic_id', [':tehnic_id' => (int)$anlagen->id ]);

        foreach ($aufzugswarters_array as $key => $aufzugswarter) {
            if ( $aufzugswarter != "" || $aufzugswarter != null ) {

                $aufzugswarter_object  = Aufzugswarter::find()->where(['name'=> $aufzugswarter])->one();

                if ( $aufzugswarter_object && $aufzugswarter_object->id ) {
                   $this->create_aufzugswarter_tehnic_join_from_excel($aufzugswarter_object, $anlagen);   
                }else {

                    $aufzugswarter_new = new Aufzugswarter();
                    $aufzugswarter_new->name = $aufzugswarter;
                    if ( $aufzugswarter_new->save() ) {
                    
                        $this->create_aufzugswarter_tehnic_join_from_excel($aufzugswarter_new, $anlagen);
                    }               
                }
            }
        }
    }

    protected function create_aufzugswarter_tehnic_join_from_excel($aufzugswarter_new, $anlagen)
    {   
        $model_lift = new AufzugswarterTehnicJoin();
        $model_lift->tehnic_id = (int)$anlagen->id;
        $model_lift->aufzugswarter_id = (int)$aufzugswarter_new->id;
        $model_lift->save();        
    }

    protected function ensure_type_excel( $rowData, $row_num )
    {
        $type_name = (string)$rowData[0][$row_num];
        $type  = Type::find()->where(['name'=> $type_name])->one();

        if ( $type ) {

            return $type_name;
        }elseif($type_name != null || $type_name != "") {

            $type = new Type();
            $type->name = $type_name;
            $type->save();
            return $type_name;
        }else {
            return null;
        }
    }

    protected function ensure_type2_excel( $rowData, $row_num )
    {
        $type_name = (string)$rowData[0][$row_num];
        $type  = Type2::find()->where(['name'=> $type_name])->one();

        if ( $type ) {

            return $type_name;
        }elseif($type_name != null || $type_name != "") {

            $type = new Type2();
            $type->name = $type_name;
            $type->save();
            return $type_name;
        }else {
            return null;
        }
    }

    protected function ensure_norm_excel( $rowData, $row_num )
    {
        $norm_name = (string)$rowData[0][$row_num];
        $norm  = Norm::find()->where(['name'=> $norm_name])->one();

        if ( $norm ) {

            return $norm_name;
        }elseif($norm_name != null || $norm_name != "") {

            $norm = new Norm();
            $norm->name = $norm_name;
            $norm->save();
            return $norm_name;
        }else {
            return null;
        }
    }

    protected function ensure_prufgrundlage_excel( $rowData, $row_num )
    {
        $prufgrundlage_name = (string)$rowData[0][$row_num];
        $prufgrundlage  = Prufgrundlage::find()->where(['name'=> $prufgrundlage_name])->one();

        if ( $prufgrundlage ) {

            return $prufgrundlage_name;
        }elseif($prufgrundlage_name != null || $prufgrundlage_name != "") {

            $prufgrundlage = new Prufgrundlage();
            $prufgrundlage->name = $prufgrundlage_name;
            $prufgrundlage->save();
            return $prufgrundlage_name;
        }else {
            return null;
        }
    }

    protected function ensure_antriebsart_excel( $rowData, $row_num )
    {
        $antriebsart_name = $rowData[0][$row_num];
        $antriebsart  = Antriebsart::find()->where(['name'=> $antriebsart_name])->one();

        if ( $antriebsart ) {

            return $antriebsart_name;
        }elseif($antriebsart_name != null || $antriebsart_name != "") {

            $antriebsart = new Antriebsart();
            $antriebsart->name = $antriebsart_name;
            $antriebsart->save();
            return $antriebsart_name;
        }else {
            return null;
        }
    }

    protected function ensure_betriebskontrollen_excel( $rowData )
    {
        $betriebskontrollen_name = $rowData[0][22];
        $betriebskontrollen  = Betriebskontrollen::find()->where(['name'=> $betriebskontrollen_name])->one();

        if ( $betriebskontrollen ) {
            return $betriebskontrollen_name;
        }elseif( $betriebskontrollen_name != null || $betriebskontrollen_name != "" ) {
            $betriebskontrollen = new Betriebskontrollen();
            $betriebskontrollen->name = $betriebskontrollen_name;
            $betriebskontrollen->save();
            return $betriebskontrollen_name;
        }else {
            return null;
        }    
    }

    protected function ensure_wartungsart_excel( $rowData )
    {
        $wartungsart_name = $rowData[0][21];
        $wartungsart  = Wartungsart::find()->where(['name'=> $wartungsart_name])->one();

        if ( $wartungsart ) {
            return $wartungsart_name;
        }elseif( $wartungsart_name != null || $wartungsart_name != "" ) {
            $wartungsart = new Wartungsart();
            $wartungsart->name = $wartungsart_name;
            $wartungsart->save();
            return $wartungsart_name;
        }else {
            return null;
        }       
    }

    protected function ensure_anlagentyp_excel( $rowData )
    {
        $anlagentyp_name = $rowData[0][12];
        $anlagentyp  = Anlagentyp::find()->where(['name'=> $anlagentyp_name])->one();

        if ( $anlagentyp ) {
            return $anlagentyp_name;
        }elseif( $anlagentyp_name != null || $anlagentyp_name != "" ) {
            $anlagentyp = new Anlagentyp();
            $anlagentyp->name = $anlagentyp_name;
            $anlagentyp->save();
            return $anlagentyp_name;
        }else {
            return null;
        }         
    }

    protected function ensure_anlagen_status_excel( $rowData )
    {
        $status_name = $rowData[0][34];
        $status  = AnlagenStatus::find()->where(['name'=> $status_name])->one();

        if ( $status ) {
            return $status_name;
        }elseif( $status_name != null || $status_name != "" ) {
            $status = new AnlagenStatus();
            $status->name = $status_name;
            $status->save();
            return $status_name;
        }else {
            return null;
        }   
    }

    protected function ensure_evaluierung_excel( $rowData )
    {
        $evaul_name = $rowData[0][19];
        $evaluierung  = Evaluierung::find()->where(['name'=> $evaul_name])->one();

        if ( $evaluierung ) {
            return $evaul_name;
        }elseif( $evaul_name != null || $evaul_name != "" ) {
            $evaluierung = new Evaluierung();
            $evaluierung->name = $evaul_name;
            $evaluierung->save();
            return $evaul_name;
        }else {
            return null;
        }   
    }


    protected function ensure_evaluierungFristen_excel( $rowData )
    {
        $date = $rowData[0][42];
        if ( $date != "" || $date != null) {

            $date = str_replace(".","-", $date);
            $date = DateTime::createFromFormat('d-m-Y', $date)->format('Y-m-d');

            return  $date;  
            }else {
                return null;
        }
    }
/*
    protected function SendMailToHausverwalters($rowData)
    {
        $emails_string = $rowData[0][32];
        $emails_array = explode(', ', $emails_string);

        foreach ($emails_array as $key => $email) {
            if ( $email != "" ) {
                
            }
        }
    }
*/
    protected function sendMailToUserWithoutTinmceDescription($user, $user_password)
    {
        Yii::$app->mailer->compose('contact_without_tinmce', ['model' => $user, 'password' => $user_password])
            ->setFrom('office@anlagendoku.com')
            ->setTo($user->email)
            ->setSubject("Anlagendoku Invitation")
            ->send();        
    }

    protected function renderGoogleMap($model)
    {

        $start_destination = new LatLng(['lat' => 48.1662537, 'lng' => 16.38633440000001]);
        $anlagen = new LatLng(['lat' => $model->lat, 'lng' => $model->lng]);
        $coord = new LatLng(['lat' => 48.3510193, 'lng' => 16.327288199999998]);
        $map = new Map([
            'center' => $start_destination,
            'zoom' => 14,
            'width' => '100%'
        ]);

        $directionsRequest = new DirectionsRequest([

            'origin' => $start_destination,
            'destination' => $anlagen,
            'travelMode' => TravelMode::DRIVING
        ]);

        // Lets configure the polyline that renders the direction
        $polylineOptions = new PolylineOptions([
            'strokeColor' => '#FFAA00',
            'draggable' => true
        ]);

        // Now the renderer
        $directionsRenderer = new DirectionsRenderer([
            'map' => $map->getName(),
            'polylineOptions' => $polylineOptions
        ]);

        // Finally the directions service
        $directionsService = new DirectionsService([
            'directionsRenderer' => $directionsRenderer,
            'directionsRequest' => $directionsRequest
        ]);

        // Thats it, append the resulting script to the map
        $map->appendScript($directionsService->getJs());

        // Lets add a marker now
        $marker = new Marker([
            'position' => $start_destination,
            'title' => 'My Home',
        ]);

        // Provide a shared InfoWindow to the marker
        $marker->attachInfoWindow(
            new InfoWindow([
                'content' => '<p>My Home</p>'
            ])
        );

        // Add marker to the map
        $map->addOverlay($marker);

        // Now lets write a polygon
        $coords = [
        ];

        $polygon = new Polygon([
      //      'paths' => $coords
        ]);

        // Add a shared info window
        $polygon->attachInfoWindow(new InfoWindow([
                'content' => '<p>This is my Office</p>'
            ]));

        // Add it now to the map
        $map->addOverlay($polygon);


        // Lets show the BicyclingLayer :)
       // $bikeLayer = new BicyclingLayer(['map' => $map->getName()]);

        // Append its resulting script
      //  $map->appendScript($bikeLayer->getJs());
        
        return $map->display();      
    }

    public function display_pagination_unlesss_SearchQueryParams()
    {   
        if ( !isset($_GET['page']) && Yii::$app->request->queryParams && $_GET['TehinicalGlobalBackendSearch']["globalSearch"] != "" ) {
            return false;
        }else {
            return true;
        }
    }


    public function actionDocuments($id) {

        $tehnical = $this->findModel($id);
        $model = new TehnicalDocument();
        $s3_env = S3_ENV;
        $desktop = $this->isDesktop();
        $user = $this->currentUser();

        if ( $model->load( Yii::$app->request->post() ) ) {

            $documents = UploadedFile::getInstances($model, 'files');

            $document_name = $this->ensureDocumentformatName($model);

            $this->ensureUploadDocuments( $documents, $document_name, $id, $s3_env );
            Yii::$app->session->setFlash('success', 'You have successfully uploaded document!');            

            return $this->redirect(['view', 'id' => $id]);
        } else {
            return $this->render('documents', [
                'model' => $model,
                'desktop' => $desktop,
                'tehnical' => $tehnical,
            ]);
        }       
    }
}
