<?php

namespace backend\controllers;

use Yii;
use common\models\TehnicReview;
use common\models\search\TehinicReviewGlobalBackendSearch;
use common\models\Tehnical;
use common\models\Images;
use common\models\search\TehinicReviewSearch;
use backend\models\SendInvitationForm;
use common\models\GeratMangel;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\web\UploadedFile;
use yii\web\Response;
use kartik\mpdf\Pdf;
use DateTime;
use DateTimeZone;
use yii\data\Pagination;
use common\models\Magel;
use common\models\User;

/**
 * TehnicReviewController implements the CRUD actions for TehnicReview model.
 */
class TehnicReviewController extends PdfBaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all TehnicReview models.
     * @return mixed
     */
    public function actionIndex()
    {   
        $searchModel = new TehinicReviewSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $searchModelGlobal = new TehinicReviewGlobalBackendSearch();
        $tehnical_reviews_mobile = $searchModelGlobal->search(Yii::$app->request->queryParams);



        $desktop = $this->isDesktop();

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'desktop' => $desktop,
            'searchModelGlobal' => $searchModelGlobal,
            'tehnical_reviews_mobile' => $tehnical_reviews_mobile,
        ]);
    }

    /**
     * Displays a single TehnicReview model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        $desktop = $this->isDesktop();
        return $this->render('view', [
            'model' => $this->findModel($id),
            'desktop' => $desktop,
        ]);
    }

    public function actionUpdateApi($prufungen_id) {
        $model = TehnicReview::findOne($prufungen_id);
        $model->coworker_active = 1;
        $model->save();
        return $this->redirect(['index']);
    }    

    /**
     * Creates a new TehnicReview model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new TehnicReview();
        $s3_env = S3_ENV;

        if ($model->load(Yii::$app->request->post()) /*&& $model->save()*/) {

                $images = UploadedFile::getInstances($model, 'files');
                $model->datum = date("Y.m.d");
                $pdf_name = $this->ensurePDFformatName($model);
                $this->ensureUpdateTehnicalDate($model);

            if ( $model->upload_pdf == "1" ) { /*  Upload PDF   */

                $url = UploadedFile::getInstance($model, 'url');

                /* PDF AND Image Name on S3 */

                if ( $url != null || $url != "" ) {

                    $urlformat = $pdf_name. "_". bin2hex(openssl_random_pseudo_bytes(5)).'.'.$url->extension;
                    $model->url = $urlformat;

                    $url->saveAs('uploads/'.$model->url);
                    Yii::$app->get('s3bucket')->upload($s3_env. 'pdf/'.$model->url, 'uploads/'.$model->url);
                    gc_collect_cycles();
                    unlink('uploads/'.$model->url);                 
                }


            }else/*if ( $model->Art == "Wiederkehrende Überprüfung" || $model->Art == "Abnahmeprüfung" || $model->Art == "Außerordentliche Prüfung" )*/  { /*  Generate PDF   */

                $pdf_random_name = $pdf_name. "_". bin2hex(openssl_random_pseudo_bytes(5)). ".pdf";

                $pdf_generation =  $this->storePDFOnS3($model, $pdf_random_name);

                if ( $pdf_generation  ) {

                    $model->url = $pdf_random_name;
                    Yii::$app->get('s3bucket')->upload($s3_env. 'pdf/'.$model->url, 'uploads/'.$model->url);
                    gc_collect_cycles();
                    unlink('uploads/'.$model->url);                   
                }
            }

            if ( !$model->DieInstandhaltungderAnlagewar ) {

                $model->DieInstandhaltungderAnlagewar = "gut";
            }

            if($model->save()) {

                if ($images != null || $images != "") {

                    foreach ($images as $image) {

                        $img = new Images();

                        $imageformat = $pdf_name. "_". bin2hex(openssl_random_pseudo_bytes(5)).'.'.$image->extension;

                        $img->review_id = $model->id;
                        $img->name = $imageformat;

                        if ( $img->save() ) {

                            $image->saveAs('uploads/'.$imageformat);
                            Yii::$app->get('s3bucket')->upload($s3_env. 'image/'.$imageformat, 'uploads/'.$imageformat);
                            gc_collect_cycles();
                            unlink('uploads/'.$imageformat); 

                        }                  
                    }
                }
        
              #  if ($model->send_mail == "1") {

                   # $user = $model->getTehnic()->one()->getUser()->one();
                  #  $this->sendMailToUserWithUploadNewInformation($user, $model->getTehnic()->one());
             #   }

                Yii::$app->session->setFlash('success', 'You have successfully uploaded document!');                
            }
            return $this->redirect(['index']);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

   
    /**
     * Updates an existing TehnicReview model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id, $editedMangel= null)
    {
        $model = $this->findModel($id);
        $model_id = $model->id;
        $mangelsInputArray_db = Magel::find()->where(['tehnic_review_id_integer' => $model_id])->all();
        $tehnical = $model->getTehnic()->one();
        $s3_env = S3_ENV;
        $mangel = new Magel();
        $betraiber_user = User::find()->where(['id' => $tehnical->user_id])->one();
        $betreiber_pdf = $betraiber_user->BetreiberPdf;
        $mangels = array();
        foreach ($mangelsInputArray_db as $key => $value) {
            $object = (object) array(
                "type" => $value->type,
                "al" => $value->al,
                "mangel" => $value->mangel,
                "frist" => $value->frist,
                "file" => $value->photo,
                "id" => $value->id
            );

            array_push($mangels, $object);
        }

         $model->mangels = $mangels;


        if ($model->load(Yii::$app->request->post()) || $editedMangel) {

            $deleted_mangels = [];
            if($model->remove_magels != '') {
                $deleted_mangels = explode(",",$model->remove_magels);
                Magel::deleteAll(['id'=> $deleted_mangels]);
            }

            $allgemeiner_zustand_images = UploadedFile::getInstances($model, 'AllgemeinerZustandImages');
            $wartungsbuch = UploadedFile::getInstances($model, 'Wartungsbuch');
 
            $mangelsInputArray = array();

            if( $model->mangels ) {
                foreach ($model->mangels as $key=>$mang) {
                    if (in_array($mang->id, $deleted_mangels)) {
                       unset($model->mangels[$key]);
                    }
                }
            }

            if( $model->mangelsInputArray ) {
                $model->mangelsInputArray = array_reverse(json_decode($model->mangelsInputArray));

                foreach ($model->mangelsInputArray as $key=>$mang) {
                    if($mang->deleted == 0) {
                        array_push($mangelsInputArray, $mang);
                    }
                }
            }

            $mangel_images = UploadedFile::getInstances($model, 'mangel_image');
            $this->removeAllCheckedImages( $model, $s3_env );
            $this->removeAllCheckedAllgemeinerZustandImages( $model, $s3_env );
            $this->removeAllCheckedAllWartungsbuchImages( $model, $s3_env );

            $user = $model->getTehnic()->one()->getUser()->one();
            $model->datum = date("Y.m.d");
            $model->send_mail = "0";
            $this->ensureUpdateTehnicalDate($model);

            if ( $tehnical->Type == "Spielplatzgeräte" ) {

                $images = UploadedFile::getInstances($model, 'image_file');
                $gerat_images = UploadedFile::getInstances($model, 'gerat_image');
            }else {

                $images = UploadedFile::getInstances($model, 'files');
                $gerat_images = null;
            }

            $old_pdf = $model->OldAttributes['url'];
            $pdf_name = $this->ensurePDFformatName($model);
            $image_name = $this->ensureImageformatName($model);


            $this->ensureUploadMangelImages( $mangel_images, $image_name, $model, $s3_env, $mangelsInputArray, $mangel );
            $this->ensureUploadImages( $images, $image_name, $model, $s3_env );
            $this->ensureUploadGeratImages( $gerat_images, $image_name, $model, $s3_env );

            if($allgemeiner_zustand_images && count($allgemeiner_zustand_images)) {
                $this->ensureUploadAllgemeinerZustandImages( $allgemeiner_zustand_images, $image_name, $model, $s3_env, "AllgemeinerZustandImages" );
            }

            if($wartungsbuch && count($wartungsbuch)) {
                $this->ensureUploadAllgemeinerZustandImages( $wartungsbuch, $image_name, $model, $s3_env, "Wartungsbuch" );
            }

            $mangelsArray = (object)array_merge($model->mangels, $mangelsInputArray);

            $model->mangelsInputArray = $this->strucutreMangales($mangelsArray);

            $this->ensureUploadPDF( $model, $pdf_name, $s3_env, $betreiber_pdf );
            $this->deleteFromS3PDF($old_pdf, $s3_env);

            $model->save(); 

            if( $editedMangel ) {
                return $this->redirect(['tehnic-review/update', 'id' => $model->id, 'editedMangel' => false]);
            }else {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            
        } else {
            return $this->render('update', [
                'model' => $model,
                'tehnical' => $tehnical,
                'mangel' => $mangel
            ]);
        }
    }

    public function actionRemoveMangel($id, $tehnRevId) {

        $mangel = Magel::find()->where(['id' => $id])->one()->delete();
        return $this->redirect(['update', 'id' => $tehnRevId]);
    }

    /**
     * Deletes an existing TehnicReview model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $s3_env = S3_ENV;
        $url = $this->findModel($id)->url;
        $images = $this->findModel($id)->getImages()->all();
        $this->deleteFromS3Image($images, $s3_env);
        $this->deleteFromS3PDF($url, $s3_env);
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    public function actionEditMangel($id) {

        $model = Magel::findOne($id);

        var_dump($model); die;
    }

    public function actionSendEmail()
    {

        $searchModel = new TehinicReviewSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $user_information = new SendInvitationForm();
        $prufungen_id = (int)$_GET['prufungen_id'];
        $prufungen = TehnicReview::findOne($prufungen_id);
        $anlagen = $prufungen->getTehnic()->one();
        $desktop = $this->isDesktop();

        $this->initialize_prufungen_for_send_email($prufungen, $user_information);

        return $this->render('send_email', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'user_information' => $user_information,
            'anlagen' => $anlagen,
            'desktop' => $desktop,
        ]);
    }

    protected function initialize_prufungen_for_send_email($prufungen, $user_information)
    {   
        if ($prufungen && $prufungen->id) {
            $user = $prufungen->getTehnic()->one()->getUser()->one();

            $s3_path = S3_PATH;
            if ( $prufungen->url ) {

                $link = $s3_path."pdf/". $prufungen->url;
            } else {

                $link = null;
            }

            if ($user_information->load(Yii::$app->request->post()) ) {

                $prufungen->send_email = 1;
                $prufungen->save();

                $this->send_message_from_form($user, $user_information, $prufungen, $link);
            }
        }        
    }

    protected function send_message_from_form($user, $user_invitation, $prufungen, $link)
    {
        if ($user_invitation->send_standard_content_with_email) {

            $this->sendMailToUserWithUploadInformation($user, $prufungen->getTehnic()->one(), $prufungen, $user_invitation, $link);
        }else {

            $this->sendMailToUserWithUploadNewInformationWithoutStandardContent($user, $prufungen->getTehnic()->one(), $user_invitation, $link );
        }
        return $this->redirect('index');
    }

    /**
     * Finds the TehnicReview model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return TehnicReview the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = TehnicReview::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }


    protected function getAttachement($link) {

        $status = $this->downloadDocument($link);

        $path = Yii::getAlias('@webroot').'/uploads/';
        $file_name = basename($link);
        $url = $path.$file_name;

        if(file_put_contents($url, file_get_contents($link)) && $status) { 
            return $url;
        } 
        else { 
            return null;
        }  
    }

    protected function downloadDocument($link) {
        $path = Yii::getAlias('@webroot').'/uploads/';
        $file_name = $path.basename($link); 
           
        if(file_put_contents($file_name,file_get_contents($link))) { 
            return true;
        } 
        else { 
            return false;
        } 
    }


    protected function sendMailToUserWithUploadInformation($user, $lift, $prufungen, $user_invitation, $link)
    {
        $attach_url = null;

        if( $user_invitation->send_attachement ) {
            $attach_url = $this->getAttachement($link);
        }

        $objectNr = $lift->ifExistObjectNr($lift);
        $images = $prufungen->getImages();
        $mangel_photos = $prufungen->getMangels();


        if($lift && isset($lift->type2) && $lift->type2 != "") {

            $ifType2PrintType2OrType1 = $lift->type2;
        }else {

            $ifType2PrintType2OrType1 = $lift->Type;
        }

        if ( $objectNr ) { 
            $obj = $prufungen->Art . " ".$ifType2PrintType2OrType1. " ".$lift->AdressePLZ. " ".$lift->AdresseOrt. " ". $lift->AdresseStreat. " ". $lift->Zusatz. " Objekt Nr. ".$lift->ObjektNr ;
        }else {
            $obj = $prufungen->Art . " ".$ifType2PrintType2OrType1. " ".$lift->AdressePLZ. " ".$lift->AdresseOrt. " ". $lift->AdresseStreat. " ". $lift->Zusatz;
        }

        if ( $user_invitation->emails ) { # IF field emails in form have emails
            $emails = explode(", ", $user_invitation->emails);

            $mail = Yii::$app->mailer->compose('upload_update_pdf', ['model' => $user, 'lift' => $lift, 'prufungen' => $prufungen, 'user_invitation' => $user_invitation, 'link' => $link, 'images' => $images, 'mangel_photos' => $mangel_photos]);
            $mail->setFrom('office@anlagendoku.com');
            $mail->setTo($emails);
            $mail->setCc(array('belmir.hamidovic@anlagendoku.com'));
            $mail->setSubject($obj);
            if( $attach_url ) {
               $mail ->attach($attach_url);
            }
            $mail->send();

            if($attach_url) {
                unlink($attach_url);
            }
            Yii::$app->session->setFlash('success', 'The mail has been sent successfully !'); 
        }else {

            $emails = explode(", ", $lift->HausverwalterEmail);

            if ( $emails && $emails[0] && $emails[0] != "" ) {

                $mail = Yii::$app->mailer->compose('upload_update_pdf', ['model' => $user, 'lift' => $lift, 'prufungen' => $prufungen, 'user_invitation' => $user_invitation, 'link' => $link, 'images' => $images, 'mangel_photos' => $mangel_photos]);
                $mail->setFrom('office@anlagendoku.com');
                $mail->setTo($emails);
                $mail->setCc(array('belmir.hamidovic@anlagendoku.com'));
                $mail->setSubject($obj);
                if( $attach_url ) {
                   $mail ->attach($attach_url);
                }
                $mail->send();
                if($attach_url) {
                    unlink($attach_url);
                }
                Yii::$app->session->setFlash('success', 'The mail has been sent successfully !'); 
            }
        }         
    }

    protected function sendMailToUserWithUploadNewInformation($user, $lift)
    {

        $emails = explode(", ", $lift->HausverwalterEmail);
        
        if ( $emails && $emails[0] && $emails[0] != "" ) {

            Yii::$app->mailer->compose('upload_new_pdf', ['model' => $user, 'lift' => $lift])
                ->setFrom('office@anlagendoku.com')
                ->setTo($emails)
                ->setCc(array('belmir.hamidovic@anlagendoku.com'))
                ->setSubject("Freieingenieure PDF")
                ->send();
        }
    }

    protected function sendMailToUserWithUploadNewInformationWithoutStandardContent($user, $lift, $user_invitation, $link)
    {
        $attach_url = NULL;
        if( $user_invitation->send_attachement ) {
            $attach_url = $this->getAttachement($link);
        }

        if ( $user_invitation->emails ) { # IF field emails in form have emails
            $emails = explode(", ", $user_invitation->emails);

            $mail = Yii::$app->mailer->compose('pdf_without_standard_content', ['lift' => $lift, 'user_invitation' => $user_invitation]);
            $mail->setFrom('office@anlagendoku.com');
            $mail->setTo($emails);
            $mail->setCc(array('belmir.hamidovic@anlagendoku.com'));
            $mail->setSubject($user_invitation->subject);
            if( $attach_url ) {
               $mail ->attach($attach_url);
            }
            $mail->send();
            if($attach_url) {
                unlink($attach_url);
            }
            Yii::$app->session->setFlash('success', 'The mail has been sent successfully !');
        }else {

            $emails = explode(", ", $lift->HausverwalterEmail);

            if ( $emails && $emails[0] && $emails[0] != "" ) {

                $mail = Yii::$app->mailer->compose('pdf_without_standard_content', ['lift' => $lift, 'user_invitation' => $user_invitation]);
                $mail->setFrom('office@anlagendoku.com');
                $mail->setTo($emails);
                $mail->setCc(array('belmir.hamidovic@anlagendoku.com'));
                $mail->setSubject($user_invitation->subject);
                if( $attach_url ) {
                   $mail ->attach($attach_url);
                }
                $mail->send();
                if($attach_url) {
                    unlink($attach_url);
                }
                Yii::$app->session->setFlash('success', 'The mail has been sent successfully !');
            }
        }
    }

    public function display_pagination_unlesss_SearchQueryParams()
    {   

        if ( !isset($_GET['page']) && Yii::$app->request->queryParams && $_GET['TehinicReviewGlobalBackendSearch']["globalSearch"] != "" ) {
            return false;
        }else {
            return true;
        }
    }
}

