<?php

namespace backend\controllers;

use Yii;
use common\models\User;
use common\models\search\UserFrontendSearch;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\SendInvitationForm;
use common\models\Role;
use yii\data\Pagination;
/**
 * ArtController implements the CRUD actions for Art model.
 */
class SendEmailsController extends BaseController
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        if ($this->currentUser() && $this->currentUser()->role_id != "1")
        {
            $this->redirect(['site/index']);
        }
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Art models.
     * @return mixed
     */
    public function actionIndex()
    {
        $user_invitation = new SendInvitationForm();
        $user_invitation->setScenario('sendFromSendEmailController');

        if ($user_invitation->load(Yii::$app->request->post()) ) {

            $emails = explode(", ", $user_invitation->emails);

            Yii::$app->mailer->compose('send_emails', ['user_invitation' => $user_invitation])
                ->setFrom('office@anlagendoku.com')
                ->setTo($emails)
                ->setSubject($user_invitation->subject)
                ->send();
            Yii::$app->session->setFlash('success', 'The mails have been successfully sent !');
            return $this->redirect(['index']);
        }
        return $this->render('index', [
            'user_invitation' => $user_invitation,
        ]);
    }

}
